/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.graphiti.wizards;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.cdo.dawn.graphiti.DawnGraphitiUIPlugin;
import org.eclipse.emf.cdo.dawn.graphiti.wizards.AbstractDawnGraphitiWizardPage;
import org.eclipse.graphiti.dt.IDiagramType;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DawnGraphitiyDiagramTypeSelectionWizardPage
extends AbstractDawnGraphitiWizardPage {
    private static final String PAGE_DESC = "description";
    private static final String PAGE_TITLE = "title";
    private static final String DEFAULT_TYPE = "tutorial";
    private static final String SELECTED_TYPE = "selectedtype";
    private Combo comboBox;

    public DawnGraphitiyDiagramTypeSelectionWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected DawnGraphitiyDiagramTypeSelectionWizardPage(String pageName) {
        super(pageName);
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESC);
    }

    protected void createWizardContents(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setFont(parent.getFont());
        projectLabel.setText("set text");
        this.comboBox = new Combo(projectGroup, 2056);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.comboBox.setLayoutData((Object)data);
        this.comboBox.setFont(parent.getFont());
        this.comboBox.setVisibleItemCount(12);
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IDialogSettings dialogSettings = DawnGraphitiUIPlugin.getDefault().getDialogSettings();
                dialogSettings.put(DawnGraphitiyDiagramTypeSelectionWizardPage.SELECTED_TYPE, DawnGraphitiyDiagramTypeSelectionWizardPage.this.comboBox.getText());
            }
        });
        this.comboBox.setItems(this.getAllAvailableDiagramTypes());
        if (this.getInitialValue() != null) {
            this.comboBox.setText(this.getInitialValue());
        }
    }

    protected String[] getAllAvailableDiagramTypes() {
        Vector<String> diagramIds = new Vector<String>();
        IDiagramType[] iDiagramTypeArray = GraphitiUi.getExtensionManager().getDiagramTypes();
        int n = iDiagramTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDiagramType diagramType = iDiagramTypeArray[n2];
            diagramIds.add(diagramType.getId());
            ++n2;
        }
        return diagramIds.toArray(new String[0]);
    }

    protected String getInitialValue() {
        IDialogSettings dialogSettings = DawnGraphitiUIPlugin.getDefault().getDialogSettings();
        String selType = dialogSettings.get(SELECTED_TYPE);
        List<String> asList = Arrays.asList(this.comboBox.getItems());
        if (asList.contains(selType)) {
            return selType;
        }
        if (asList.contains(DEFAULT_TYPE)) {
            return DEFAULT_TYPE;
        }
        return null;
    }

    public String getText() {
        return this.comboBox.getText();
    }
}

