/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.server;

import java.util.concurrent.Callable;
import org.eclipse.emf.cdo.spi.server.IAuthenticationProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AuthenticationUtil {
    private static final ThreadLocal<IAuthenticationProtocol> AUTHENTICATION_PROTOCOL = new ThreadLocal();

    private AuthenticationUtil() {
    }

    public static IAuthenticationProtocol getAuthenticationProtocol() {
        return AUTHENTICATION_PROTOCOL.get();
    }

    public static <V> Callable<V> authenticatingOperation(IAuthenticationProtocol authenticationProtocol, final Callable<V> operation) {
        return new AuthenticatingOperation<V>(authenticationProtocol){

            @Override
            protected V doCall() throws Exception {
                return operation.call();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AuthenticatingOperation<V>
    implements Callable<V> {
        private final IAuthenticationProtocol authenticationProtocol;

        public AuthenticatingOperation(IAuthenticationProtocol authenticationProtocol) {
            this.authenticationProtocol = authenticationProtocol;
        }

        @Override
        public final V call() throws Exception {
            V result;
            try {
                AUTHENTICATION_PROTOCOL.set(this.authenticationProtocol);
                result = this.doCall();
            }
            finally {
                AUTHENTICATION_PROTOCOL.remove();
            }
            return result;
        }

        protected abstract V doCall() throws Exception;
    }
}

