/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.handlers;

import static org.eclipse.e4.ui.services.IServiceConstants.ACTIVE_SHELL;

import java.util.List;

import javax.inject.Named;

import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.epp.internal.logging.aeri.ide.IDEWorkflow;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.ServersPage;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.SetupWizard;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.SetupWizardDialog;
import org.eclipse.epp.internal.logging.aeri.ide.utils.Servers;
import org.eclipse.swt.widgets.Shell;

@Creatable
public class OpenConfigureServersDialogHandler {

    @Execute
    public void execute(IEclipseContext context, @Named(IDEWorkflow.CTX_SERVERS) List<IServerDescriptor> servers, final IEventBroker broker,
            UISynchronize uiSynchronize) {
        servers = Servers.sort(servers);

        Shell parentShell = (Shell) context.get(ACTIVE_SHELL);
        SetupWizard wizard = ContextInjectionFactory.make(SetupWizard.class, context);
        wizard.addPage(new ServersPage(servers, uiSynchronize, context));
        new SetupWizardDialog(parentShell, wizard).open();
    }
}
