/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.service.AbstractDataStorageService;
import org.eclipse.epp.internal.mpc.core.service.UserFavoritesService;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiPlugin;
import org.eclipse.epp.internal.mpc.ui.catalog.FavoritesDiscoveryStrategy;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalog;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeCatalogItem;
import org.eclipse.epp.internal.mpc.ui.css.StyleHelper;
import org.eclipse.epp.internal.mpc.ui.wizards.FavoritesViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.ImportFavoritesWizard;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.core.service.IUserFavoritesService;
import org.eclipse.equinox.internal.p2.discovery.AbstractDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogPage;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogViewer;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.userstorage.util.ConflictException;

public class ImportFavoritesPage
extends CatalogPage {
    private static final String INSTALL_SELECTED_SETTING = "installSelected";

    public ImportFavoritesPage(MarketplaceCatalog catalog) {
        super((Catalog)catalog);
        this.setTitle(Messages.ImportFavoritesPage_Title);
        this.setDescription(Messages.ImportFavoritesPage_Description);
    }

    public void setDiscoveryError(String error) {
        Shell shell = this.getShell();
        Control pageControl = this.getControl();
        if (shell != null && !shell.isDisposed() && pageControl != null && !pageControl.isDisposed()) {
            shell.getDisplay().asyncExec(() -> {
                Shell shell1 = this.getShell();
                Control pageControl1 = this.getControl();
                if (shell1 != null && !shell1.isDisposed() && pageControl1 != null && !pageControl1.isDisposed()) {
                    this.setErrorMessage(error);
                }
            });
        }
    }

    public static String handleDiscoveryError(String favoritesReference, Exception ex) {
        String errorMessage = null;
        if (UserFavoritesService.isInvalidFavoritesListException((Throwable)ex)) {
            boolean isUrl;
            boolean bl = isUrl = favoritesReference != null && (favoritesReference.toLowerCase().startsWith("http:") || favoritesReference.toLowerCase().startsWith("https:"));
            errorMessage = isUrl ? NLS.bind((String)Messages.ImportFavoritesActionLink_noFavoritesFoundAtUrl, (Object)favoritesReference) : NLS.bind((String)Messages.ImportFavoritesActionLink_noFavoritesFoundForUser, (Object)favoritesReference);
        } else if (UserFavoritesService.isInvalidUrlException((Throwable)ex)) {
            errorMessage = NLS.bind((String)Messages.ImportFavoritesActionLink_invalidUrl, (Object)favoritesReference);
        } else {
            String message = null;
            IStatus statusCause = MarketplaceClientCore.computeWellknownProblemStatus((Throwable)ex);
            message = statusCause != null ? statusCause.getMessage() : (ex.getMessage() != null && !"".equals(ex.getMessage()) ? ex.getMessage() : ex.getClass().getSimpleName());
            errorMessage = NLS.bind((String)Messages.ImportFavoritesActionLink_errorLoadingFavorites, (Object)message);
            MarketplaceClientCore.error((String)NLS.bind((String)Messages.ImportFavoritesActionLink_errorLoadingFavorites, (Object)message), (Throwable)ex);
        }
        return errorMessage;
    }

    protected FavoritesViewer getViewer() {
        return (FavoritesViewer)super.getViewer();
    }

    public void createControl(Composite parent) {
        new StyleHelper().on((Widget)parent).setId("ImportFavoritesPage");
        super.createControl(parent);
    }

    protected CatalogViewer doCreateViewer(Composite parent) {
        ImportFavoritesWizard wizard = this.getWizard();
        FavoritesViewer viewer = new FavoritesViewer(this.getCatalog(), this, wizard.getConfiguration());
        viewer.setMinimumHeight(480);
        viewer.createControl(parent);
        boolean installSelected = true;
        IDialogSettings section = this.getDialogSettings(false);
        if (section != null) {
            installSelected = section.getBoolean(INSTALL_SELECTED_SETTING);
        }
        viewer.setInstallSelected(installSelected);
        String initialFavoritesUrl = wizard.getInitialFavoritesUrl();
        this.setFavoritesUrl(viewer, initialFavoritesUrl);
        return viewer;
    }

    private IDialogSettings getDialogSettings(boolean create) {
        IDialogSettings dialogSettings = MarketplaceClientUiPlugin.getInstance().getDialogSettings();
        String sectionName = ((Object)((Object)this)).getClass().getName();
        IDialogSettings section = dialogSettings.getSection(sectionName);
        if (create && section == null) {
            section = dialogSettings.addNewSection(sectionName);
        }
        return section;
    }

    public void setFavoritesUrl(String url) {
        FavoritesViewer viewer = this.getViewer();
        this.setFavoritesUrl(viewer, url);
    }

    private void setFavoritesUrl(FavoritesViewer viewer, String url) {
        viewer.setFavoritesUrl(url == null ? "" : url.trim());
    }

    public void performImport() {
        this.setErrorMessage(null);
        this.saveInstallSelected();
        List<MarketplaceNodeCatalogItem> importFavorites = this.getSelection();
        if (importFavorites.isEmpty()) {
            return;
        }
        IUserFavoritesService userFavoritesService = this.findUserFavoritesService();
        if (userFavoritesService == null) {
            throw new UnsupportedOperationException();
        }
        ArrayList<INode> importNodes = new ArrayList<INode>();
        for (MarketplaceNodeCatalogItem item : importFavorites) {
            importNodes.add(item.getData());
        }
        try {
            Display display = Display.getCurrent();
            this.getContainer().run(true, false, monitor -> {
                try {
                    userFavoritesService.getStorageService().runWithLogin(() -> {
                        String errorMessage = null;
                        try {
                            userFavoritesService.addFavorites((Collection)importNodes, monitor);
                        }
                        catch (AbstractDataStorageService.NotAuthorizedException e1) {
                            errorMessage = Messages.ImportFavoritesPage_unauthorizedErrorMessage;
                        }
                        catch (ConflictException e2) {
                            errorMessage = Messages.ImportFavoritesPage_conflictErrorMessage;
                        }
                        if (errorMessage != null && !display.isDisposed()) {
                            String finalErrorMessage = errorMessage;
                            display.syncExec(() -> this.setErrorMessage(finalErrorMessage));
                        }
                        return null;
                    });
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            MarketplaceClientCore.error((Throwable)cause);
            this.setErrorMessage(NLS.bind((String)Messages.ImportFavoritesPage_unknownErrorMessage, (Object)cause));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public List<MarketplaceNodeCatalogItem> getSelection() {
        IStructuredSelection selection = this.getViewer().getSelection();
        List importFavorites = selection.toList();
        return new ArrayList<MarketplaceNodeCatalogItem>(importFavorites);
    }

    private IUserFavoritesService findUserFavoritesService() {
        IUserFavoritesService userFavoritesService = null;
        for (AbstractDiscoveryStrategy strategy : this.getCatalog().getDiscoveryStrategies()) {
            FavoritesDiscoveryStrategy favoritesStrategy;
            if (strategy instanceof FavoritesDiscoveryStrategy && (userFavoritesService = (favoritesStrategy = (FavoritesDiscoveryStrategy)strategy).getMarketplaceService().getUserFavoritesService()) != null) break;
        }
        return userFavoritesService;
    }

    public ImportFavoritesWizard getWizard() {
        return (ImportFavoritesWizard)super.getWizard();
    }

    public void dispose() {
        this.saveInstallSelected();
        super.dispose();
    }

    public boolean isInstallSelected() {
        return this.getViewer().isInstallSelected();
    }

    private void saveInstallSelected() {
        FavoritesViewer viewer = this.getViewer();
        if (viewer != null) {
            boolean installSelected = viewer.isInstallSelected();
            IDialogSettings dialogSettings = this.getDialogSettings(true);
            dialogSettings.put(INSTALL_SELECTED_SETTING, installSelected);
        }
    }
}

