/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs.lib;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import org.eclipse.jgit.lfs.lib.AbbreviatedLongObjectId;
import org.eclipse.jgit.lfs.lib.LongObjectId;
import org.eclipse.jgit.util.NB;

public abstract class AnyLongObjectId
implements Comparable<AnyLongObjectId> {
    long w1;
    long w2;
    long w3;
    long w4;
    private static final byte[] hexbyte = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final char[] hexchar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static boolean equals(AnyLongObjectId firstObjectId, AnyLongObjectId secondObjectId) {
        if (firstObjectId == secondObjectId) {
            return true;
        }
        return firstObjectId.w2 == secondObjectId.w2 && firstObjectId.w3 == secondObjectId.w3 && firstObjectId.w4 == secondObjectId.w4 && firstObjectId.w1 == secondObjectId.w1;
    }

    public final int getFirstByte() {
        return (int)(this.w1 >>> 56);
    }

    public final int getSecondByte() {
        return (int)(this.w1 >>> 48 & 0xFFL);
    }

    public final int getByte(int index) {
        long w;
        switch (index >> 3) {
            case 0: {
                w = this.w1;
                break;
            }
            case 1: {
                w = this.w2;
                break;
            }
            case 2: {
                w = this.w3;
                break;
            }
            case 3: {
                w = this.w4;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException(index);
            }
        }
        return (int)(w >>> 8 * (15 - (index & 0xF)) & 0xFFL);
    }

    @Override
    public final int compareTo(AnyLongObjectId other) {
        if (this == other) {
            return 0;
        }
        int cmp = NB.compareUInt64((long)this.w1, (long)other.w1);
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt64((long)this.w2, (long)other.w2);
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt64((long)this.w3, (long)other.w3);
        if (cmp != 0) {
            return cmp;
        }
        return NB.compareUInt64((long)this.w4, (long)other.w4);
    }

    public final int compareTo(byte[] bs, int p) {
        int cmp = NB.compareUInt64((long)this.w1, (long)NB.decodeInt64((byte[])bs, (int)p));
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt64((long)this.w2, (long)NB.decodeInt64((byte[])bs, (int)(p + 8)));
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt64((long)this.w3, (long)NB.decodeInt64((byte[])bs, (int)(p + 16)));
        if (cmp != 0) {
            return cmp;
        }
        return NB.compareUInt64((long)this.w4, (long)NB.decodeInt64((byte[])bs, (int)(p + 24)));
    }

    public final int compareTo(long[] bs, int p) {
        int cmp = NB.compareUInt64((long)this.w1, (long)bs[p]);
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt64((long)this.w2, (long)bs[p + 1]);
        if (cmp != 0) {
            return cmp;
        }
        cmp = NB.compareUInt64((long)this.w3, (long)bs[p + 2]);
        if (cmp != 0) {
            return cmp;
        }
        return NB.compareUInt64((long)this.w4, (long)bs[p + 3]);
    }

    public boolean startsWith(AbbreviatedLongObjectId abbr) {
        return abbr.prefixCompare(this) == 0;
    }

    public final int hashCode() {
        return (int)(this.w1 >> 32);
    }

    public final boolean equals(AnyLongObjectId other) {
        return other != null ? AnyLongObjectId.equals(this, other) : false;
    }

    public final boolean equals(Object o) {
        if (o instanceof AnyLongObjectId) {
            return this.equals((AnyLongObjectId)o);
        }
        return false;
    }

    public void copyRawTo(ByteBuffer w) {
        w.putLong(this.w1);
        w.putLong(this.w2);
        w.putLong(this.w3);
        w.putLong(this.w4);
    }

    public void copyRawTo(byte[] b, int o) {
        NB.encodeInt64((byte[])b, (int)o, (long)this.w1);
        NB.encodeInt64((byte[])b, (int)(o + 8), (long)this.w2);
        NB.encodeInt64((byte[])b, (int)(o + 16), (long)this.w3);
        NB.encodeInt64((byte[])b, (int)(o + 24), (long)this.w4);
    }

    public void copyRawTo(long[] b, int o) {
        b[o] = this.w1;
        b[o + 1] = this.w2;
        b[o + 2] = this.w3;
        b[o + 3] = this.w4;
    }

    public void copyRawTo(OutputStream w) throws IOException {
        AnyLongObjectId.writeRawLong(w, this.w1);
        AnyLongObjectId.writeRawLong(w, this.w2);
        AnyLongObjectId.writeRawLong(w, this.w3);
        AnyLongObjectId.writeRawLong(w, this.w4);
    }

    private static void writeRawLong(OutputStream w, long v) throws IOException {
        w.write((int)(v >>> 56));
        w.write((int)(v >>> 48));
        w.write((int)(v >>> 40));
        w.write((int)(v >>> 32));
        w.write((int)(v >>> 24));
        w.write((int)(v >>> 16));
        w.write((int)(v >>> 8));
        w.write((int)v);
    }

    public void copyTo(OutputStream w) throws IOException {
        w.write(this.toHexByteArray());
    }

    public void copyTo(byte[] b, int o) {
        AnyLongObjectId.formatHexByte(b, o + 0, this.w1);
        AnyLongObjectId.formatHexByte(b, o + 16, this.w2);
        AnyLongObjectId.formatHexByte(b, o + 32, this.w3);
        AnyLongObjectId.formatHexByte(b, o + 48, this.w4);
    }

    public void copyTo(ByteBuffer b) {
        b.put(this.toHexByteArray());
    }

    private byte[] toHexByteArray() {
        byte[] dst = new byte[64];
        AnyLongObjectId.formatHexByte(dst, 0, this.w1);
        AnyLongObjectId.formatHexByte(dst, 16, this.w2);
        AnyLongObjectId.formatHexByte(dst, 32, this.w3);
        AnyLongObjectId.formatHexByte(dst, 48, this.w4);
        return dst;
    }

    private static void formatHexByte(byte[] dst, int p, long w) {
        int o = p + 15;
        while (o >= p && w != 0L) {
            dst[o--] = hexbyte[(int)(w & 0xFL)];
            w >>>= 4;
        }
        while (o >= p) {
            dst[o--] = 48;
        }
    }

    public void copyTo(Writer w) throws IOException {
        w.write(this.toHexCharArray());
    }

    public void copyTo(char[] tmp, Writer w) throws IOException {
        this.toHexCharArray(tmp);
        w.write(tmp, 0, 64);
    }

    public void copyTo(char[] tmp, StringBuilder w) {
        this.toHexCharArray(tmp);
        w.append(tmp, 0, 64);
    }

    char[] toHexCharArray() {
        char[] dst = new char[64];
        this.toHexCharArray(dst);
        return dst;
    }

    private void toHexCharArray(char[] dst) {
        AnyLongObjectId.formatHexChar(dst, 0, this.w1);
        AnyLongObjectId.formatHexChar(dst, 16, this.w2);
        AnyLongObjectId.formatHexChar(dst, 32, this.w3);
        AnyLongObjectId.formatHexChar(dst, 48, this.w4);
    }

    static void formatHexChar(char[] dst, int p, long w) {
        int o = p + 15;
        while (o >= p && w != 0L) {
            dst[o--] = hexchar[(int)(w & 0xFL)];
            w >>>= 4;
        }
        while (o >= p) {
            dst[o--] = 48;
        }
    }

    public String toString() {
        return "AnyLongObjectId[" + this.name() + "]";
    }

    public final String name() {
        return new String(this.toHexCharArray());
    }

    public final String getName() {
        return this.name();
    }

    public AbbreviatedLongObjectId abbreviate(int len) {
        long a = AbbreviatedLongObjectId.mask(len, 1L, this.w1);
        long b = AbbreviatedLongObjectId.mask(len, 2L, this.w2);
        long c = AbbreviatedLongObjectId.mask(len, 3L, this.w3);
        long d = AbbreviatedLongObjectId.mask(len, 4L, this.w4);
        return new AbbreviatedLongObjectId(len, a, b, c, d);
    }

    public final LongObjectId copy() {
        if (this.getClass() == LongObjectId.class) {
            return (LongObjectId)this;
        }
        return new LongObjectId(this);
    }

    public abstract LongObjectId toObjectId();
}

