/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.CommandRef;
import org.eclipse.jgit.pgm.TextBuiltin;

public class CommandCatalog {
    private static final CommandCatalog INSTANCE = new CommandCatalog();
    private final ClassLoader ldr = Thread.currentThread().getContextClassLoader();
    private final Map<String, CommandRef> commands = new HashMap<String, CommandRef>();

    public static CommandRef get(String name) {
        return CommandCatalog.INSTANCE.commands.get(name);
    }

    public static CommandRef[] all() {
        return CommandCatalog.toSortedArray(CommandCatalog.INSTANCE.commands.values());
    }

    public static CommandRef[] common() {
        ArrayList<CommandRef> common = new ArrayList<CommandRef>();
        for (CommandRef c : CommandCatalog.INSTANCE.commands.values()) {
            if (!c.isCommon()) continue;
            common.add(c);
        }
        return CommandCatalog.toSortedArray(common);
    }

    private static CommandRef[] toSortedArray(Collection<CommandRef> c) {
        CommandRef[] r = c.toArray(new CommandRef[0]);
        Arrays.sort(r, new Comparator<CommandRef>(){

            @Override
            public int compare(CommandRef o1, CommandRef o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return r;
    }

    private CommandCatalog() {
        Enumeration<URL> catalogs = this.catalogs();
        while (catalogs.hasMoreElements()) {
            this.scan(catalogs.nextElement());
        }
    }

    private Enumeration<URL> catalogs() {
        try {
            String pfx = "META-INF/services/";
            return this.ldr.getResources("META-INF/services/" + TextBuiltin.class.getName());
        }
        catch (IOException err) {
            return new Vector().elements();
        }
    }

    private void scan(URL cUrl) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader cIn = new BufferedReader(new InputStreamReader(cUrl.openStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = cIn.readLine()) != null) {
                    if (line.length() <= 0 || line.startsWith("#")) continue;
                    this.load(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void load(String cn) {
        Class<TextBuiltin> clazz;
        try {
            clazz = Class.forName(cn, false, this.ldr).asSubclass(TextBuiltin.class);
        }
        catch (ClassNotFoundException notBuiltin) {
            return;
        }
        catch (ClassCastException notBuiltin) {
            return;
        }
        Command a = clazz.getAnnotation(Command.class);
        CommandRef cr = a != null ? new CommandRef(clazz, a) : new CommandRef(clazz);
        this.commands.put(cr.getName(), cr);
    }
}

