/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.creation.core.commands;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.jst.ws.internal.cxf.core.model.CXFDataModel;
import org.eclipse.jst.ws.internal.cxf.core.utils.FileUtils;
import org.eclipse.jst.ws.internal.cxf.core.utils.SpringUtils;
import org.eclipse.jst.ws.internal.cxf.creation.core.CXFCreationCorePlugin;
import org.eclipse.jst.ws.jaxws.core.utils.WSDLUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.ws.internal.wsrt.IWebService;
import org.eclipse.wst.ws.internal.wsrt.WebServiceInfo;

public class CXFDeployCommand
extends AbstractDataModelOperation {
    private static final String CXF_SERVLET = "org.apache.cxf.transport.servlet.CXFServlet";
    private IProject project;
    private IWebService webService;
    private CXFDataModel model;

    public CXFDeployCommand(String projectName, IWebService webService) {
        this.project = FileUtils.getProject((String)projectName);
        this.webService = webService;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        try {
            WebServiceInfo webServiceInfo = this.webService.getWebServiceInfo();
            String serverInstanceId = webServiceInfo.getServerInstanceId();
            String serverFactoryId = webServiceInfo.getServerFactoryId();
            if (serverInstanceId != null) {
                IServer server = ServerCore.findServer((String)serverInstanceId);
                String webCobComponentURL = ServerUtils.getEncodedWebComponentURL((IProject)this.project, (String)serverFactoryId, (IServer)server);
                String urlPattern = "";
                IModelProvider provider = ModelProviderManager.getModelProvider((IProject)this.project);
                Object modelProvider = provider.getModelObject();
                if (modelProvider instanceof WebApp) {
                    WebApp javaeeWebApp = (WebApp)modelProvider;
                    urlPattern = this.getURLPattern(javaeeWebApp);
                }
                if (modelProvider instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
                    org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)modelProvider;
                    urlPattern = this.getURLPattern(webApp);
                }
                urlPattern = urlPattern.substring(0, urlPattern.lastIndexOf("/"));
                String jaxwsEndpointAddress = SpringUtils.getEndpointAddress((IProject)this.project, (String)this.model.getConfigId());
                String wsdlAddress = String.valueOf(webCobComponentURL) + urlPattern + jaxwsEndpointAddress;
                String wsdlURL = String.valueOf(wsdlAddress) + "?wsdl";
                this.webService.getWebServiceInfo().setWsdlURL(wsdlURL);
                Definition definition = this.model.getWsdlDefinition();
                ExtensibilityElement extensibilityElement = WSDLUtils.getEndpointAddress((Definition)definition);
                if (extensibilityElement != null) {
                    if (extensibilityElement instanceof SOAPAddress) {
                        ((SOAPAddress)extensibilityElement).setLocationURI(wsdlAddress);
                    }
                    if (extensibilityElement instanceof SOAP12Address) {
                        ((SOAP12Address)extensibilityElement).setLocationURI(wsdlAddress);
                    }
                    WSDLUtils.writeWSDL((URL)this.model.getWsdlURL(), (Definition)definition);
                }
            }
        }
        catch (IOException ioe) {
            status = new Status(4, "org.eclipse.jst.ws.cxf.creation.core", ioe.getLocalizedMessage());
            CXFCreationCorePlugin.log(status);
        }
        catch (CoreException ce) {
            status = ce.getStatus();
            CXFCreationCorePlugin.log(status);
        }
        return status;
    }

    private String getURLPattern(WebApp javaeeWebApp) {
        List servlets = javaeeWebApp.getServlets();
        for (org.eclipse.jst.javaee.web.Servlet servlet : servlets) {
            if (!servlet.getServletClass().equals(CXF_SERVLET)) continue;
            List servletMappings = javaeeWebApp.getServletMappings();
            for (ServletMapping servletMapping : servletMappings) {
                List urlPatterns;
                if (!servletMapping.getServletName().equals(servlet.getServletName()) || (urlPatterns = servletMapping.getUrlPatterns()).size() <= 0) continue;
                String value = ((UrlPatternType)urlPatterns.get(0)).getValue();
                return value;
            }
        }
        return "";
    }

    private String getURLPattern(org.eclipse.jst.j2ee.webapplication.WebApp webApp) {
        EList servlets = webApp.getServlets();
        for (Servlet servlet : servlets) {
            if (!servlet.getServletClass().getJavaName().equals(CXF_SERVLET)) continue;
            EList servletMappings = webApp.getServletMappings();
            for (org.eclipse.jst.j2ee.webapplication.ServletMapping servletMapping : servletMappings) {
                if (!servletMapping.getServlet().getServletName().equals(servlet.getServletName())) continue;
                return servletMapping.getUrlPattern();
            }
        }
        return "";
    }

    public void setCXFDataModel(CXFDataModel model) {
        this.model = model;
    }

    public String getClientComponentType() {
        return "template.cxf.core";
    }
}

