/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.ws.annotations.core.AnnotationDefinition;
import org.eclipse.jst.ws.annotations.core.AnnotationsManager;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;
import org.eclipse.jst.ws.internal.jaxws.ui.views.AnnotationsView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsViewCategoryFilter
extends ViewerFilter {
    private static final String TAG_CATEGORY_NAME = "categoryName";
    private AnnotationsView annotationsView;
    private final StructuredViewer viewer;
    private List<Object> categories;

    public AnnotationsViewCategoryFilter(AnnotationsView annotationsView, StructuredViewer viewer) {
        this.annotationsView = annotationsView;
        this.viewer = viewer;
        this.categories = new ArrayList<Object>();
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        AnnotationDefinition annotationDefinition;
        if (element instanceof IType && (annotationDefinition = AnnotationsManager.getAnnotationDefinitionForType((IType)((IType)element))) != null) {
            return !this.categories.contains(annotationDefinition.getCategory());
        }
        return true;
    }

    public void filterAnnotations(List<Object> categories) {
        this.categories = categories;
        if (categories.size() > 0) {
            this.viewer.addFilter((ViewerFilter)this);
        } else {
            this.viewer.removeFilter((ViewerFilter)this);
        }
        this.annotationsView.refresh();
    }

    public List<Object> getCategories() {
        return this.categories;
    }

    public void init() {
        IDialogSettings settings = JAXWSUIPlugin.getDefault().getDialogSettings();
        String[] cat = settings.getArray(TAG_CATEGORY_NAME);
        if (cat != null) {
            String[] stringArray = cat;
            int n = cat.length;
            int n2 = 0;
            while (n2 < n) {
                String category = stringArray[n2];
                this.categories.add(category);
                ++n2;
            }
        }
        this.filterAnnotations(this.categories);
    }

    public void saveState() {
        IDialogSettings settings = JAXWSUIPlugin.getDefault().getDialogSettings();
        settings.put(TAG_CATEGORY_NAME, this.categories.toArray(new String[this.categories.size()]));
    }
}

