/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.UINodeBP;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.search.query.Operation;
import org.eclipse.jubula.client.ui.rcp.search.query.TextFinder;
import org.eclipse.jubula.client.ui.utils.JobUtils;
import org.eclipse.jubula.client.ui.utils.TreeViewerIterator;
import org.eclipse.jubula.client.ui.views.IMultiTreeViewerContainer;
import org.eclipse.jubula.client.ui.views.ITreeViewerContainer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class FindDialog<NODE>
implements DisposeListener {
    private static final List<String> RECENT = new ArrayList<String>(5);
    private static boolean lastforward = true;
    private static boolean lastwrapsearch = true;
    private static boolean lastregex = false;
    private static boolean lastcasesensitive = false;
    private Shell m_shell;
    private ITreeViewerContainer m_treeViewContainer;
    private Combo m_searchStringCombo;
    private Group m_directionGroup;
    private Button m_findForwardButton;
    private Button m_findBackwardButton;
    private Group m_optionsGroup;
    private Button m_wrapSearchCheck;
    private Button m_useRegExCheck;
    private Button m_caseSensitivCheck;
    private Link m_helpLink;
    private Button m_findButton;
    private Button m_cancelButton;
    private Label m_errorLabel;

    public FindDialog(Shell parentShell, ITreeViewerContainer listener) {
        this.m_shell = new Shell(parentShell);
        this.setTreeViewContainer(listener);
        this.init();
        Plugin.getHelpSystem().setHelp((Control)parentShell, "org.eclipse.jubula.client.ua.help.findDialogContextId");
    }

    private void init() {
        this.m_shell.setText(Messages.FindDialogTitle);
        this.createContent();
        Point location = this.m_shell.getDisplay().getCursorLocation();
        if (location.x + this.m_shell.getSize().x > this.m_shell.getDisplay().getPrimaryMonitor().getBounds().width) {
            location.x = this.m_shell.getDisplay().getPrimaryMonitor().getBounds().width - this.m_shell.getSize().x;
        }
        if (location.y + this.m_shell.getSize().y > this.m_shell.getDisplay().getPrimaryMonitor().getBounds().height) {
            location.y = this.m_shell.getDisplay().getPrimaryMonitor().getBounds().height - this.m_shell.getSize().y;
        }
        this.m_shell.setLocation(location);
    }

    private void createContent() {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        this.m_shell.setLayout((Layout)layout);
        Label findLabel = new Label((Composite)this.m_shell, 0);
        findLabel.setText(String.valueOf(Messages.FindDialogFind) + ":");
        FormData findLabelData = new FormData();
        findLabelData.left = new FormAttachment(0, 0);
        findLabelData.top = new FormAttachment(0, 10);
        findLabel.setLayoutData((Object)findLabelData);
        this.m_searchStringCombo = new Combo((Composite)this.m_shell, 2048);
        FormData searchStringTextData = new FormData();
        searchStringTextData.top = new FormAttachment((Control)findLabel, 0, 128);
        searchStringTextData.left = new FormAttachment((Control)findLabel, 10, 131072);
        searchStringTextData.right = new FormAttachment(100, 0);
        this.m_searchStringCombo.setLayoutData((Object)searchStringTextData);
        this.m_searchStringCombo.setItems(RECENT.toArray(new String[RECENT.size()]));
        if (this.m_searchStringCombo.getItemCount() == 0) {
            this.m_searchStringCombo.setText(Messages.FindDialogPhrase);
        } else {
            this.m_searchStringCombo.select(0);
        }
        this.m_searchStringCombo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    FindDialog.this.doCallBack();
                }
            }
        });
        this.createDirectionGroup();
        this.createOptionsGroup();
        this.createButtons();
        this.createHelpLink();
        this.m_errorLabel = new Label((Composite)this.m_shell, 0);
        this.m_errorLabel.setForeground(Display.getDefault().getSystemColor(3));
        FormData errorLabelData = new FormData();
        errorLabelData.top = new FormAttachment((Control)this.m_findButton, 5, 1024);
        errorLabelData.left = new FormAttachment(5, 0);
        errorLabelData.right = new FormAttachment(100, 0);
        this.m_errorLabel.setLayoutData((Object)errorLabelData);
        this.m_shell.pack();
    }

    private void createButtons() {
        this.m_findButton = new Button((Composite)this.m_shell, 8);
        this.m_findButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindDialog.this.doCallBack();
            }
        });
        this.m_findButton.setText(Messages.FindDialogFind);
        FormData findButtonData = new FormData();
        findButtonData.top = new FormAttachment((Control)this.m_optionsGroup, 15, 1024);
        findButtonData.left = new FormAttachment(20, 0);
        findButtonData.right = new FormAttachment(58, 0);
        this.m_findButton.setLayoutData((Object)findButtonData);
        this.m_cancelButton = new Button((Composite)this.m_shell, 0);
        this.m_cancelButton.setText(Messages.FindDialogClose);
        this.m_cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindDialog.this.m_shell.close();
            }
        });
        FormData cancelButtonData = new FormData();
        cancelButtonData.top = new FormAttachment((Control)this.m_optionsGroup, 15, 1024);
        cancelButtonData.left = new FormAttachment(62, 0);
        cancelButtonData.right = new FormAttachment(100, 0);
        this.m_cancelButton.setLayoutData((Object)cancelButtonData);
    }

    private void createHelpLink() {
        this.m_helpLink = new Link((Composite)this.m_shell, 524352);
        this.m_helpLink.setText("<a>" + IDialogConstants.HELP_LABEL + "</a>");
        this.m_helpLink.setToolTipText(IDialogConstants.HELP_LABEL);
        FormData helpLinkData = new FormData();
        helpLinkData.bottom = new FormAttachment((Control)this.m_findButton, 0, 1024);
        helpLinkData.left = new FormAttachment(0, 0);
        helpLinkData.right = new FormAttachment(16, 0);
        this.m_helpLink.setLayoutData((Object)helpLinkData);
        this.m_helpLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindDialog.this.helpPressed();
            }
        });
    }

    private void helpPressed() {
        if (this.m_shell != null) {
            Control c = this.m_shell.getDisplay().getFocusControl();
            while (c != null) {
                if (c.isListening(28)) {
                    c.notifyListeners(28, new Event());
                    break;
                }
                c = c.getParent();
            }
        }
    }

    private void createDirectionGroup() {
        this.m_directionGroup = new Group((Composite)this.m_shell, 0);
        this.m_directionGroup.setText(Messages.FindDialogDirection);
        FormLayout groupLayout = new FormLayout();
        this.m_directionGroup.setLayout((Layout)groupLayout);
        groupLayout.marginHeight = 5;
        groupLayout.marginWidth = 5;
        FormData groupDirectionData = new FormData();
        groupDirectionData.top = new FormAttachment((Control)this.m_searchStringCombo, 15, 1024);
        groupDirectionData.right = new FormAttachment(100, 0);
        groupDirectionData.left = new FormAttachment(0, 0);
        this.m_directionGroup.setLayoutData((Object)groupDirectionData);
        this.m_findForwardButton = new Button((Composite)this.m_directionGroup, 16);
        this.m_findForwardButton.setText(Messages.FindDialogForward);
        this.m_findForwardButton.setSelection(lastforward);
        FormData findForwardData = new FormData();
        findForwardData.left = new FormAttachment(0, 0);
        findForwardData.right = new FormAttachment(48, 0);
        this.m_findForwardButton.setLayoutData((Object)findForwardData);
        this.m_findBackwardButton = new Button((Composite)this.m_directionGroup, 16);
        this.m_findBackwardButton.setText(Messages.FindDialogBackward);
        this.m_findBackwardButton.setSelection(!lastforward);
        FormData findBackwardData = new FormData();
        findBackwardData.left = new FormAttachment(52, 0);
        findBackwardData.right = new FormAttachment(100, 0);
        this.m_findBackwardButton.setLayoutData((Object)findBackwardData);
    }

    private void createOptionsGroup() {
        this.m_optionsGroup = new Group((Composite)this.m_shell, 0);
        this.m_optionsGroup.setText(Messages.FindDialogOptions);
        FormData groupDirectionData = new FormData();
        groupDirectionData.top = new FormAttachment((Control)this.m_directionGroup, 10, 1024);
        groupDirectionData.right = new FormAttachment(100, 0);
        groupDirectionData.left = new FormAttachment(0, 0);
        this.m_optionsGroup.setLayoutData((Object)groupDirectionData);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.m_optionsGroup.setLayout((Layout)layout);
        this.m_caseSensitivCheck = new Button((Composite)this.m_optionsGroup, 32);
        this.m_caseSensitivCheck.setText(Messages.FindDialogCaseSen);
        this.m_caseSensitivCheck.setSelection(lastcasesensitive);
        FormData sensitiveData = new FormData();
        sensitiveData.left = new FormAttachment(0, 0);
        sensitiveData.right = new FormAttachment(48, 0);
        this.m_caseSensitivCheck.setLayoutData((Object)sensitiveData);
        this.m_wrapSearchCheck = new Button((Composite)this.m_optionsGroup, 32);
        this.m_wrapSearchCheck.setText(Messages.FindDialogWrap);
        this.m_wrapSearchCheck.setSelection(lastwrapsearch);
        FormData warpSearchData = new FormData();
        warpSearchData.left = new FormAttachment(52, 0);
        warpSearchData.right = new FormAttachment(100, 0);
        this.m_wrapSearchCheck.setLayoutData((Object)warpSearchData);
        this.m_useRegExCheck = new Button((Composite)this.m_optionsGroup, 32);
        this.m_useRegExCheck.setText(Messages.FindDialogRegEx);
        this.m_useRegExCheck.setSelection(lastregex);
        FormData regExData = new FormData();
        regExData.left = new FormAttachment(0, 0);
        regExData.top = new FormAttachment((Control)this.m_wrapSearchCheck, 5, 1024);
        this.m_useRegExCheck.setLayoutData((Object)regExData);
    }

    public void open() {
        this.m_shell.open();
    }

    public boolean isDisposed() {
        return this.m_shell == null ? true : this.m_shell.isDisposed();
    }

    private void doCallBack() {
        if (!this.isValidPart(this.m_treeViewContainer)) {
            this.m_shell.close();
            return;
        }
        final String searchText = this.m_searchStringCombo.getText();
        lastcasesensitive = this.m_caseSensitivCheck.getSelection();
        lastregex = this.m_useRegExCheck.getSelection();
        lastwrapsearch = this.m_wrapSearchCheck.getSelection();
        lastforward = this.m_findForwardButton.getSelection();
        if (RECENT.contains(searchText)) {
            RECENT.remove(searchText);
        }
        this.m_findButton.setEnabled(false);
        this.m_errorLabel.setText("");
        if (RECENT.size() > 4) {
            RECENT.remove(RECENT.size() - 1);
        }
        RECENT.add(0, searchText);
        ISelection treeSelection = this.getActiveTreeViewer().getSelection();
        final Object nodeToStart = treeSelection instanceof IStructuredSelection ? ((IStructuredSelection)treeSelection).getFirstElement() : null;
        final String jobName = Messages.UIJobFindingNodes;
        Job findingNodes = new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(jobName, -1);
                final boolean result = FindDialog.this.find(searchText, lastcasesensitive, lastregex, lastwrapsearch, lastforward, nodeToStart, monitor);
                Plugin.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!FindDialog.this.m_errorLabel.isDisposed()) {
                            if (!result) {
                                FindDialog.this.m_errorLabel.setText(Messages.FindDialogError);
                            } else {
                                FindDialog.this.m_errorLabel.setText("");
                            }
                            FindDialog.this.m_searchStringCombo.setItems(RECENT.toArray(new String[RECENT.size()]));
                            FindDialog.this.m_searchStringCombo.select(0);
                            FindDialog.this.m_searchStringCombo.setFocus();
                            FindDialog.this.m_findButton.setEnabled(true);
                        }
                    }
                });
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        JobUtils.executeJob((Job)findingNodes, null);
    }

    private boolean find(String queryString, boolean caseSensitive, boolean useRegex, boolean wrapSearch, boolean forward, Object nodeToStart, IProgressMonitor monitor) {
        final Object node = this.findGuiNode(queryString, caseSensitive, useRegex, wrapSearch, forward, nodeToStart, monitor);
        if (node != null) {
            Plugin.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    UINodeBP.selectNodeInTree(node, (AbstractTreeViewer)FindDialog.this.getActiveTreeViewer());
                }
            });
            return true;
        }
        return false;
    }

    private boolean isValidPart(ITreeViewerContainer treeViewerContainer) {
        return treeViewerContainer != null && treeViewerContainer.getTreeViewer() != null && !treeViewerContainer.getTreeViewer().getTree().isDisposed();
    }

    private Object findGuiNode(String queryString, boolean caseSensitive, boolean useRegex, boolean wrapSearch, boolean forward, Object nodeToStart, IProgressMonitor monitor) {
        TextFinder searcher = new TextFinder(queryString, Operation.create(caseSensitive, useRegex));
        if (monitor.isCanceled()) {
            return null;
        }
        if (wrapSearch || nodeToStart != null) {
            TreeViewerIterator iterator = new TreeViewerIterator(this.getActiveTreeViewer(), nodeToStart, forward);
            int noOfElements = iterator.getElements().size();
            monitor.beginTask(String.valueOf(Messages.SearchingIn) + " " + noOfElements + " " + Messages.Elements + "." + "." + ".", noOfElements);
            ILabelProvider labelProv = (ILabelProvider)this.getActiveTreeViewer().getLabelProvider();
            while (iterator.hasNext()) {
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    return null;
                }
                Object o = iterator.next();
                if (!searcher.matchSearchString(labelProv.getText(o))) continue;
                monitor.done();
                return o;
            }
        }
        return null;
    }

    public void widgetDisposed(DisposeEvent e) {
        this.closeShell();
    }

    private void closeShell() {
        if (!this.isDisposed()) {
            this.m_shell.close();
        }
    }

    public void setTreeViewContainer(ITreeViewerContainer viewContainer) {
        if (this.isValidPart(this.m_treeViewContainer)) {
            this.m_treeViewContainer.getTreeViewer().getTree().removeDisposeListener((DisposeListener)this);
        }
        if (this.isValidPart(viewContainer)) {
            viewContainer.getTreeViewer().getTree().addDisposeListener((DisposeListener)this);
        }
        this.m_treeViewContainer = viewContainer;
    }

    private TreeViewer getActiveTreeViewer() {
        if (this.m_treeViewContainer instanceof IMultiTreeViewerContainer) {
            return ((IMultiTreeViewerContainer)this.m_treeViewContainer).getActiveTreeViewer();
        }
        return this.m_treeViewContainer.getTreeViewer();
    }
}

