/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jubula.client.core.businessprocess.RunningAutBP;
import org.eclipse.jubula.client.ui.handlers.AbstractHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRunningAutHandler
extends AbstractHandler
implements IElementUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRunningAutHandler.class);
    private static Map<String, AutIdentifier> lastAutID = new HashMap<String, AutIdentifier>();

    protected AutIdentifier getRunningAut(ExecutionEvent event, String parameterKey) {
        if (Job.getJobManager().find((Object)this).length > 0) {
            return null;
        }
        Object runningAutObj = null;
        try {
            runningAutObj = event.getObjectParameterForExecution(parameterKey);
            if (runningAutObj instanceof AutIdentifier) {
                return (AutIdentifier)runningAutObj;
            }
            LOG.error(String.valueOf(Messages.RunningAUTParameter) + " " + "'" + runningAutObj + "'" + " " + Messages.NotOfCorrectType + ".");
            return null;
        }
        catch (ExecutionException executionException) {
            LOG.info(Messages.MissingRunningAUTParameter);
            Collection availableAUTs = RunningAutBP.getListOfDefinedRunningAuts();
            if (lastAutID.get(parameterKey) != null) {
                if (availableAUTs.contains(lastAutID.get(parameterKey))) {
                    return lastAutID.get(parameterKey);
                }
                lastAutID.put(parameterKey, null);
            }
            if (!availableAUTs.isEmpty()) {
                return (AutIdentifier)availableAUTs.iterator().next();
            }
            return null;
        }
    }

    protected static void setLastAutID(String key, AutIdentifier id) {
        lastAutID.put(key, id);
    }

    protected abstract String getKey();

    public void updateElement(UIElement element, Map parameters) {
        Object oAutID = parameters.get(this.getKey());
        AutIdentifier autID = null;
        if (!(oAutID instanceof String)) {
            return;
        }
        try {
            autID = AutIdentifier.decode((String)((String)oAutID));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        element.setChecked(autID.equals((Object)lastAutID.get(this.getKey())));
    }
}

