/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.driver;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.rc.common.exception.StepVerifyFailedException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;

public class CheckWithTimeoutQueuer {
    private static long waitTime = 100L;
    private static String pollingDelayVar = "TEST_RC_POLLING_DELAY";
    private static AutServerLogger log = new AutServerLogger(CheckWithTimeoutQueuer.class);

    static {
        String value = EnvironmentUtils.getProcessOrSystemProperty((String)pollingDelayVar);
        if (StringUtils.isNotBlank((String)value)) {
            try {
                waitTime = Long.valueOf(value);
                log.debug("Polling delay set to: " + waitTime);
            }
            catch (Exception e) {
                log.error("Invalid value for polling delay: " + value, e);
            }
        }
    }

    private CheckWithTimeoutQueuer() {
    }

    public static void invokeAndWait(String name, long timeout, Runnable runnable) {
        long startime = System.currentTimeMillis();
        while (System.currentTimeMillis() < startime + timeout) {
            try {
                log.debug(name);
                runnable.run();
                return;
            }
            catch (StepVerifyFailedException svfe) {
                if (System.currentTimeMillis() > startime + timeout) {
                    throw svfe;
                }
                TimeUtil.delay((long)waitTime);
            }
        }
        runnable.run();
    }
}

