/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.listener;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.communication.internal.message.CAPRecordedMessage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageParam;
import org.eclipse.jubula.communication.internal.message.RecordActionMessage;
import org.eclipse.jubula.communication.internal.message.ShowObservInfoMessage;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.Constants;
import org.eclipse.jubula.rc.common.exception.NoIdentifierForComponentException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.rc.swing.listener.ComponentHandler;
import org.eclipse.jubula.rc.swing.listener.RecordHelper;
import org.eclipse.jubula.rc.swing.listener.RecordListener;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.internal.utils.StringParsing;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Action;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Param;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordActions {
    private static AutServerLogger log = new AutServerLogger(RecordListener.class);
    private Component m_parent;
    private boolean m_isSelEvent;
    private int[] m_tableRowColumn = new int[2];
    private Map<Component, String> m_map = new HashMap<Component, String>();
    private Map<String, IComponentIdentifier> m_logNameMap = new HashMap<String, IComponentIdentifier>();
    private Map<Component, String> m_techNameMap = new HashMap<Component, String>();
    private int m_popupMouseBtn = 3;
    private RecordHelper m_recordHelper = new RecordHelper();

    public Map<Component, String> getTextCompContent() {
        return this.m_map;
    }

    public void setTextCompContent(Map<Component, String> map) {
        this.m_map = map;
    }

    public void addTextCompContent(Component source, String content) {
        this.m_map.put(source, content);
    }

    public Component getComponentParent() {
        return this.m_parent;
    }

    public void setSelectionState(boolean isSelEvent) {
        this.m_isSelEvent = isSelEvent;
    }

    public boolean isSelectionEvent() {
        return this.m_isSelEvent;
    }

    public void setComponentParent(Component parent) {
        this.m_parent = parent;
    }

    public int[] getTableRowColumn() {
        return this.m_tableRowColumn;
    }

    public void setTableRowColumn(int row, int column) {
        this.m_tableRowColumn[0] = row;
        this.m_tableRowColumn[1] = column;
    }

    public int getPopupMouseButton() {
        return this.m_popupMouseBtn;
    }

    public void setPopupMouseButton(int popupMouseBtn) {
        this.m_popupMouseBtn = popupMouseBtn;
    }

    protected void selectListValues(JList jlst, IComponentIdentifier id, Action a) {
        String[] entries = this.m_recordHelper.getRenderedListValues(jlst);
        String entr = "";
        int i = 0;
        while (i < entries.length) {
            String item = StringParsing.maskAndSingleQuoteText((String)entries[i], (int)1);
            entr = entr.concat(item);
            if (i < entries.length - 1) {
                entr = entr.concat(",");
            }
            ++i;
        }
        LinkedList<String> lstValues = new LinkedList<String>();
        lstValues.add(entr);
        lstValues.add(Constants.REC_OPERATOR);
        lstValues.add(Constants.REC_SEARCH_MODE);
        lstValues.add("no");
        String logName = this.createLogicalName(jlst, id);
        this.createCAP(a, id, lstValues, logName);
    }

    protected void selectNode(JTree jtre, TreePath path, IComponentIdentifier id, Action a, int clickcount) {
        String nodepath = this.m_recordHelper.treepathToTextpath(jtre, path);
        int count = clickcount;
        if (count < 1) {
            count = 1;
        }
        String clCount = String.valueOf(count);
        LinkedList<String> treValues = new LinkedList<String>();
        treValues.add(Constants.REC_SEARCH_MODE);
        treValues.add("0");
        treValues.add(nodepath);
        treValues.add(Constants.REC_OPERATOR);
        treValues.add(clCount);
        treValues.add(String.valueOf(ValueSets.InteractionMode.primary.rcIntValue()));
        treValues.add("no");
        String logName = this.createLogicalName(jtre, id);
        this.createCAP(a, id, treValues, logName);
    }

    protected void collExpTree(JTree jtre, TreePath path, IComponentIdentifier id, String collOrExp) {
        String nodepath = null;
        nodepath = this.m_recordHelper.treepathToTextpath(jtre, path);
        Action a = this.m_recordHelper.compSysToAction(id, collOrExp);
        LinkedList<String> treValues = new LinkedList<String>();
        treValues.add(Constants.REC_SEARCH_MODE);
        treValues.add("0");
        treValues.add(nodepath);
        treValues.add(Constants.REC_OPERATOR);
        String logName = this.createLogicalName(jtre, id);
        this.createCAP(a, id, treValues, logName);
    }

    protected void selectTab(JTabbedPane jtpn, IComponentIdentifier id, Action a) {
        LinkedList<String> tpnValues = new LinkedList<String>();
        String tpnTitle = StringParsing.singleQuoteText((String)jtpn.getTitleAt(jtpn.getSelectedIndex()));
        tpnValues.add(tpnTitle);
        tpnValues.add(Constants.REC_OPERATOR);
        String logName = this.createLogicalName(jtpn, id);
        this.createCAP(a, id, tpnValues, logName);
    }

    protected void selectCbxValue(JComboBox jcbx, IComponentIdentifier id, Action a) {
        String cbxText = StringParsing.singleQuoteText((String)this.m_recordHelper.getRenderedComboText(jcbx));
        if (cbxText.equals("") || cbxText == null) {
            cbxText = "'^$'";
        }
        LinkedList<String> cbxValues = new LinkedList<String>();
        cbxValues.add(cbxText);
        cbxValues.add(Constants.REC_OPERATOR);
        cbxValues.add(Constants.REC_SEARCH_MODE);
        String logName = this.createLogicalName(jcbx, id);
        this.createCAP(a, id, cbxValues, logName);
    }

    protected void selectTableCell(JTable jtbl, IComponentIdentifier id, int clickcount, Action a, int mouseButton) {
        int row = jtbl.getSelectedRow();
        int column = jtbl.getSelectedColumn();
        int count = clickcount;
        if (count < 1) {
            count = 1;
        }
        String clCount = new Integer(count).toString();
        String rowStr = new Integer(row + 1).toString();
        String columnStr = new Integer(column + 1).toString();
        LinkedList<String> tblValues = new LinkedList<String>();
        tblValues.add(rowStr);
        tblValues.add(MatchUtil.EQUALS);
        tblValues.add(columnStr);
        tblValues.add(MatchUtil.EQUALS);
        tblValues.add(clCount);
        tblValues.add("50");
        tblValues.add("percent");
        tblValues.add("50");
        tblValues.add("percent");
        tblValues.add("no");
        tblValues.add(String.valueOf(mouseButton));
        String logName = this.createLogicalName(jtbl, id);
        this.createCAP(a, id, tblValues, logName);
    }

    protected void selectMenuItem(JMenuItem mi) {
        Component comp = mi;
        boolean isMenuBarItem = false;
        String logName = null;
        while (comp.getParent() != null) {
            if (comp.getParent() instanceof JPopupMenu) {
                JPopupMenu jpm = (JPopupMenu)comp.getParent();
                comp = jpm.getInvoker();
            } else {
                comp = comp.getParent();
            }
            if (comp instanceof JMenuBar) {
                isMenuBarItem = true;
                break;
            }
            if (comp instanceof JComponent && !(comp instanceof JMenu)) break;
        }
        IComponentIdentifier id = null;
        Action a = new Action();
        if (comp instanceof JComponent) {
            String pth = this.m_recordHelper.getPath(mi);
            LinkedList<String> parValues = new LinkedList<String>();
            parValues.add(pth);
            parValues.add(Constants.REC_OPERATOR);
            if (isMenuBarItem) {
                id = this.m_recordHelper.getMenuCompID();
                a = this.m_recordHelper.compSysToAction(id, "CompSystem.SelectMenuItem");
            } else {
                try {
                    id = ComponentHandler.getIdentifier(comp);
                    a = this.m_recordHelper.compSysToAction(id, "CompSystem.PopupSelectByTextPathNew");
                    logName = this.createLogicalName(comp, id);
                    parValues.add(new Integer(this.m_popupMouseBtn).toString());
                }
                catch (NoIdentifierForComponentException noIdentifierForComponentException) {
                    log.error((Object)("no identifier for '" + comp));
                }
            }
            if (logName != null) {
                this.createCAP(a, id, parValues, logName);
            } else {
                this.createCAP(a, id, parValues);
            }
        }
    }

    protected void keyComboApp(IComponentIdentifier id, KeyEvent ke, int keycode) {
        Action a = new Action();
        a = this.m_recordHelper.compSysToAction(id, "CompSystem.KeyStroke");
        LinkedList<String> parameterValues = new LinkedList<String>();
        String modifierKey = null;
        if (ke.getModifiers() == 0) {
            modifierKey = "none";
        } else {
            modifierKey = RecordHelper.getModifierName(ke.getModifiers());
            if (modifierKey != null) {
                modifierKey = modifierKey.toLowerCase().replace('+', ' ');
            }
        }
        String baseKey = null;
        baseKey = RecordHelper.getKeyName(keycode);
        if (baseKey == null) {
            baseKey = KeyEvent.getKeyText(keycode).toUpperCase();
        }
        if (baseKey != null && modifierKey != null) {
            parameterValues.add(modifierKey);
            parameterValues.add(baseKey);
            this.createCAP(a, id, parameterValues);
        }
    }

    protected void clickGraphComp(IComponentIdentifier id, MouseEvent me, Component source) {
        if (source instanceof JTable || source instanceof JList || source instanceof JTree || source instanceof JTabbedPane) {
            this.clickInComponent(id, me, source);
        } else {
            int clickcount = me.getClickCount();
            if (clickcount < 1) {
                clickcount = 1;
            }
            String clCount = new Integer(clickcount).toString();
            String mbutton = new Integer(me.getButton()).toString();
            Action a = this.m_recordHelper.compSysToAction(id, "CompSystem.Click");
            LinkedList<String> parValues = new LinkedList<String>();
            parValues.add(clCount);
            parValues.add(mbutton);
            String logName = this.createLogicalName(source, id);
            this.createCAP(a, id, parValues, logName);
        }
    }

    protected void clickInComponent(IComponentIdentifier id, MouseEvent me, Component source) {
        int clickcount = me.getClickCount();
        if (clickcount < 1) {
            clickcount = 1;
        }
        String clCount = new Integer(clickcount).toString();
        String mbutton = new Integer(me.getButton()).toString();
        Action a = this.m_recordHelper.compSysToAction(id, "CompSystem.ClickDirect");
        Rectangle bounds = me.getComponent().getBounds();
        int percentX = (int)((double)me.getX() / bounds.getWidth() * 100.0);
        String percentXString = new Integer(percentX).toString();
        int percentY = (int)((double)me.getY() / bounds.getHeight() * 100.0);
        String percentYString = new Integer(percentY).toString();
        String units = "percent";
        LinkedList<String> parValues = new LinkedList<String>();
        parValues.add(clCount);
        parValues.add(mbutton);
        parValues.add(percentXString);
        parValues.add(units);
        parValues.add(percentYString);
        parValues.add(units);
        String logName = this.createLogicalName(source, id);
        this.createCAP(a, id, parValues, logName);
    }

    protected void replaceText(Component source) {
        Component parent;
        Component src = source;
        Component component = parent = this.getComponentParent() != null ? this.getComponentParent() : src.getParent();
        if (parent instanceof JComboBox) {
            src = parent;
        }
        String text = null;
        boolean isEditable = false;
        boolean isCbxItem = false;
        boolean isSupported = true;
        if (src instanceof JTextComponent) {
            JTextComponent jtf = (JTextComponent)src;
            text = jtf.getText();
            isEditable = jtf.isEditable();
            if ((source instanceof JTextArea || source instanceof JTextPane || source instanceof JEditorPane) && (text.indexOf(10) != -1 || text.indexOf(13) != -1)) {
                isSupported = false;
                this.sendInfoMessage("Multi-line text is not supported for Replace Text");
            }
            if (parent instanceof JTable) {
                JTable tbl = (JTable)parent;
                this.replaceTableText(src, tbl, text);
                return;
            }
        }
        if (src instanceof JComboBox) {
            JComboBox cbx = (JComboBox)src;
            isEditable = cbx.isEditable();
            if (isEditable) {
                ComboBoxEditor cbxEditor = cbx.getEditor();
                text = cbxEditor.getItem().toString();
                String[] cbxItems = this.m_recordHelper.getRenderedComboItems(cbx);
                int i = 0;
                while (i < cbxItems.length) {
                    String item = cbxItems[i];
                    if (item.equals(text)) {
                        isCbxItem = true;
                    }
                    ++i;
                }
            } else {
                return;
            }
        }
        if (text.length() > 3999) {
            ShowObservInfoMessage infoMsg = new ShowObservInfoMessage("Actions with Strings larger than 3999 are not supported");
            try {
                AUTServer.getInstance().getServerCommunicator().send((Message)infoMsg);
            }
            catch (CommunicationException communicationException) {}
            return;
        }
        if (this.m_map.get(source) != null && !text.equals(this.m_map.get(source).toString()) && isSupported && isEditable && !isCbxItem) {
            this.m_map.put(src, text);
            IComponentIdentifier id = null;
            try {
                id = ComponentHandler.getIdentifier(src);
                Action a = new Action();
                a = this.m_recordHelper.compSysToAction(id, "CompSystem.InputText");
                LinkedList<String> parameterValues = new LinkedList<String>();
                text = StringParsing.singleQuoteText((String)text);
                parameterValues.add(text);
                String logName = this.createLogicalName(src, id);
                this.createCAP(a, id, parameterValues, logName);
            }
            catch (NoIdentifierForComponentException noIdentifierForComponentException) {
                log.error((Object)("no identifier for '" + src));
            }
        }
    }

    private void replaceTableText(Component src, JTable tbl, String text) {
        String txt = StringParsing.singleQuoteText((String)text);
        if (!txt.equals(this.m_map.get(src).toString())) {
            IComponentIdentifier id = null;
            try {
                id = ComponentHandler.getIdentifier(tbl);
                Action a = new Action();
                a = this.m_recordHelper.compSysToAction(id, "CompSystem.ReplaceTextInTableCellNew");
                int row = this.getTableRowColumn()[0];
                int column = this.getTableRowColumn()[1];
                String rowStr = new Integer(row + 1).toString();
                String columnStr = new Integer(column + 1).toString();
                LinkedList<String> parameterValues = new LinkedList<String>();
                if (txt.equals("") || txt == null) {
                    txt = "''";
                }
                parameterValues.add(txt);
                parameterValues.add(rowStr);
                parameterValues.add(columnStr);
                String logName = this.createLogicalName(tbl, id);
                this.createCAP(a, id, parameterValues, logName);
                this.m_map.put(src, txt);
            }
            catch (NoIdentifierForComponentException noIdentifierForComponentException) {
                log.error((Object)("no identifier for '" + tbl));
            }
        }
    }

    protected void waitForWindow(Component window, IComponentIdentifier id, Action a) {
        String title = null;
        if (window instanceof JFrame) {
            JFrame jf = (JFrame)window;
            title = StringParsing.singleQuoteText((String)jf.getTitle());
        }
        if (window instanceof JDialog) {
            JDialog jd = (JDialog)window;
            title = StringParsing.singleQuoteText((String)jd.getTitle());
        }
        if (title != null && !title.equals("")) {
            String operator = Constants.REC_OPERATOR;
            String delay = new Integer(500).toString();
            String timeout = null;
            long timestamp = AUTServer.getInstance().getObservTimestamp();
            if (timestamp == 0L) {
                timeout = new Integer(30000).toString();
            } else {
                long timeoutLong = System.currentTimeMillis() - timestamp + 10000L;
                double timeoutDouble = Math.ceil((double)timeoutLong / 5000.0) * 5000.0;
                int timeoutInt = (int)timeoutDouble;
                timeout = new Integer(timeoutInt).toString();
            }
            LinkedList<String> winValues = new LinkedList<String>();
            winValues.add(title);
            winValues.add(operator);
            winValues.add(timeout);
            winValues.add(delay);
            this.createCAP(a, id, winValues);
        }
    }

    private void createCAP(Action a, IComponentIdentifier id, List<String> parValues) {
        String defaultName = "default";
        this.createCAP(a, id, parValues, defaultName);
    }

    private void createCAP(Action a, IComponentIdentifier id, List<String> parValues, String logName) {
        MessageCap messageCap = new MessageCap();
        messageCap.setMethod(a.getMethod());
        messageCap.setAction(a);
        messageCap.setCi(id);
        List<String> parameterValues = parValues;
        List params = a.getParams();
        int i = 0;
        while (i < params.size()) {
            Param param = (Param)params.get(i);
            MessageParam messageParam = new MessageParam();
            messageParam.setType(param.getType());
            String emptyString = "";
            String value = emptyString.equals(parameterValues.get(i)) ? null : parameterValues.get(i);
            messageParam.setValue(value);
            messageCap.addMessageParam(messageParam);
            ++i;
        }
        if (StringUtils.isEmpty((String)id.getComponentName())) {
            messageCap.setLogicalName(logName);
            messageCap.sethasDefaultMapping(true);
        }
        CAPRecordedMessage capRecMessage = new CAPRecordedMessage(messageCap);
        try {
            RecordActionMessage message = new RecordActionMessage(capRecMessage);
            AUTServer.getInstance().getServerCommunicator().send((Message)message);
        }
        catch (CommunicationException e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        AUTServer.getInstance().setObservTimestamp(System.currentTimeMillis());
    }

    private String createLogicalName(Component c, IComponentIdentifier id) {
        String logName = this.m_techNameMap.get(c);
        if (logName == null && (logName = this.m_recordHelper.generateLogicalName(c, id)) != null) {
            IComponentIdentifier id2 = this.m_logNameMap.get(logName);
            if (this.m_logNameMap.containsKey(logName) && !this.m_recordHelper.isCiEqual(id, id2)) {
                Collection<String> col = this.m_techNameMap.values();
                Iterator<String> it = col.iterator();
                int counter = 0;
                while (it.hasNext()) {
                    String name = it.next();
                    if (!name.equals(logName) && !name.equals(String.valueOf(logName) + "_" + (counter + 1))) continue;
                    ++counter;
                }
                logName = String.valueOf(logName) + "_" + counter;
            }
            this.m_logNameMap.put(logName, id);
            this.m_techNameMap.put(c, logName);
        }
        return logName;
    }

    private void sendInfoMessage(String info) {
        ShowObservInfoMessage infoMsg = new ShowObservInfoMessage(info);
        try {
            AUTServer.getInstance().getServerCommunicator().send((Message)infoMsg);
        }
        catch (CommunicationException communicationException) {}
    }
}

