/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.selection;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jwt.we.editors.selection.SelectionConverter;

public class EditPartViewerSelectionConverter
extends SelectionConverter {
    private EditPartViewer editPartViewer;

    public EditPartViewerSelectionConverter(EditPartViewer editPartViewer) {
        assert (editPartViewer != null);
        this.editPartViewer = editPartViewer;
    }

    public ISelection convertFromTargetSelection(ISelection editPartSelection) {
        if (!(editPartSelection instanceof IStructuredSelection)) {
            return StructuredSelection.EMPTY;
        }
        List editPartList = ((IStructuredSelection)editPartSelection).toList();
        ArrayList<Object> modelList = new ArrayList<Object>(editPartList.size());
        for (Object element : editPartList) {
            if (element == null || !(element instanceof EditPart)) continue;
            Object model = ((EditPart)element).getModel();
            modelList.add(model);
        }
        return new StructuredSelection(modelList);
    }

    public ISelection convertToTargetSelection(ISelection modelSelection) {
        if (!(modelSelection instanceof IStructuredSelection)) {
            return StructuredSelection.EMPTY;
        }
        List modelList = ((IStructuredSelection)modelSelection).toList();
        ArrayList editPartList = new ArrayList(modelList.size());
        for (Object element : modelList) {
            Object editPart = this.editPartViewer.getEditPartRegistry().get(element);
            if (editPart == null) continue;
            editPartList.add(editPart);
        }
        return new StructuredSelection(editPartList);
    }
}

