/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.knopflerfish;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.libra.framework.core.FrameworkInstanceConfiguration;
import org.eclipse.libra.framework.core.Trace;
import org.eclipse.libra.framework.knopflerfish.IKnopflerfishVersionHandler;
import org.eclipse.libra.framework.knopflerfish.Messages;
import org.eclipse.libra.framework.knopflerfish.internal.KnopflerfishConfigurationPublishHelper;
import org.eclipse.wst.server.core.IModule;

public class Knopflerfish31Handler
implements IKnopflerfishVersionHandler {
    public IStatus verifyInstallPath(IPath location) {
        File f2;
        File f = location.append("osgi").toFile();
        if (f == null || !f.exists()) {
            return new Status(4, "org.eclipse.libra.framework.knopflerfish", 0, Messages.warningCantReadConfig, null);
        }
        File[] conf = f.listFiles();
        if (conf != null) {
            int size = conf.length;
            int i = 0;
            while (i < size) {
                if (!f.canRead()) {
                    return new Status(2, "org.eclipse.libra.framework.knopflerfish", 0, Messages.warningCantReadConfig, null);
                }
                ++i;
            }
        }
        if ((f2 = location.append("osgi").append("framework.jar").toFile()) == null || !f2.exists()) {
            return new Status(4, "org.eclipse.libra.framework.knopflerfish", 0, "Cannot locate framework.jar.  Invalid installation folder", null);
        }
        return Status.OK_STATUS;
    }

    public String getFrameworkClass() {
        return "org.knopflerfish.framework.Main";
    }

    public List getFrameworkClasspath(IPath installPath, IPath configPath) {
        ArrayList<IRuntimeClasspathEntry> cp = new ArrayList<IRuntimeClasspathEntry>();
        IPath binPath = installPath.append("osgi");
        if (binPath.toFile().exists()) {
            IPath path = binPath.append("framework.jar");
            cp.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path));
        }
        return cp;
    }

    public String[] getFrameworkProgramArguments(IPath configPath, boolean debug, boolean starting) {
        return new String[]{"-init", "-xargs", "file:" + configPath.append("osami.xargs").makeAbsolute().toOSString()};
    }

    public String[] getExcludedFrameworkProgramArguments(boolean debug, boolean starting) {
        return null;
    }

    public String[] getFrameworkVMArguments(IPath installPath, IPath configPath, IPath deployPath, boolean isTestEnv) {
        return new String[0];
    }

    public IStatus canAddModule(IModule module) {
        String id = module.getModuleType().getId();
        if ("osami.bundle".equals(id)) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.libra.framework.knopflerfish", 0, Messages.errorNotBundle, null);
    }

    public IStatus prepareFrameworkInstanceDirectory(IPath baseDir) {
        return Status.OK_STATUS;
    }

    public IStatus prepareDeployDirectory(IPath deployPath) {
        File temp;
        if (Trace.isTraceEnabled()) {
            Trace.trace((byte)4, (String)("Creating runtime directory at " + deployPath.toOSString()));
        }
        if (!(temp = deployPath.append("plugins").toFile()).exists()) {
            temp.mkdirs();
        }
        return Status.OK_STATUS;
    }

    public boolean supportsServeModulesWithoutPublish() {
        return true;
    }

    private void writeXargs(IPath installPath, IPath confPath, PrintWriter out, KnopflerfishConfigurationPublishHelper publishHelper, FrameworkInstanceConfiguration configuration) {
        String kernelBundle;
        String[] kb;
        out.println("#");
        out.println("# Generated by OSAMI Tools");
        out.println("# for Knopflerfish release 3.1.0");
        out.println("# Copyright 2010 eteration a.s.");
        out.println("# load common properties");
        out.println("-xargs file:" + confPath.append("props.xargs").toOSString());
        out.println("# Semicolon seprated list of base URLs for searching (completing)");
        out.println("# bundle URLs in '-install URL' command line options and in the console.");
        out.println("-Dorg.knopflerfish.gosg.jars=file:" + installPath.append("osgi").append("jars").toOSString());
        out.println("-init");
        out.println("## Basic KF bundles");
        out.println("-initlevel 3");
        String[] stringArray = kb = publishHelper.getTargetBundlePaths(configuration);
        int n = kb.length;
        int n2 = 0;
        while (n2 < n) {
            kernelBundle = stringArray[n2];
            out.println("-install file:" + kernelBundle);
            ++n2;
        }
        stringArray = kb;
        n = kb.length;
        n2 = 0;
        while (n2 < n) {
            kernelBundle = stringArray[n2];
            out.println("-start file:" + kernelBundle);
            ++n2;
        }
        out.println("-startlevel 3");
        out.println("-launch");
        out.println("");
        out.flush();
    }

    private void writePropsXargs(PrintWriter out, KnopflerfishConfigurationPublishHelper publishHelper, FrameworkInstanceConfiguration configuration) {
        out.println("#");
        out.println("# Generated by OSAMI Tools");
        out.println("# for Knopflerfish release 3.1.0");
        out.println("# Copyright 2010 eteration a.s.");
        out.println("# Common properties used by different init.xargs files");
        out.println("-Forg.osgi.provisioning.spid=knopflerfish");
        out.println("-Forg.knopflerfish.framework.debug.errors=true");
        out.println("-Forg.knopflerfish.framework.bundlestorage.file.reference=true");
        out.println("-Forg.knopflerfish.startlevel.use=true");
        out.println("# Web server properties");
        out.println("-Forg.knopflerfish.http.dnslookup=false");
        out.println("-Forg.osgi.service.http.port=8080");
        out.println("# Web server properties");
        out.println("-Forg.knopflerfish.http.dnslookup=false");
        out.println("-Forg.osgi.service.http.port=8080");
        out.println("# Log service properties");
        out.println("-Forg.knopflerfish.log.out=false");
        out.println("-Forg.knopflerfish.log.level=info");
        out.println("-Forg.knopflerfish.log.grabio=true");
        out.println("-Forg.knopflerfish.log.file=true");
        out.println("-Forg.knopflerfish.log.memory.size=250");
        out.println("#consoletelnet properties");
        out.println("-Forg.knopflerfish.consoletelnet.user=admin");
        out.println("-Forg.knopflerfish.consoletelnet.pwd=admin");
        out.println("-Forg.knopflerfish.consoletelnet.port=2323");
        out.flush();
    }

    public void prepareFrameworkConfigurationFile(IPath installPath, IPath confDir, KnopflerfishConfigurationPublishHelper publishHelper, FrameworkInstanceConfiguration configuration) {
        block14: {
            OutputStream out = null;
            try {
                try {
                    out = new FileOutputStream(confDir.append("osami.xargs").makeAbsolute().toFile());
                    PrintWriter pw = new PrintWriter(out);
                    this.writeXargs(installPath, confDir, pw, publishHelper, configuration);
                    out.flush();
                    out.close();
                    out = new FileOutputStream(confDir.append("props.xargs").makeAbsolute().toFile());
                    pw = new PrintWriter(out);
                    this.writePropsXargs(pw, publishHelper, configuration);
                    out.close();
                    out = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

