/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractMethodMappingDeclaration;
import org.eclipse.jdt.core.dom.CallinMappingDeclaration;
import org.eclipse.jdt.core.dom.CalloutMappingDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldAccessSpec;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IMethodMappingBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodSpec;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.RoleTypeDeclaration;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposal;
import org.eclipse.objectteams.otdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.objectteams.otdt.internal.ui.util.OTStubUtility;
import org.eclipse.objectteams.otdt.ui.OTDTUIPlugin;
import org.eclipse.text.edits.TextEditGroup;

public class AddMethodMappingSignaturesProposal
extends LinkedCorrectionProposal {
    protected static final String KEY_BASEMETHOD = "basemethod";
    private final AbstractMethodMappingDeclaration mapping;

    public AddMethodMappingSignaturesProposal(ICompilationUnit cu, AbstractMethodMappingDeclaration mapping, int relevance) {
        super(CorrectionMessages.QuickAssistProcessor_addMethodBindingSignatures_label, cu, null, relevance, JavaPluginImages.get((String)"org.eclipse.jdt.ui.add_correction.gif"));
        this.mapping = mapping;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        ASTRewrite rewrite = ASTRewrite.create((AST)this.mapping.getAST());
        ICompilationUnit cu = this.getCompilationUnit();
        TextEditGroup editGroup = new TextEditGroup(CorrectionMessages.QuickAssistProcessor_addSignature_editName);
        ImportRewrite imports = this.createImportRewrite((CompilationUnit)ASTNodes.getParent((ASTNode)this.mapping, (int)15));
        IMethodBinding roleMethod = ((MethodSpec)this.mapping.getRoleMappingElement()).resolveBinding();
        MethodSpec newSpec = OTStubUtility.createMethodSpec(cu, rewrite, imports, roleMethod, true);
        this.convertTypeParameters(this.mapping.getAST(), roleMethod, newSpec);
        rewrite.set((ASTNode)this.mapping, (StructuralPropertyDescriptor)this.mapping.getRoleElementProperty(), (Object)newSpec, editGroup);
        if (this.mapping.getNodeType() == 101) {
            this.addSignatureToCallinBases(cu, rewrite, imports, (CallinMappingDeclaration)this.mapping, editGroup, roleMethod);
        } else {
            this.addSignatureToCalloutBase(cu, rewrite, imports, (CalloutMappingDeclaration)this.mapping, editGroup, roleMethod);
        }
        return rewrite;
    }

    private void addSignatureToCallinBases(ICompilationUnit cu, ASTRewrite rewrite, ImportRewrite imports, CallinMappingDeclaration mapping, TextEditGroup editGroup, IMethodBinding roleMethod) throws CoreException {
        List oldBaseSpecs = mapping.getBaseMappingElements();
        ListRewrite baseMethodsRewrite = rewrite.getListRewrite((ASTNode)mapping, CallinMappingDeclaration.BASE_MAPPING_ELEMENTS_PROPERTY);
        IMethodMappingBinding mappingBinding = mapping.resolveBinding();
        if (mappingBinding != null) {
            IMethodBinding[] baseMethods = mappingBinding.getBaseMethods();
            int i = 0;
            while (i < baseMethods.length) {
                IMethodBinding baseMethod = baseMethods[i];
                try {
                    MethodSpec newSpec = OTStubUtility.createMethodSpec(cu, rewrite, imports, baseMethod, true);
                    baseMethodsRewrite.replace((ASTNode)oldBaseSpecs.get(i), (ASTNode)newSpec, editGroup);
                }
                catch (CoreException e) {
                    OTDTUIPlugin.log((Throwable)e);
                }
                ++i;
            }
        } else {
            ITypeBinding[] roleParameters = roleMethod.getParameterTypes();
            RoleTypeDeclaration role = (RoleTypeDeclaration)mapping.getParent();
            int i = 0;
            while (i < oldBaseSpecs.size()) {
                MethodSpec oldBaseSpec = (MethodSpec)oldBaseSpecs.get(i);
                ArrayList<IMethodBinding> matchingBaseMethods = new ArrayList<IMethodBinding>();
                this.guessBaseMethod(role.resolveBinding(), oldBaseSpec.getName().getIdentifier(), roleParameters, true, matchingBaseMethods);
                if (matchingBaseMethods.size() == 0) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.objectteams.otdt.jdt.ui", "Could not find a matching base method"));
                }
                try {
                    MethodSpec newSpec = OTStubUtility.createMethodSpec(cu, rewrite, imports, (IMethodBinding)matchingBaseMethods.get(0), true);
                    baseMethodsRewrite.replace((ASTNode)oldBaseSpecs.get(i), (ASTNode)newSpec, editGroup);
                    if (matchingBaseMethods.size() > 1) {
                        this.addLinkedPosition(rewrite.track((ASTNode)newSpec), false, KEY_BASEMETHOD);
                        for (IMethodBinding baseMethodBinding : matchingBaseMethods) {
                            MethodSpec bSpec = OTStubUtility.createMethodSpec(cu, rewrite, imports, baseMethodBinding, true);
                            this.addLinkedPositionProposal(KEY_BASEMETHOD, bSpec.toString(), null);
                        }
                    }
                }
                catch (CoreException e) {
                    OTDTUIPlugin.log((Throwable)e);
                }
                ++i;
            }
        }
    }

    private void addSignatureToCalloutBase(ICompilationUnit cu, ASTRewrite rewrite, ImportRewrite imports, CalloutMappingDeclaration mapping, TextEditGroup editGroup, IMethodBinding roleMethod) {
        try {
            FieldAccessSpec baseElement;
            ArrayList<IMethodBinding> matchingBaseMethods = new ArrayList<IMethodBinding>();
            if (mapping.bindingOperator().isCalloutToField()) {
                IVariableBinding baseField = ((FieldAccessSpec)mapping.getBaseMappingElement()).resolveBinding();
                baseElement = OTStubUtility.createFieldSpec(mapping.getAST(), imports, baseField, true);
            } else {
                IMethodMappingBinding mappingBinding = mapping.resolveBinding();
                if (mappingBinding != null) {
                    IMethodBinding baseMethod = mappingBinding.getBaseMethods()[0];
                    baseElement = OTStubUtility.createMethodSpec(cu, rewrite, imports, baseMethod, true);
                } else {
                    RoleTypeDeclaration role = (RoleTypeDeclaration)mapping.getParent();
                    ITypeBinding[] roleParameters = roleMethod.getParameterTypes();
                    MethodSpec oldBaseSpec = (MethodSpec)mapping.getBaseMappingElement();
                    this.guessBaseMethod(role.resolveBinding(), oldBaseSpec.getName().getIdentifier(), roleParameters, false, matchingBaseMethods);
                    if (matchingBaseMethods.size() == 0) {
                        return;
                    }
                    baseElement = OTStubUtility.createMethodSpec(cu, rewrite, imports, (IMethodBinding)matchingBaseMethods.get(0), true);
                }
            }
            rewrite.set((ASTNode)mapping, (StructuralPropertyDescriptor)CalloutMappingDeclaration.BASE_MAPPING_ELEMENT_PROPERTY, (Object)baseElement, editGroup);
            if (matchingBaseMethods.size() > 1) {
                this.addLinkedPosition(rewrite.track((ASTNode)baseElement), false, KEY_BASEMETHOD);
                for (IMethodBinding baseMethodBinding : matchingBaseMethods) {
                    MethodSpec bSpec = OTStubUtility.createMethodSpec(cu, rewrite, imports, baseMethodBinding, true);
                    this.addLinkedPositionProposal(KEY_BASEMETHOD, bSpec.toString(), null);
                }
            }
        }
        catch (CoreException e) {
            OTDTUIPlugin.log((Throwable)e);
        }
    }

    private void guessBaseMethod(ITypeBinding roleType, String selector, ITypeBinding[] roleParameters, boolean isCallin, List<IMethodBinding> result) {
        HashSet<String> foundSignatures = new HashSet<String>();
        ITypeBinding baseClass = roleType.getBaseClass();
        while (baseClass != null) {
            IMethodBinding[] iMethodBindingArray = baseClass.getDeclaredMethods();
            int n = iMethodBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                block8: {
                    ITypeBinding[] baseParameters;
                    String signature;
                    IMethodBinding baseMethod = iMethodBindingArray[n2];
                    if (baseMethod.getName().equals(selector) && foundSignatures.add(signature = this.makeSignatureKey(baseParameters = baseMethod.getParameterTypes()))) {
                        int consumed;
                        int provided = isCallin ? baseParameters.length : roleParameters.length;
                        int n3 = consumed = isCallin ? roleParameters.length : baseParameters.length;
                        if (provided >= consumed) {
                            int i = 0;
                            while (i < consumed) {
                                if (this.isCompatible(roleParameters[i], baseParameters[i], isCallin)) {
                                    ++i;
                                    continue;
                                }
                                break block8;
                            }
                            if (baseParameters.length == roleParameters.length) {
                                result.add(0, baseMethod);
                            } else {
                                result.add(baseMethod);
                            }
                        }
                    }
                }
                ++n2;
            }
            baseClass = baseClass.getSuperclass();
        }
    }

    private String makeSignatureKey(ITypeBinding[] baseParameters) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < baseParameters.length) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(baseParameters[i].getQualifiedName());
            ++i;
        }
        return buf.toString();
    }

    private boolean isCompatible(ITypeBinding roleSideType, ITypeBinding baseSideType, boolean isCallin) {
        ITypeBinding providedType;
        ITypeBinding requiredType = isCallin ? roleSideType : baseSideType;
        ITypeBinding iTypeBinding = providedType = isCallin ? baseSideType : roleSideType;
        if (providedType.isAssignmentCompatible(requiredType)) {
            return true;
        }
        if (isCallin ? (requiredType = requiredType.getBaseClass()) == null : (providedType = providedType.getBaseClass()) == null) {
            return false;
        }
        return providedType.isAssignmentCompatible(requiredType);
    }

    private void convertTypeParameters(AST ast, IMethodBinding roleMethod, MethodSpec destMethodSpec) {
        ITypeBinding[] iTypeBindingArray = roleMethod.getTypeParameters();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding typeParameter = iTypeBindingArray[n2];
            TypeParameter newTypeParameter = ast.newTypeParameter();
            newTypeParameter.setName(ast.newSimpleName(typeParameter.getName()));
            ITypeBinding[] iTypeBindingArray2 = typeParameter.getTypeBounds();
            int n3 = iTypeBindingArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                ITypeBinding typeBound = iTypeBindingArray2[n4];
                newTypeParameter.typeBounds().add(this.convertType(ast, typeBound));
                ++n4;
            }
            destMethodSpec.typeParameters().add(newTypeParameter);
            ++n2;
        }
    }

    private Type convertType(AST ast, ITypeBinding typeBinding) {
        if (typeBinding.isTypeVariable()) {
            return ast.newSimpleType((Name)ast.newSimpleName(typeBinding.getName()));
        }
        String typeName = typeBinding.getErasure().getQualifiedName();
        SimpleType type = typeName.indexOf(46) > -1 ? ast.newSimpleType(ast.newName(typeName)) : ast.newSimpleType((Name)ast.newSimpleName(typeName));
        ITypeBinding[] typeArguments = typeBinding.getTypeArguments();
        if (typeArguments.length > 0) {
            ParameterizedType parameterizedType = ast.newParameterizedType((Type)type);
            ITypeBinding[] iTypeBindingArray = typeArguments;
            int n = typeArguments.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding bound = iTypeBindingArray[n2];
                parameterizedType.typeArguments().add(this.convertType(ast, bound));
                ++n2;
            }
            return parameterizedType;
        }
        return type;
    }
}

