/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.utilities;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionLiteralPart;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.LambdaType;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.MapLiteralExp;
import org.eclipse.ocl.pivot.MapLiteralPart;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.PivotTables;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.SelfType;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.TemplateBinding;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.TupleLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralPart;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.library.ecore.EcoreExecutorManager;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.manager.PivotExecutorManager;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.resource.EnvironmentFactoryAdapter;
import org.eclipse.ocl.pivot.internal.resource.OCLAdapter;
import org.eclipse.ocl.pivot.internal.scoping.Attribution;
import org.eclipse.ocl.pivot.internal.scoping.NullAttribution;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.External2AS;
import org.eclipse.ocl.pivot.library.LibraryFeature;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotHelper;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.Pivotable;

public class PivotUtilInternal {
    private static final Logger logger = Logger.getLogger(PivotUtilInternal.class);
    public static boolean noDebug = true;
    private static long startTime = System.currentTimeMillis();

    public static @NonNull URI appendASExtensionSuffix(@NonNull URI uri) {
        String fileExtension = uri.fileExtension();
        assert (!fileExtension.endsWith("as"));
        return uri.trimFileExtension().appendFileExtension(String.valueOf(fileExtension) + "as");
    }

    @Deprecated
    public static @NonNull PivotHelper createHelper(@NonNull EnvironmentFactory environmentFactory) {
        return new PivotHelper(environmentFactory);
    }

    public static void debugPrintln(@Nullable Object string) {
        if (!noDebug) {
            System.out.printf("%6.3f [%s] %s\n", 0.001 * (double)(System.currentTimeMillis() - startTime), Thread.currentThread().getName(), String.valueOf(string));
        }
    }

    public static void debugReset() {
        startTime = System.currentTimeMillis();
        if (!noDebug) {
            System.out.println("");
        }
    }

    public static @Nullable EnvironmentFactoryInternal findEnvironmentFactory(@Nullable EObject eObject) {
        if (eObject == null) {
            return null;
        }
        EObject eRoot = EcoreUtil.getRootContainer((EObject)eObject);
        if (eRoot == null) {
            return null;
        }
        Resource eResource = eRoot.eResource();
        if (eResource == null) {
            return null;
        }
        return PivotUtilInternal.findEnvironmentFactory(eResource);
    }

    public static @Nullable EnvironmentFactoryInternal findEnvironmentFactory(@NonNull Resource resource) {
        for (Adapter adapter : resource.eAdapters()) {
            if (!(adapter instanceof EnvironmentFactoryAdapter)) continue;
            return ((EnvironmentFactoryAdapter)adapter).getEnvironmentFactory();
        }
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet == null) {
            return null;
        }
        return PivotUtilInternal.findEnvironmentFactory(resourceSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @Nullable EnvironmentFactoryInternal findEnvironmentFactory(@NonNull ResourceSet resourceSet) {
        ResourceSet resourceSet2 = resourceSet;
        synchronized (resourceSet2) {
            for (Adapter adapter : resourceSet.eAdapters()) {
                EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory;
                if (adapter instanceof EnvironmentFactoryAdapter) {
                    environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)((EnvironmentFactoryAdapter)adapter).getEnvironmentFactory();
                    if (environmentFactory.isDisposed()) continue;
                    return environmentFactory;
                }
                if (!(adapter instanceof PivotMetamodelManager) || (environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)((PivotMetamodelManager)adapter).getEnvironmentFactory()).isDisposed()) continue;
                return environmentFactory;
            }
            return null;
        }
    }

    public static @Nullable PivotMetamodelManager findMetamodelManager(@NonNull Resource resource) {
        EnvironmentFactoryInternal environmentFactory = PivotUtilInternal.findEnvironmentFactory(resource);
        if (environmentFactory == null) {
            return null;
        }
        return environmentFactory.getMetamodelManager();
    }

    public static Type findTypeOf(@NonNull MetamodelManagerInternal metamodelManager, @NonNull EClassifier eClass) {
        Type type;
        External2AS adapter;
        Resource resource = eClass.eResource();
        if (resource != null && (adapter = Ecore2AS.findAdapter(resource, metamodelManager.getEnvironmentFactory())) != null && (type = adapter.getCreated(Type.class, (EObject)eClass)) != null) {
            return type;
        }
        return null;
    }

    public static @NonNull URI getASURI(@NonNull URI uri) {
        URI asURI;
        if (uri.fragment() != null) {
            logger.error((Object)("Unexpected fragment ignored for '" + uri.toString() + "'"));
            uri = uri.trimFragment();
        }
        if (!PivotUtilInternal.isASURI(asURI = uri.appendFileExtension("oclas"))) {
            asURI = uri.appendSegment(".oclas");
        }
        assert (PivotUtilInternal.isASURI(asURI));
        return asURI;
    }

    @Deprecated
    public static @NonNull Attribution getAttribution(@NonNull EObject eObject) {
        if (eObject.eIsProxy()) {
            logger.warn((Object)("getAttribution for proxy " + eObject));
            return NullAttribution.INSTANCE;
        }
        EClass eClass = eObject.eClass();
        assert (eClass != null);
        Attribution attribution = Attribution.REGISTRY.get(eClass);
        if (attribution == null) {
            EClass superClass = eClass;
            while (superClass.getESuperTypes().size() > 0) {
                attribution = Attribution.REGISTRY.get(superClass = (EClass)superClass.getESuperTypes().get(0));
                if (attribution != null) break;
            }
            if (attribution == null) {
                attribution = NullAttribution.INSTANCE;
            }
            Attribution.REGISTRY.put((EClassifier)eClass, attribution);
        }
        return attribution;
    }

    @Deprecated
    public static @NonNull Type getBehavioralType(@NonNull Type type) {
        return PivotUtil.getBehavioralType(type);
    }

    @Deprecated
    public static @Nullable Type getBehavioralType(@Nullable TypedElement element) {
        Type type = PivotUtilInternal.getType(element);
        return type != null ? PivotUtil.getBehavioralType(type) : null;
    }

    public static @NonNull String getBodyExpression(@NonNull String umlBody) {
        String s = umlBody.trim();
        if (s.startsWith("result") && (s = s.substring(6).trim()).startsWith("=")) {
            if ((s = s.substring(1).trim()).startsWith("(") && s.endsWith(")")) {
                s = s.substring(1, s.length() - 1);
            }
            return s;
        }
        return umlBody;
    }

    public static @NonNull EnvironmentFactoryInternal getEnvironmentFactory(@NonNull Resource resource) {
        EnvironmentFactoryInternal environmentFactory = PivotUtilInternal.findEnvironmentFactory(resource);
        if (environmentFactory == null) {
            ResourceSet resourceSet = resource.getResourceSet();
            environmentFactory = resourceSet != null ? OCLAdapter.createEnvironmentFactory((Notifier)resourceSet) : OCLAdapter.createEnvironmentFactory((Notifier)resource);
        }
        return environmentFactory;
    }

    @Deprecated
    public static @NonNull Evaluator getEvaluator(@NonNull EObject eObject) {
        return PivotUtilInternal.getExecutor(eObject);
    }

    @Deprecated
    public static @NonNull Executor getExecutor(@NonNull EObject eObject) {
        EnvironmentFactoryInternal environmentFactory;
        Resource asResource = eObject.eResource();
        if (asResource != null && (environmentFactory = PivotUtilInternal.findEnvironmentFactory(asResource)) != null) {
            return new PivotExecutorManager(environmentFactory, eObject);
        }
        return new EcoreExecutorManager(eObject, PivotTables.LIBRARY);
    }

    public static @Nullable LibraryFeature getImplementation(@NonNull Operation localOperation) {
        ClassLoader classLoader;
        LibraryFeature libraryFeature = localOperation.getImplementation();
        if (libraryFeature != null) {
            return libraryFeature;
        }
        String implementationClassName = localOperation.getImplementationClass();
        if (implementationClassName != null && (classLoader = localOperation.getClass().getClassLoader()) != null) {
            try {
                java.lang.Class<?> theClass = classLoader.loadClass(implementationClassName);
                if (theClass != null) {
                    Field field = theClass.getField("INSTANCE");
                    return (LibraryFeature)field.get(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static @NonNull URI getNonASURI(@NonNull URI uri) {
        assert (PivotUtilInternal.isASURI(uri));
        return uri.trimFileExtension();
    }

    public static @NonNull Type getNonLambdaType(@NonNull Type type) {
        Type resultType;
        if (type instanceof LambdaType && (resultType = ((LambdaType)type).getResultType()) != null) {
            type = resultType;
        }
        return type;
    }

    public static <T extends Element> @NonNull T getNonNullAst(@NonNull java.lang.Class<T> pivotClass, @NonNull Pivotable pivotableElement) {
        Element pivotElement = pivotableElement.getPivot();
        if (pivotElement == null) {
            throw new IllegalStateException("Null pivotElementfor a " + pivotClass.getName());
        }
        if (!pivotClass.isAssignableFrom(pivotElement.getClass())) {
            throw new ClassCastException(String.valueOf(pivotElement.getClass().getName()) + " is not assignable to " + pivotClass.getName());
        }
        Element castElement = pivotElement;
        return (T)castElement;
    }

    public static String getNsURI(@NonNull EModelElement element) {
        String nsURI;
        if (element instanceof EPackage && (nsURI = ((EPackage)element).getNsURI()) != null) {
            return nsURI;
        }
        StringBuilder s = new StringBuilder();
        PivotUtilInternal.getNsURI(s, (EObject)element);
        return s.toString();
    }

    @Deprecated
    public static String getNsURI(@NonNull Element element) {
        String nsURI;
        if (element instanceof Package && (nsURI = ((Package)element).getURI()) != null) {
            return nsURI;
        }
        StringBuilder s = new StringBuilder();
        s.append("u_r_i:");
        PivotUtilInternal.getNsURI(s, element);
        return s.toString();
    }

    private static void getNsURI(@NonNull StringBuilder s, @NonNull EObject element) {
        String nsURI;
        EObject eContainer;
        String nsURI2;
        if (element instanceof Package) {
            nsURI2 = ((Package)element).getURI();
            if (nsURI2 != null) {
                s.append(nsURI2);
                return;
            }
        } else if (element instanceof Model) {
            nsURI2 = ((Model)element).getExternalURI();
            if (nsURI2 != null) {
                s.append(nsURI2);
                return;
            }
        } else if (element instanceof EPackage && (nsURI2 = ((EPackage)element).getNsURI()) != null) {
            s.append(nsURI2);
            return;
        }
        if ((eContainer = element.eContainer()) instanceof Package || eContainer instanceof Model) {
            nsURI = ((Package)element).getURI();
            if (nsURI != null) {
                s.append(nsURI);
                s.append("#/");
            } else {
                EObject eContainer2 = eContainer;
                PivotUtilInternal.getNsURI(s, eContainer2);
            }
        } else if (eContainer instanceof EPackage) {
            nsURI = ((EPackage)element).getNsURI();
            if (nsURI != null) {
                s.append(nsURI);
                s.append("#/");
            } else {
                PivotUtilInternal.getNsURI(s, eContainer);
            }
        } else {
            if (eContainer == null) {
                String name = null;
                if (element instanceof Package) {
                    name = ((Package)element).getName();
                } else if (element instanceof EPackage) {
                    name = ((EPackage)element).getName();
                }
                if (name == null) {
                    name = "$null$";
                }
                s.append(name);
                return;
            }
            PivotUtilInternal.getNsURI(s, eContainer);
        }
        EReference eFeature = element.eContainmentFeature();
        s.append("@");
        s.append(eFeature.getName());
        if (eFeature.isMany()) {
            int index = ((List)eContainer.eGet(element.eContainingFeature())).indexOf(element);
            s.append(".");
            s.append(index);
        }
    }

    public static @NonNull List<@NonNull OCLExpression> getOwnedArgumentsList(@NonNull OperationCallExp operationCallExp) {
        return ClassUtil.nullFree(operationCallExp.getOwnedArguments());
    }

    public static @NonNull List<@NonNull Class> getOwnedClassesList(@NonNull Package asPackage) {
        return ClassUtil.nullFree(asPackage.getOwnedClasses());
    }

    public static @NonNull List<@NonNull Variable> getOwnedCoIteratorsList(@NonNull LoopExp loopExp) {
        return ClassUtil.nullFree(loopExp.getOwnedCoIterators());
    }

    public static @NonNull List<@NonNull Import> getOwnedImportsList(@NonNull Model asModel) {
        return ClassUtil.nullFree(asModel.getOwnedImports());
    }

    public static @NonNull List<@NonNull Variable> getOwnedIteratorsList(@NonNull LoopExp loopExp) {
        return ClassUtil.nullFree(loopExp.getOwnedIterators());
    }

    public static @NonNull List<@NonNull Operation> getOwnedOperationsList(@NonNull Class asClass) {
        return ClassUtil.nullFree(asClass.getOwnedOperations());
    }

    public static @NonNull List<@NonNull Package> getOwnedPackagesList(@NonNull Model asModel) {
        return ClassUtil.nullFree(asModel.getOwnedPackages());
    }

    public static @NonNull List<@NonNull Package> getOwnedPackagesList(@NonNull Package asPackage) {
        return ClassUtil.nullFree(asPackage.getOwnedPackages());
    }

    public static @NonNull List<@NonNull Parameter> getOwnedParametersList(@NonNull Operation operation) {
        return ClassUtil.nullFree(operation.getOwnedParameters());
    }

    public static @NonNull List<@NonNull TemplateParameter> getOwnedParametersList(@NonNull TemplateSignature templateSignature) {
        return ClassUtil.nullFree(templateSignature.getOwnedParameters());
    }

    public static @NonNull List<@NonNull CollectionLiteralPart> getOwnedPartsList(@NonNull CollectionLiteralExp collectionLiteralExp) {
        return ClassUtil.nullFree(collectionLiteralExp.getOwnedParts());
    }

    public static @NonNull List<@NonNull MapLiteralPart> getOwnedPartsList(@NonNull MapLiteralExp mapLiteralExp) {
        return ClassUtil.nullFree(mapLiteralExp.getOwnedParts());
    }

    public static @NonNull List<@NonNull ShadowPart> getOwnedPartsList(@NonNull ShadowExp shadowExp) {
        return ClassUtil.nullFree(shadowExp.getOwnedParts());
    }

    public static @NonNull List<@NonNull TupleLiteralPart> getOwnedPartsList(@NonNull TupleLiteralExp tupleLiteralExp) {
        return ClassUtil.nullFree(tupleLiteralExp.getOwnedParts());
    }

    public static @NonNull List<@NonNull Property> getOwnedPropertiesList(@NonNull Class asClass) {
        return ClassUtil.nullFree(asClass.getOwnedProperties());
    }

    public static @NonNull List<@NonNull TemplateParameterSubstitution> getOwnedSubstitutionsList(@NonNull TemplateBinding asTemplateBinding) {
        return ClassUtil.nullFree(asTemplateBinding.getOwnedSubstitutions());
    }

    public static @NonNull String getSpecificationRole(@NonNull LanguageExpression asSpecification) {
        Constraint asConstraint = asSpecification.getOwningConstraint();
        if (asConstraint != null) {
            EReference eContainmentFeature = asConstraint.eContainmentFeature();
            if (eContainmentFeature == PivotPackage.Literals.CLASS__OWNED_INVARIANTS) {
                return "\u00abinvariant\u00bb";
            }
            if (eContainmentFeature == PivotPackage.Literals.NAMESPACE__OWNED_CONSTRAINTS) {
                return "\u00abconstraint\u00bb";
            }
            if (eContainmentFeature == PivotPackage.Literals.OPERATION__OWNED_PRECONDITIONS) {
                return "\u00abprecondition\u00bb";
            }
            if (eContainmentFeature == PivotPackage.Literals.OPERATION__OWNED_POSTCONDITIONS) {
                return "\u00abpostcondition\u00bb";
            }
        } else {
            EReference eContainmentFeature = asSpecification.eContainmentFeature();
            if (eContainmentFeature == PivotPackage.Literals.PROPERTY__OWNED_EXPRESSION) {
                return "\u00abinitializer\u00bb";
            }
            if (eContainmentFeature == PivotPackage.Literals.OPERATION__BODY_EXPRESSION) {
                return "\u00abbody\u00bb";
            }
        }
        return "\u00abunknown\u00bb";
    }

    public static @Nullable Property getStatusTupleTypeStatusPart(@NonNull TupleType tupleType) {
        Property statusPart = NameUtil.getNameable(tupleType.getOwnedProperties(), "status");
        if (statusPart == null) {
            return null;
        }
        return statusPart.getTypeId() == TypeId.BOOLEAN ? statusPart : null;
    }

    public static String getStereotype(@NonNull Constraint object) {
        EStructuralFeature eContainingFeature = object.eContainingFeature();
        if (eContainingFeature == PivotPackage.Literals.CLASS__OWNED_INVARIANTS) {
            return "invariant";
        }
        if (eContainingFeature == PivotPackage.Literals.OPERATION__BODY_EXPRESSION) {
            return "body";
        }
        if (eContainingFeature == PivotPackage.Literals.OPERATION__OWNED_POSTCONDITIONS) {
            return "postcondition";
        }
        if (eContainingFeature == PivotPackage.Literals.OPERATION__OWNED_PRECONDITIONS) {
            return "precondition";
        }
        if (eContainingFeature == PivotPackage.Literals.PROPERTY__OWNED_EXPRESSION) {
            return "derivation";
        }
        return "";
    }

    public static @NonNull List<@NonNull Class> getSuperClassesList(@NonNull Class asClass) {
        return ClassUtil.nullFree(asClass.getSuperClasses());
    }

    public static @Nullable Type getType(@Nullable TypedElement typedElement) {
        Class selfType;
        Operation operation;
        if (typedElement == null) {
            return null;
        }
        Type type = typedElement.getType();
        if (type == null) {
            return null;
        }
        if ((type = PivotUtilInternal.getNonLambdaType(type)) instanceof SelfType && typedElement instanceof Parameter && (operation = ((Parameter)typedElement).getOwningOperation()) != null && (selfType = operation.getOwningClass()) != null) {
            type = selfType;
        }
        return type;
    }

    @Deprecated
    public static @NonNull Type getType(@NonNull Type type) {
        assert (!(type instanceof LambdaType));
        Type type1 = PivotUtilInternal.getNonLambdaType(type);
        assert (type1 == type);
        Type type2 = PivotUtil.getBehavioralType(type1);
        return type2;
    }

    public static boolean isASURI(@Nullable String uri) {
        return uri != null && uri.endsWith("as");
    }

    public static boolean isASURI(@Nullable URI uri) {
        return uri != null && PivotUtilInternal.isASURI(uri.toString());
    }

    public static boolean isImplicitPackage(@NonNull Package asPackage) {
        boolean hasImplicits = false;
        if (!asPackage.getOwnedAnnotations().isEmpty()) {
            return false;
        }
        if (!asPackage.getOwnedComments().isEmpty()) {
            return false;
        }
        if (!asPackage.getOwnedConstraints().isEmpty()) {
            return false;
        }
        if (!asPackage.getOwnedExtensions().isEmpty()) {
            return false;
        }
        if (!asPackage.getOwnedInstances().isEmpty()) {
            return false;
        }
        if (!asPackage.getOwnedPackages().isEmpty()) {
            return false;
        }
        for (Class asClass : asPackage.getOwnedClasses()) {
            if (!asClass.getOwnedAnnotations().isEmpty()) {
                return false;
            }
            if (!asClass.getOwnedBehaviors().isEmpty()) {
                return false;
            }
            if (!asClass.getOwnedBindings().isEmpty()) {
                return false;
            }
            if (!asClass.getOwnedComments().isEmpty()) {
                return false;
            }
            if (!asClass.getOwnedConstraints().isEmpty()) {
                return false;
            }
            if (!asClass.getOwnedExtensions().isEmpty()) {
                return false;
            }
            if (!asClass.getOwnedInvariants().isEmpty()) {
                return false;
            }
            if (!asClass.getOwnedOperations().isEmpty()) {
                return false;
            }
            for (Property asProperty : asClass.getOwnedProperties()) {
                if (!asProperty.isIsImplicit()) {
                    return false;
                }
                hasImplicits = true;
            }
        }
        return hasImplicits;
    }

    @Deprecated
    public static boolean isLibraryType(@NonNull Type type) {
        if (type instanceof LambdaType) {
            return false;
        }
        if (type instanceof TupleType) {
            return false;
        }
        if (type instanceof TemplateableElement) {
            return ((TemplateableElement)((Object)type)).getOwnedBindings().isEmpty();
        }
        return false;
    }

    public static boolean isOrphanProperty(@NonNull Property property) {
        return property.getOwningClass() instanceof TupleType;
    }

    public static boolean isOrphanType(@NonNull Type type) {
        if (type instanceof LambdaType) {
            return true;
        }
        if (type instanceof TupleType) {
            return true;
        }
        if (type instanceof TemplateableElement) {
            return ((TemplateableElement)((Object)type)).getOwnedBindings().size() > 0;
        }
        return false;
    }

    public static boolean isValidIdentifier(@Nullable String value) {
        if (value == null) {
            return false;
        }
        int iMax = value.length();
        int i = 0;
        while (i < iMax) {
            char c = value.charAt(i);
            if (!('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || c == '_' || '0' <= c && c <= '9' && i > 0)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static <T extends EObject> void refreshList(@Nullable List<? super T> oldElements, @Nullable List<? extends T> newElements) {
        if (oldElements == null) {
            return;
        }
        if (newElements == null) {
            if (oldElements.size() > 0) {
                oldElements.clear();
            }
            return;
        }
        int k = newElements.size();
        while (k-- > 0) {
            EObject newElement = (EObject)newElements.get(k);
            if (newElement == null || !newElement.eIsProxy()) continue;
            oldElements.remove(newElement);
        }
        k = oldElements.size();
        while (k-- > 0) {
            T oldElement = oldElements.get(k);
            if (newElements.contains(oldElement)) continue;
            oldElements.remove(k);
        }
        int newMax = newElements.size();
        int i = 0;
        while (i < newMax) {
            EObject newElement = (EObject)newElements.get(i);
            int oldMax = oldElements.size();
            boolean reused = false;
            int j = i;
            while (j < oldMax) {
                T oldElement = oldElements.get(j);
                if (oldElement == newElement) {
                    if (j != i) {
                        oldElements.remove(j);
                        oldElements.add(i, newElement);
                    }
                    reused = true;
                    break;
                }
                ++j;
            }
            if (!reused) {
                if (i < oldMax) {
                    oldElements.add(i, newElement);
                } else {
                    oldElements.add(newElement);
                }
            }
            assert (newElements.get(i) == oldElements.get(i));
            ++i;
        }
        int k2 = oldElements.size();
        while (k2 > newMax) {
            oldElements.remove(--k2);
        }
        assert (newElements.size() == oldElements.size());
    }

    public static <T extends EObject> void refreshSet(@Nullable List<? super T> oldElements, @Nullable Collection<? extends T> newElements) {
        if (oldElements == null) {
            return;
        }
        if (newElements == null) {
            oldElements.clear();
            return;
        }
        int i = oldElements.size();
        while (i-- > 0) {
            T oldElement = oldElements.get(i);
            if (newElements.contains(oldElement)) continue;
            oldElements.remove(i);
        }
        for (EObject newElement : newElements) {
            if (newElement == null || newElement.eIsProxy() || oldElements.contains(newElement)) continue;
            oldElements.add(newElement);
        }
    }

    public static void resetContainer(@NonNull EObject eObject) {
        EObject eContainer;
        EStructuralFeature eContainingFeature = eObject.eContainingFeature();
        if (eContainingFeature != null && (eContainer = eObject.eContainer()) != null) {
            if (!eContainingFeature.isMany()) {
                eContainer.eSet(eContainingFeature, null);
            } else {
                Object objects = eContainer.eGet(eContainingFeature);
                if (objects instanceof List) {
                    ((List)objects).remove(eObject);
                }
            }
        }
    }

    public static @NonNull URI trimASExtensionSuffix(@NonNull URI uri) {
        String fileExtension = uri.fileExtension();
        assert (fileExtension.endsWith("as"));
        return uri.trimFileExtension().appendFileExtension(fileExtension.substring(0, fileExtension.length() - "as".length()));
    }
}

