/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.selectors;

import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelectionListener;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.util.EditorFactory;
import org.eclipse.swt.widgets.Composite;

public class StandardSelector
implements IElementSelector {
    @Deprecated
    protected Class<? extends AbstractValueEditor> editorClass;
    private EditorFactory editorFactory;
    protected AbstractValueEditor editor;
    protected Set<IElementSelectionListener> elementSelectionListeners = new HashSet<IElementSelectionListener>();

    @Deprecated
    public StandardSelector(Class<? extends AbstractValueEditor> editorClass) {
        this(StandardSelector.reflexiveEditorFactory(editorClass));
    }

    @Deprecated
    private static EditorFactory reflexiveEditorFactory(Class<? extends AbstractValueEditor> editorClass) {
        return (parent, style, label, commitOnFocusLost) -> {
            try {
                Constructor construct = editorClass.getDeclaredConstructor(Composite.class, Integer.TYPE, String.class, Boolean.TYPE);
                return (AbstractValueEditor)((Object)((Object)construct.newInstance(parent, 2048, null, false)));
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
                return null;
            }
        };
    }

    public StandardSelector(EditorFactory editorFactory) {
        Assert.isNotNull((Object)editorFactory, (String)"The StandardSelector editor class should not be null");
        this.editorFactory = editorFactory;
    }

    @Override
    public Object[] getSelectedElements() {
        Object value = this.editor.getValue();
        if (value == null) {
            return new Object[0];
        }
        return new Object[]{value};
    }

    @Override
    public void setSelectedElements(Object[] elements) {
    }

    @Override
    public Object[] getAllElements() {
        return this.getSelectedElements();
    }

    @Override
    public void createControls(Composite parent) {
        try {
            this.editor = this.editorFactory.create(parent, 2048, null, false);
            this.editor.addCommitListener(new ICommitListener(){

                @Override
                public void commit(AbstractEditor editor) {
                    if (!StandardSelector.this.elementSelectionListeners.isEmpty()) {
                        Object value = StandardSelector.this.editor.getValue();
                        for (IElementSelectionListener listener : StandardSelector.this.elementSelectionListeners) {
                            listener.addElements(new Object[]{value});
                        }
                    }
                }
            });
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    @Override
    public void newObjectCreated(Object newObject) {
    }

    @Override
    public void clearTemporaryElements() {
    }

    @Override
    public void addElementSelectionListener(IElementSelectionListener listener) {
        this.elementSelectionListeners.add(listener);
    }

    @Override
    public void removeElementSelectionListener(IElementSelectionListener listener) {
        this.elementSelectionListeners.remove(listener);
    }

    public EditorFactory getEditorFactory() {
        return this.editorFactory;
    }
}

