/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.core.model;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.composer.api.ComposerPackage;
import org.eclipse.php.composer.api.objects.Autoload;
import org.eclipse.php.composer.core.model.InstallableItem;
import org.eclipse.php.composer.core.model.NamespaceResolverInterface;

public class EclipsePHPPackage
implements NamespaceResolverInterface,
InstallableItem {
    private final ComposerPackage phpPackage;
    private IPath path;

    public EclipsePHPPackage(ComposerPackage phpPackage) {
        Assert.isNotNull((Object)phpPackage);
        this.phpPackage = phpPackage;
    }

    @Override
    public IPath resolve(IResource resource) {
        IPath ns = this.resolve(resource, this.phpPackage.getAutoload());
        if (ns == null) {
            ns = this.resolve(resource, this.phpPackage.getAutoloadDev());
        }
        return ns;
    }

    protected IPath resolve(IResource resource, Autoload autoload) {
        if (autoload == null || autoload.getPsr0() == null || autoload.getPsr0().getFirst() == null) {
            return null;
        }
        String targetDir = this.phpPackage.getTargetDir();
        IPath ns = null;
        IPath path = resource.getFullPath();
        IPath composerPath = this.getPath();
        IPath psr0Path = composerPath.append(autoload.getPsr0().getFirst().getNamespace());
        int segments = psr0Path.segmentCount();
        if (path.matchingFirstSegments(psr0Path) == segments) {
            if (targetDir != null && targetDir.length() > 0) {
                Path target = new Path(targetDir);
                ns = target.append(path.removeFirstSegments(psr0Path.segmentCount()));
            } else {
                ns = path.removeFirstSegments(psr0Path.segmentCount());
            }
        }
        return ns;
    }

    @Override
    public String getName() {
        return this.phpPackage.getName();
    }

    @Override
    public String getDescription() {
        return this.phpPackage.getDescription();
    }

    @Override
    public String getUrl() {
        return this.phpPackage.getHomepage();
    }

    public void setFullPath(String fullPath) {
        this.path = new Path(fullPath);
    }

    public IPath getPath() {
        return this.path;
    }

    public ComposerPackage getPhpPackage() {
        return this.phpPackage;
    }

    @Override
    public IPath reverseResolve(IProject project, String namespace) {
        return null;
    }
}

