/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.ui.providers.support;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.ptp.internal.rm.lml.core.model.Node;
import org.eclipse.ptp.internal.rm.lml.core.model.RowColumnSorter;
import org.eclipse.ptp.rm.lml.core.elements.Nodedisplayelement;
import org.eclipse.ptp.rm.lml.core.elements.ObjectType;
import org.eclipse.ptp.rm.lml.core.model.LMLColor;
import org.eclipse.ptp.rm.lml.core.model.LMLNodeData;
import org.eclipse.ptp.rm.lml.core.model.OIDToObject;
import org.eclipse.ptp.rm.lml.core.model.ObjectStatus;
import org.eclipse.ptp.rm.lml.ui.providers.NodedisplayComp;
import org.eclipse.ptp.rm.lml.ui.providers.support.ColorConversion;
import org.eclipse.ptp.rm.lml.ui.providers.support.JobDetector;
import org.eclipse.ptp.rm.lml.ui.providers.support.UsagebarPainter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class RectanglePaintListener
implements PaintListener,
JobDetector {
    private final List<Node<LMLNodeData>> nodes;
    private final HashMap<Node<LMLNodeData>, Color> nodeToColor;
    private final HashMap<Node<LMLNodeData>, Rectangle> nodeToRectangle;
    private HashMap<Node<LMLNodeData>, Nodedisplayelement> nodeToLayout;
    private int columnCount;
    private final NodedisplayComp nodedisplayComp;
    public int marginWidth = 1;
    public int marginHeight = 1;
    private static final int maxWidthForDoubleBuffer = 30000;
    public int minRectangleWidth = 7;
    public int minRectangleHeight = 7;
    private int rowCount;
    private int rectangleWidth;
    private int rectangleHeight;
    private Rectangle paintArea;
    private final Nodedisplayelement layout;
    private HashMap<Node<LMLNodeData>, RectanglePaintListener> innerListener;
    private HashMap<Node<LMLNodeData>, UsagebarPainter> usagebarsMap;
    private final ObjectStatus objectStatus;
    private final OIDToObject oidToObject;
    private final Composite usingListener;
    private final boolean rootListener;
    private Image doubleBuffer = null;

    public RectanglePaintListener(List<Node<LMLNodeData>> nodes, NodedisplayComp nodeComp, Composite usingListener) {
        this(nodes, nodeComp, nodeComp.getNodedisplayLayout(), usingListener, new Rectangle(0, 0, usingListener.getSize().x, usingListener.getSize().y), true);
    }

    protected RectanglePaintListener(List<Node<LMLNodeData>> nodes, NodedisplayComp nodeComp, Nodedisplayelement layout, Composite usingListener, Rectangle paintArea, boolean rootListener) {
        this.paintArea = paintArea;
        this.nodes = nodes;
        this.layout = layout;
        this.columnCount = this.layout.getCols().intValue();
        this.nodedisplayComp = nodeComp;
        if (this.columnCount <= 0) {
            this.columnCount = 1;
        }
        this.oidToObject = this.nodedisplayComp.getLguiItem().getOIDToObject();
        this.nodeToColor = this.nodedisplayComp.generateNodeToColorMap(this.nodes);
        this.nodeToRectangle = new HashMap();
        this.objectStatus = this.nodedisplayComp.getLguiItem().getObjectStatus();
        this.usingListener = usingListener;
        this.initInnerListener();
        this.rootListener = rootListener;
        this.updateRectangleSize();
    }

    @Override
    public void detectJobPositions(Set<Point> points, String jobId) {
        this.updateRectangleSize();
        int x = 0;
        while (x < this.columnCount) {
            int y = 0;
            while (y < this.rowCount) {
                this.detectPaintPositionsForChild(points, jobId, x, y);
                ++y;
            }
            ++x;
        }
    }

    public void dispose() {
        for (RectanglePaintListener childPainter : this.innerListener.values()) {
            childPainter.dispose();
        }
        if (this.doubleBuffer != null) {
            this.doubleBuffer.dispose();
        }
    }

    public ObjectType getJobAtPos(int x, int y) {
        return this.getJobAtPos(this.getNodeAtPos(x, y), x);
    }

    public ObjectType getJobAtPos(Node<LMLNodeData> node, int x) {
        if (node == null) {
            return null;
        }
        UsagebarPainter usage = this.getUsagebarConnectedToNode(node);
        if (usage != null) {
            return usage.getJobAtPosition(x);
        }
        return this.nodedisplayComp.getLguiItem().getOIDToObject().getObjectByLMLNode((LMLNodeData)node.getData());
    }

    public Point getMinimalSize() {
        int horizontalSpacing = this.layout.getHgap().intValue();
        int verticalSpacing = this.layout.getVgap().intValue();
        int rectWidth = this.minRectangleWidth;
        int rectHeight = this.minRectangleHeight;
        if (this.innerListener.size() > 0) {
            for (RectanglePaintListener listener : this.innerListener.values()) {
                Point minSize = listener.getMinimalSize();
                if (minSize.x > rectWidth) {
                    rectWidth = minSize.x;
                }
                if (minSize.y <= rectHeight) continue;
                rectHeight = minSize.y;
            }
        }
        return new Point((rectWidth + horizontalSpacing) * this.columnCount + 2 * this.marginWidth, (rectHeight + verticalSpacing) * this.rowCount + 2 * this.marginHeight);
    }

    public Node<LMLNodeData> getNodeAtPos(int xCursor, int yCursor) {
        int x = xCursor - this.marginWidth - this.paintArea.x;
        int y = yCursor - this.marginHeight - this.paintArea.y;
        if (x < 0 || y < 0) {
            return null;
        }
        if (this.rectangleWidth == 0 || this.rectangleHeight == 0) {
            return null;
        }
        int column = x / this.rectangleWidth;
        int row = y / this.rectangleHeight;
        if (column >= this.columnCount || row >= this.rowCount) {
            return null;
        }
        int index = row * this.columnCount + column;
        if (index >= this.nodes.size()) {
            return null;
        }
        Node<LMLNodeData> connNode = this.nodes.get(index);
        if (this.innerListener.containsKey(connNode)) {
            return this.innerListener.get(connNode).getNodeAtPos(xCursor, yCursor);
        }
        return connNode;
    }

    public UsagebarPainter getUsagebarConnectedToNode(Node<LMLNodeData> node) {
        if (this.nodes.contains(node)) {
            return this.usagebarsMap.get(node);
        }
        for (RectanglePaintListener currentListener : this.innerListener.values()) {
            UsagebarPainter usagebar = currentListener.getUsagebarConnectedToNode(node);
            if (usagebar == null) continue;
            return usagebar;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintControl(PaintEvent event) {
        RectanglePaintListener rectanglePaintListener = this;
        synchronized (rectanglePaintListener) {
            this.updateRectangleSize();
            if (!this.isPaintAreaVisible()) {
                return;
            }
            GC eventGC = null;
            GC doubleBufGC = null;
            if (this.doDoubleBuffering()) {
                eventGC = event.gc;
                doubleBufGC = new GC((Drawable)this.doubleBuffer);
                doubleBufGC.setForeground(eventGC.getForeground());
                doubleBufGC.setFont(eventGC.getFont());
                event.gc = doubleBufGC;
            }
            Color backgroundColor = ColorConversion.getColor(LMLColor.stringToColor((String)this.layout.getBackground()));
            event.gc.setBackground(backgroundColor);
            event.gc.fillRectangle(this.paintArea);
            int x = 0;
            while (x < this.columnCount) {
                int y = 0;
                while (y < this.rowCount) {
                    this.paintChild(event, x, y);
                    ++y;
                }
                ++x;
            }
            if (this.doDoubleBuffering()) {
                if (eventGC != null) {
                    eventGC.drawImage(this.doubleBuffer, 0, 0);
                }
                if (doubleBufGC != null) {
                    doubleBufGC.dispose();
                }
            }
        }
    }

    public void setMinimumRectangleHeight(int height) {
        this.minRectangleHeight = height;
        for (RectanglePaintListener inner : this.innerListener.values()) {
            inner.setMinimumRectangleHeight(height);
        }
    }

    public void setMinimumRectangleWidth(int width) {
        this.minRectangleWidth = width;
        for (RectanglePaintListener inner : this.innerListener.values()) {
            inner.setMinimumRectangleWidth(width);
        }
    }

    public void setMinRectangleSize(int size) {
        this.setMinimumRectangleHeight(size);
        this.setMinimumRectangleWidth(size);
    }

    public void updatePaintArea(Rectangle paintArea) {
        this.paintArea = paintArea;
    }

    private void initInnerListener() {
        this.innerListener = new HashMap();
        this.nodeToLayout = new HashMap();
        this.usagebarsMap = new HashMap();
        int index = 0;
        while (index < this.nodes.size()) {
            Node<LMLNodeData> node = this.nodes.get(index);
            Nodedisplayelement layout = this.nodedisplayComp.findLayout((LMLNodeData)node.getData());
            this.nodeToLayout.put(node, layout);
            if (node.getLowerLevelCount() > 0) {
                List reorderedChildren = new RowColumnSorter(node.getChildren()).reorder(layout.isHighestrowfirst(), layout.isHighestcolfirst(), layout.getCols().intValue());
                RectanglePaintListener newListener = new RectanglePaintListener(reorderedChildren, this.nodedisplayComp, layout, this.usingListener, this.getRectangleForNode(index), false);
                this.innerListener.put(node, newListener);
            } else if (((LMLNodeData)node.getData()).getDataElement().getUsage() != null && ((LMLNodeData)node.getData()).isDataElementOnNodeLevel()) {
                UsagebarPainter usagebarPainter = new UsagebarPainter(this.nodedisplayComp.getLguiItem(), ((LMLNodeData)node.getData()).getDataElement().getUsage(), this.getRectangleForNode(index));
                usagebarPainter.setPaintScale(false);
                usagebarPainter.setBarFactor(1.0);
                usagebarPainter.setStandardFrame(layout.getBorder().intValue());
                usagebarPainter.setMouseOverFrame(layout.getMouseborder().intValue());
                this.usagebarsMap.put(node, usagebarPainter);
            }
            ++index;
        }
    }

    private boolean isPaintAreaVisible() {
        Rectangle bounds = NodedisplayComp.getNextNodedisplayBounds(this.usingListener);
        Rectangle areaInNodedisplayComp = new Rectangle(bounds.x + this.paintArea.x, bounds.y + this.paintArea.y, this.paintArea.width, this.paintArea.height);
        return this.nodedisplayComp.isRectangleVisible(areaInNodedisplayComp);
    }

    private boolean paintChild(PaintEvent event, int x, int y) {
        Node<LMLNodeData> node = this.getNodeByIndexPosition(x, y);
        if (node == null) {
            return true;
        }
        Nodedisplayelement currentLayout = this.nodeToLayout.get(node);
        Rectangle rectangle = this.getPaintAreaForNodePosition(x, y);
        Color borderColor = ColorConversion.getColor(LMLColor.stringToColor((String)currentLayout.getBordercolor()));
        event.gc.setBackground(borderColor);
        event.gc.fillRectangle(rectangle);
        if (!this.innerListener.containsKey(node)) {
            this.paintLowestLevelChild(event, node, currentLayout, rectangle);
        } else {
            Rectangle decreasedRectangle = this.getInnerPaintAreaForRecursiveListener(rectangle, currentLayout);
            this.paintHigherLevelChild(event, node, decreasedRectangle);
        }
        this.nodeToRectangle.put(node, rectangle);
        return false;
    }

    private void paintHigherLevelChild(PaintEvent event, Node<LMLNodeData> node, Rectangle rectangle) {
        RectanglePaintListener rectanglePaintListener = this.innerListener.get(node);
        rectanglePaintListener.updatePaintArea(rectangle);
        rectanglePaintListener.paintControl(event);
    }

    private void paintLowestLevelChild(PaintEvent event, Node<LMLNodeData> node, Nodedisplayelement currentLayout, Rectangle rectangle) {
        if (this.usagebarsMap.containsKey(node)) {
            UsagebarPainter usagebarPainter = this.usagebarsMap.get(node);
            usagebarPainter.updatePaintArea(rectangle);
            usagebarPainter.paintControl(event);
            return;
        }
        if (this.objectStatus.isAnyMouseDown() && !this.objectStatus.isMouseDown(this.oidToObject.getObjectByLMLNode((LMLNodeData)node.getData()))) {
            event.gc.setBackground(ColorConversion.getColor(this.nodedisplayComp.getLguiItem().getOIDToObject().getColorById(null)));
        } else {
            event.gc.setBackground(this.nodeToColor.get(node));
        }
        Rectangle innerRec = this.getLowestLevelFillRectangle(node, currentLayout, rectangle);
        event.gc.fillRectangle(innerRec);
    }

    protected void detectHigherLevelChild(Set<Point> points, String jobId, Node<LMLNodeData> node, Rectangle rectangle) {
        RectanglePaintListener rectanglePaintListener = this.innerListener.get(node);
        rectanglePaintListener.updatePaintArea(rectangle);
        rectanglePaintListener.detectJobPositions(points, jobId);
    }

    protected void detectLowestLevelChild(Set<Point> points, String jobId, Node<LMLNodeData> node, Nodedisplayelement currentLayout, Rectangle rectangle) {
        if (this.usagebarsMap.containsKey(node)) {
            UsagebarPainter usagebarPainter = this.usagebarsMap.get(node);
            usagebarPainter.updatePaintArea(rectangle);
            usagebarPainter.detectJobPositions();
            List<UsagebarPainter.JobInterval> jobintervals = usagebarPainter.getJobIntervals();
            for (UsagebarPainter.JobInterval interval : jobintervals) {
                if (!interval.job.getId().equals(jobId)) continue;
                Rectangle subPaintArea = NodedisplayComp.getNextNodedisplayBounds(this.usingListener);
                Point jobPoint = this.nodedisplayComp.getPositionInScrollComp(new Point(rectangle.x + subPaintArea.x + interval.start, rectangle.y + subPaintArea.y));
                points.add(jobPoint);
            }
            return;
        }
        Rectangle innerRec = this.getLowestLevelFillRectangle(node, currentLayout, rectangle);
        if (node.getData() != null && ((LMLNodeData)node.getData()).getDataElement() != null && ((LMLNodeData)node.getData()).getDataElement().getOid() != null && ((LMLNodeData)node.getData()).getDataElement().getOid().equals(jobId)) {
            Rectangle subPaintArea = NodedisplayComp.getNextNodedisplayBounds(this.usingListener);
            Point jobPoint = this.nodedisplayComp.getPositionInScrollComp(new Point(subPaintArea.x + innerRec.x, subPaintArea.y + innerRec.y));
            points.add(jobPoint);
        }
    }

    protected void detectPaintPositionsForChild(Set<Point> points, String jobId, int x, int y) {
        Node<LMLNodeData> node = this.getNodeByIndexPosition(x, y);
        if (node == null) {
            return;
        }
        Nodedisplayelement currentLayout = this.nodeToLayout.get(node);
        Rectangle rectangle = this.getPaintAreaForNodePosition(x, y);
        if (!this.innerListener.containsKey(node)) {
            this.detectLowestLevelChild(points, jobId, node, currentLayout, rectangle);
        } else {
            Rectangle decreasedRectangle = this.getInnerPaintAreaForRecursiveListener(rectangle, currentLayout);
            this.detectHigherLevelChild(points, jobId, node, decreasedRectangle);
        }
    }

    protected boolean doDoubleBuffering() {
        return this.rootListener && this.doubleBuffer != null && this.doubleBuffer.getBounds().width < 30000 && this.doubleBuffer.getBounds().height < 30000;
    }

    protected Rectangle getInnerPaintAreaForRecursiveListener(Rectangle outer, Nodedisplayelement layout) {
        int borderSize = layout.getBorder().intValue();
        Rectangle decreasedRectangle = new Rectangle(outer.x + borderSize, outer.y + borderSize, outer.width - 2 * borderSize, outer.height - 2 * borderSize);
        return decreasedRectangle;
    }

    protected Rectangle getLowestLevelFillRectangle(Node<LMLNodeData> node, Nodedisplayelement currentLayout, Rectangle rectangle) {
        int border = currentLayout.getBorder().intValue();
        if (this.objectStatus.isMouseOver(this.oidToObject.getObjectByLMLNode((LMLNodeData)node.getData()))) {
            border = currentLayout.getMouseborder().intValue();
        }
        int innerWidth = rectangle.width - 2 * border;
        int innerHeight = rectangle.height - 2 * border;
        int x = rectangle.x + border;
        int y = rectangle.y + border;
        if (innerWidth <= 0) {
            innerWidth = 1;
            x = rectangle.x;
        }
        if (innerHeight <= 0) {
            innerHeight = 1;
            y = rectangle.y;
        }
        return new Rectangle(x, y, innerWidth, innerHeight);
    }

    protected Node<LMLNodeData> getNodeByIndexPosition(int x, int y) {
        int index = y * this.columnCount + x;
        if (index >= this.nodes.size()) {
            return null;
        }
        return this.nodes.get(index);
    }

    protected Rectangle getPaintAreaForNodePosition(int x, int y) {
        int horizontalSpacing = this.layout.getHgap().intValue();
        int verticalSpacing = this.layout.getVgap().intValue();
        Rectangle rectangle = new Rectangle(this.marginWidth + this.rectangleWidth * x + this.paintArea.x, this.marginHeight + this.rectangleHeight * y + this.paintArea.y, this.rectangleWidth - horizontalSpacing, this.rectangleHeight - verticalSpacing);
        return rectangle;
    }

    protected Rectangle getRectangleForNode(int childNodeIndex) {
        if (childNodeIndex >= this.nodes.size()) {
            return null;
        }
        int x = childNodeIndex % this.columnCount;
        int y = childNodeIndex / this.columnCount;
        int horizontalSpacing = this.layout.getHgap().intValue();
        int verticalSpacing = this.layout.getVgap().intValue();
        Rectangle result = new Rectangle(this.marginWidth + this.rectangleWidth * x, this.marginHeight + this.rectangleHeight * y, this.rectangleWidth - horizontalSpacing, this.rectangleHeight - verticalSpacing);
        return result;
    }

    protected void updateRectangleSize() {
        if (this.rootListener) {
            Point nodedisplaySize = this.usingListener.getSize();
            this.updatePaintArea(new Rectangle(0, 0, nodedisplaySize.x, nodedisplaySize.y));
            Rectangle subPaintArea = NodedisplayComp.getNextNodedisplayBounds(this.usingListener);
            int imgWidth = subPaintArea.width;
            int imgHeight = subPaintArea.height;
            if (imgWidth == 0) {
                imgWidth = 1;
            }
            if (imgHeight == 0) {
                imgHeight = 1;
            }
            if (this.doubleBuffer == null || this.doubleBuffer.getBounds().width != imgWidth || this.doubleBuffer.getBounds().height != imgHeight || this.doubleBuffer.isDisposed()) {
                if (this.doubleBuffer != null) {
                    this.doubleBuffer.dispose();
                }
                this.doubleBuffer = new Image((Device)this.nodedisplayComp.getDisplay(), imgWidth, imgHeight);
            }
        }
        Point size = new Point(this.paintArea.width, this.paintArea.height);
        int width = size.x - this.marginWidth * 2;
        int height = size.y - this.marginHeight * 2;
        if (width < 0) {
            width = 0;
        }
        if (height < 0) {
            height = 0;
        }
        if (this.columnCount <= 0) {
            this.columnCount = 1;
        }
        this.rowCount = this.nodes.size() / this.columnCount;
        if (this.nodes.size() % this.columnCount != 0) {
            ++this.rowCount;
        }
        if (this.rowCount == 0) {
            return;
        }
        this.rectangleWidth = width / this.columnCount;
        this.rectangleHeight = height / this.rowCount;
    }
}

