/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.Concurrency;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.CompositePartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.pivot.qvtschedule.CompositePartition;
import org.eclipse.qvtd.pivot.qvtschedule.MappingPartition;

public abstract class AbstractCompositePartitionAnalysis<P extends CompositePartition>
extends AbstractPartitionAnalysis<P>
implements CompositePartitionAnalysis {
    protected final @NonNull Map<@NonNull PartitionAnalysis, @NonNull Set<@NonNull PartitionAnalysis>> originalPartitionAnalysis2predecessors;
    protected final @NonNull Set<@NonNull PartitionAnalysis> partitionAnalyses;
    private @Nullable List<@NonNull Concurrency> partitionSchedule = null;

    protected AbstractCompositePartitionAnalysis(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis, @NonNull P controlPartition, @NonNull Map<@NonNull PartitionAnalysis, @NonNull Set<@NonNull PartitionAnalysis>> partitionAnalysis2predecessors) {
        super(partitionedTransformationAnalysis, controlPartition);
        this.originalPartitionAnalysis2predecessors = partitionAnalysis2predecessors;
        this.partitionAnalyses = new HashSet<PartitionAnalysis>(partitionAnalysis2predecessors.keySet());
        List ownedMappingPartitions = controlPartition.getOwnedMappingPartitions();
        for (PartitionAnalysis partitionAnalysis : this.partitionAnalyses) {
            ownedMappingPartitions.add((MappingPartition)partitionAnalysis.getPartition());
        }
    }

    protected void appendConcurrency(@NonNull List<@NonNull Concurrency> partitionSchedule, @NonNull Iterable<@NonNull PartitionAnalysis> partitionAnalyses) {
        Concurrency nonCompositeConcurrency = null;
        for (PartitionAnalysis partitionAnalysis : partitionAnalyses) {
            if (partitionAnalysis instanceof CompositePartitionAnalysis) continue;
            if (nonCompositeConcurrency == null) {
                nonCompositeConcurrency = new Concurrency();
            }
            nonCompositeConcurrency.add(partitionAnalysis);
        }
        if (nonCompositeConcurrency != null) {
            partitionSchedule.add(nonCompositeConcurrency);
        }
        int compositeConcurrencyPass = partitionSchedule.size();
        for (PartitionAnalysis partitionAnalysis : partitionAnalyses) {
            if (!(partitionAnalysis instanceof CompositePartitionAnalysis)) continue;
            Iterable<@NonNull Concurrency> nestedConcurrencies = ((CompositePartitionAnalysis)partitionAnalysis).getPartitionSchedule();
            this.overlayConcurrency(partitionSchedule, compositeConcurrencyPass, nestedConcurrencies);
        }
    }

    protected abstract @NonNull List<@NonNull Concurrency> createPartitionSchedule();

    @Override
    public @NonNull Iterable<@NonNull PartitionAnalysis> getPartitionAnalyses() {
        return this.partitionAnalyses;
    }

    public @NonNull List<@NonNull Concurrency> getPartitionSchedule() {
        List<@NonNull Concurrency> partitionSchedule2 = this.partitionSchedule;
        if (partitionSchedule2 == null) {
            this.partitionSchedule = partitionSchedule2 = this.createPartitionSchedule();
        }
        return partitionSchedule2;
    }

    public void merge(@NonNull Map<@NonNull PartitionAnalysis, @Nullable PartitionAnalysis> old2new) {
        List ownedMappingPartitions = ((CompositePartition)this.partition).getOwnedMappingPartitions();
        for (PartitionAnalysis oldPartitionAnalysis : new HashSet<PartitionAnalysis>(old2new.keySet())) {
            boolean wasRemoved = this.partitionAnalyses.remove(oldPartitionAnalysis);
            assert (wasRemoved);
            assert (!ownedMappingPartitions.contains(oldPartitionAnalysis.getPartition()));
            PartitionAnalysis newPartitionAnalysis = old2new.get(oldPartitionAnalysis);
            if (newPartitionAnalysis == null) continue;
            this.partitionAnalyses.add(newPartitionAnalysis);
            assert (ownedMappingPartitions.contains(newPartitionAnalysis.getPartition()));
        }
    }

    private void overlayConcurrency(@NonNull List<@NonNull Concurrency> partitionSchedule, int initialPass, @NonNull Iterable<@NonNull Concurrency> newConcurrencies) {
        int mergePass = initialPass;
        for (Concurrency newConcurrency : newConcurrencies) {
            assert (newConcurrency.size() > 0);
            if (partitionSchedule.size() <= mergePass) {
                partitionSchedule.add(new Concurrency());
            }
            assert (mergePass < partitionSchedule.size());
            Concurrency concurrency = partitionSchedule.get(mergePass);
            if (newConcurrency.isCycleStart()) {
                concurrency.setCycleStart();
            }
            if (newConcurrency.isCycleEnd()) {
                concurrency.setCycleEnd();
            }
            for (PartitionAnalysis partitionAnalysis : newConcurrency) {
                concurrency.add(partitionAnalysis);
            }
            ++mergePass;
        }
    }
}

