/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtbase.graphs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.pivot.qvtbase.graphs.GraphStringBuilder;
import org.eclipse.qvtd.pivot.qvtbase.graphs.ToGraphHelper;

public class DOTStringBuilder
implements GraphStringBuilder {
    protected static @NonNull String NULL_PLACEHOLDER = "\"<null>\"";
    private final @NonNull StringBuilder s = new StringBuilder();
    private int indents = 0;
    private boolean indentPending = false;
    private final @NonNull Map<@Nullable Object, @NonNull Map<@NonNull Object, @NonNull String>> scope2node2name = new HashMap<Object, Map<Object, String>>();
    private final @NonNull List<@NonNull String> clusterName = new ArrayList<String>();
    private final @NonNull Map<@NonNull String, @NonNull String> attributes = new HashMap<String, String>();
    private @NonNull Map<@NonNull Object, @NonNull String> node2name = new HashMap<Object, String>();
    private int nameCount = 0;

    public DOTStringBuilder() {
        this.scope2node2name.put(null, this.node2name);
        this.append("digraph ");
        this.append("schedule");
        this.append(" {");
        ++this.indents;
        this.append("fontname=arial;");
        this.append("edge [fontname=arial,penwidth=2,arrowsize=1.5];");
        this.append("node [shape=rectangle,fontname=arial,penwidth=2];");
        this.append("nodesep=1;ranksep=1;compound=true;");
        this.newLine();
    }

    public void append(@Nullable Number number) {
        if (this.indentPending) {
            this.indentPending = false;
            int i = 0;
            while (i < this.indents) {
                this.append("  ");
                ++i;
            }
        }
        if (number != null) {
            this.s.append(number.toString());
        } else {
            this.s.append(NULL_PLACEHOLDER);
        }
    }

    public void append(@Nullable String string) {
        if (this.indentPending) {
            this.indentPending = false;
            int i = 0;
            while (i < this.indents) {
                this.append("  ");
                ++i;
            }
        }
        if (string != null) {
            this.s.append(string);
        } else {
            this.s.append(NULL_PLACEHOLDER);
        }
    }

    @Override
    public void appendAttributedEdge(@NonNull String sourceName, @NonNull GraphStringBuilder.GraphEdge edge, @NonNull String targetName) {
    }

    @Override
    public void appendAttributedNode(@NonNull String nodeName) {
        boolean isHead = this.attributes.containsKey("head");
        if (isHead) {
            this.append("{rank=source;");
        }
        this.append(nodeName);
        this.appendAttributes();
        if (isHead) {
            this.append("}");
        }
    }

    private void appendAttributes() {
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            if (isFirst) {
                this.s.append("[");
            } else {
                this.s.append(",");
            }
            isFirst = false;
            this.s.append(entry.getKey());
            this.s.append("=");
            this.s.append(entry.getValue());
        }
        if (!isFirst) {
            this.s.append("]");
        }
        this.attributes.clear();
    }

    @Override
    public void appendEdge(@NonNull ToGraphHelper toGraphHelper, @NonNull GraphStringBuilder.GraphNode source, @NonNull GraphStringBuilder.GraphEdge edge, @NonNull GraphStringBuilder.GraphNode target) {
        String sourceName = this.appendNode(toGraphHelper, source);
        String targetName = this.appendNode(toGraphHelper, target);
        this.append(sourceName);
        this.append(" -> ");
        this.append(targetName);
        this.attributes.clear();
        edge.appendEdgeAttributes(toGraphHelper, sourceName, targetName);
        this.appendAttributes();
        this.newLine();
    }

    @Override
    public @NonNull String appendNode(@NonNull ToGraphHelper toGraphHelper, @NonNull GraphStringBuilder.GraphNode object) {
        String name = this.node2name.get(object);
        if (name == null) {
            Map<@NonNull Object, @NonNull String> globalNode2Name = this.scope2node2name.get(null);
            assert (globalNode2Name != null);
            name = globalNode2Name.get(object);
        }
        if (name == null) {
            name = "a" + ++this.nameCount;
            this.node2name.put(object, name);
            this.attributes.clear();
            object.appendNode(toGraphHelper, name);
            this.newLine();
        }
        return name;
    }

    public void newLine() {
        this.append("\n");
        this.indentPending = true;
    }

    @Override
    public void popCluster() {
        --this.indents;
        this.append("}");
        this.newLine();
    }

    @Override
    public void pushCluster() {
        String name = "cluster_" + this.clusterName.size();
        this.clusterName.add(name);
        this.append("subgraph " + name + " {");
        ++this.indents;
        this.newLine();
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            this.append(entry.getKey());
            this.append("=");
            this.append(entry.getValue());
            this.append(";");
            this.newLine();
        }
        this.attributes.clear();
    }

    @Override
    public void setArrowhead(@NonNull String value) {
        this.attributes.put("arrowhead", value);
    }

    @Override
    public void setArrowtail(@NonNull String value) {
        this.attributes.put("arrowtail", value);
    }

    @Override
    public void setColor(@NonNull String value) {
        this.attributes.put("color", value);
    }

    @Override
    public void setDir(@NonNull String direction) {
        this.attributes.put("dir", direction);
    }

    @Override
    public void setFillColor(@NonNull String value) {
        this.attributes.put("fillcolor", value);
    }

    @Override
    public void setHead() {
        this.attributes.put("head", "true");
    }

    @Override
    public void setHeadlabel(String value) {
        this.attributes.put("headlabel", String.valueOf('\"') + value + '\"');
    }

    @Override
    public void setLabel(String value) {
        this.attributes.put("label", String.valueOf('\"') + value + '\"');
    }

    public void setLhead(String value) {
        this.attributes.put("lhead", value);
    }

    public void setLtail(String value) {
        this.attributes.put("ltail", value);
    }

    @Override
    public void setPenwidth(@NonNull Integer value) {
        this.attributes.put("penwidth", value.toString());
    }

    @Override
    public void setScope(@Nullable Object scopeObject) {
        Map<@NonNull Object, @NonNull String> entry = this.scope2node2name.get(scopeObject);
        if (entry == null) {
            entry = new HashMap<Object, String>();
            this.scope2node2name.put(scopeObject, entry);
        }
        this.node2name = entry;
    }

    @Override
    public void setShape(@NonNull String value) {
        this.attributes.put("shape", value);
    }

    @Override
    public void setStyle(@NonNull String value) {
        this.attributes.put("style", value);
    }

    @Override
    public void setTaillabel(String value) {
        this.attributes.put("taillabel", String.valueOf('\"') + value + '\"');
    }

    @Override
    public @NonNull String toString() {
        if (this.indents > 0) {
            --this.indents;
            this.append("}");
            this.newLine();
        }
        return this.s.toString();
    }
}

