/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.preferences;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.rcptt.ui.editors.ecl.ECLEditorPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ECLPreferenceContentAssistPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button autoActivationCheckBox;
    private Text autoActivationTriggersForECLScript;
    private Text autoActivationDelayInMS;

    public boolean performOk() {
        if (this.autoActivationCheckBox.getSelection()) {
            ECLEditorPlugin.setECLScriptContentAssistActivationState(1);
        } else {
            ECLEditorPlugin.setECLScriptContentAssistActivationState(0);
        }
        ECLEditorPlugin.setECLScriptContentAssistDelay(Integer.parseInt(this.autoActivationDelayInMS.getText()));
        ECLEditorPlugin.setECLScriptContentAssistTriggers(this.autoActivationTriggersForECLScript.getText());
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }

    private boolean isPositiveInteger(String value) {
        try {
            if (Integer.parseInt(value) >= 0) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    private String doValidate() {
        if (!this.isPositiveInteger(this.autoActivationDelayInMS.getText())) {
            return "Autoactivation delay should be positive number";
        }
        return null;
    }

    private void validate() {
        String message = this.doValidate();
        this.setErrorMessage(message);
        this.setValid(message == null);
    }

    private Text createText(Composite parent, String labelText, String initialValue) {
        Label label = new Label(parent, 16384);
        label.setText(labelText);
        Text text = new Text(parent, 2048);
        text.setText(initialValue);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ECLPreferenceContentAssistPage.this.validate();
            }
        });
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private Button createCheckBoxButton(Composite parent, String labelText, boolean state) {
        Label label = new Label(parent, 16384);
        label.setText(labelText);
        Button button = new Button(parent, 32);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean state = ECLPreferenceContentAssistPage.this.autoActivationCheckBox.getSelection();
                ECLPreferenceContentAssistPage.this.autoActivationDelayInMS.setEnabled(state);
                ECLPreferenceContentAssistPage.this.autoActivationTriggersForECLScript.setEnabled(state);
            }
        });
        button.setSelection(state);
        return button;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.autoActivationCheckBox = this.createCheckBoxButton(composite, "Enable Auto Activation", ECLEditorPlugin.getECLScriptContentAssistActivationState());
        this.autoActivationDelayInMS = this.createText(composite, "Auto Activation Delay (ms)", Integer.toString(ECLEditorPlugin.getECLScriptContentAssistDelay()));
        this.autoActivationTriggersForECLScript = this.createText(composite, "Auto Activation Triggers for ECL Script", ECLEditorPlugin.getECLScriptContentAssistTriggers());
        this.autoActivationDelayInMS.setEnabled(ECLEditorPlugin.getECLScriptContentAssistActivationState());
        this.autoActivationTriggersForECLScript.setEnabled(ECLEditorPlugin.getECLScriptContentAssistActivationState());
        return null;
    }

    protected void performDefaults() {
        this.autoActivationCheckBox.setSelection(true);
        this.autoActivationDelayInMS.setText(Integer.toString(200));
        this.autoActivationTriggersForECLScript.setText(" -[$");
        this.autoActivationDelayInMS.setEnabled(ECLEditorPlugin.getECLScriptContentAssistActivationState());
        this.autoActivationTriggersForECLScript.setEnabled(ECLEditorPlugin.getECLScriptContentAssistActivationState());
        super.performDefaults();
    }
}

