/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.handler;

import java.util.Arrays;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.handler.ControlHandler;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;

public class ComboHandler
extends ControlHandler {
    private static final Logger log = Logger.getLogger(ComboHandler.class);
    private static ComboHandler instance;

    public static ComboHandler getInstance() {
        if (instance == null) {
            instance = new ComboHandler();
        }
        return instance;
    }

    public String[] getItems(final Combo combo) {
        return (String[])Display.syncExec((ResultRunnable)new ResultRunnable<String[]>(){

            public String[] run() {
                return combo.getItems();
            }
        });
    }

    public void setSelection(final Combo combo, final int index) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                int itemsLength = ComboHandler.this.getItems(combo).length;
                if (index >= itemsLength) {
                    log.error("Combo does not have " + index + 1 + "items!");
                    log.info("Combo has " + itemsLength + " items");
                    throw new CoreLayerException("Nonexisted item in combo was requested");
                }
                combo.select(index);
            }
        });
    }

    public void setSelection(final Combo combo, final String text) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                String[] items = ComboHandler.this.getItems(combo);
                int index = Arrays.asList(items).indexOf(text);
                if (index == -1) {
                    log.error("'" + text + "' is not " + "contained in combo items");
                    log.info("Items present in combo:");
                    int i = 0;
                    String[] stringArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String item = stringArray[n2];
                        log.info("    " + item + "(index " + i);
                        ++i;
                        ++n2;
                    }
                    throw new CoreLayerException("Nonexisting item in combo with text \"" + text + "\" was requested");
                }
                combo.select(index);
            }
        });
    }

    public String getSelection(final Combo combo) {
        return (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                Point selection = combo.getSelection();
                String comboText = combo.getText();
                String selectionText = "";
                if (selection.y > selection.x) {
                    selectionText = comboText.substring(selection.x, selection.y);
                }
                return selectionText;
            }
        });
    }

    public int getSelectionIndex(final Combo combo) {
        return (Integer)Display.syncExec((ResultRunnable)new ResultRunnable<Integer>(){

            public Integer run() {
                return combo.getSelectionIndex();
            }
        });
    }

    public void setText(final Combo combo, final String text) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                combo.setText(text);
            }
        });
    }

    public String getText(final Combo combo) {
        return (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                return combo.getText();
            }
        });
    }
}

