/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.operation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.manipulation.JavaManipulation;
import org.eclipse.jdt.core.manipulation.OrganizeImportsOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.scout.sdk.s2e.operation.IOperation;
import org.eclipse.scout.sdk.s2e.operation.IWorkingCopyManager;

public class OrganizeImportOperation
implements IOperation {
    private ICompilationUnit m_icu;

    public OrganizeImportOperation() {
        this(null);
    }

    public OrganizeImportOperation(ICompilationUnit icu) {
        this.m_icu = icu;
    }

    @Override
    public String getOperationName() {
        return "Organize imports of compilation unit";
    }

    @Override
    public void validate() {
        if (this.getCompilationUnit() == null) {
            throw new IllegalArgumentException("compilation unit is null");
        }
    }

    @Override
    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        if (JavaManipulation.getPreferenceNodeId() == null) {
            return;
        }
        ICompilationUnit unit = this.getCompilationUnit();
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)unit.getJavaProject());
        OrganizeImportsOperation organizeImps = new OrganizeImportsOperation(unit, null, settings.importIgnoreLowercase, !unit.isWorkingCopy(), true, null);
        organizeImps.run(monitor);
    }

    public ICompilationUnit getCompilationUnit() {
        return this.m_icu;
    }

    public void setCompilationUnit(ICompilationUnit icu) {
        this.m_icu = icu;
    }
}

