/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.interpreter;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public final class TypeName {
    public static final TypeName ANY_TYPENAME = new TypeName("ecore.EJavaObject");
    public static final TypeName EOBJECT_TYPENAME = new TypeName("ecore.EObject");
    private static final String SEPARATOR = ".";
    private final String typeName;
    private Class<?> javaType;

    private TypeName(String typeName) {
        this.typeName = typeName;
    }

    public TypeName(Class<?> type) {
        this.javaType = type;
        this.typeName = type.getName();
    }

    public String getCompleteName() {
        return this.typeName;
    }

    public String getCompleteName(String separator) {
        Option<String> packagePrefix = this.getPackagePrefix();
        if (packagePrefix.some()) {
            return String.valueOf((String)packagePrefix.get()) + separator + this.getClassifierName();
        }
        return this.getClassifierName();
    }

    public Collection<EClassifier> search(Collection<EPackage> availableEPackages) {
        LinkedHashSet<EClassifier> matches = new LinkedHashSet<EClassifier>();
        for (EPackage pak : availableEPackages) {
            EClassifier found = null;
            if (this.typeName != null && this.typeName.contains(SEPARATOR)) {
                if (pak.getName() != null && this.typeName.startsWith(String.valueOf(pak.getName()) + SEPARATOR)) {
                    String eClassName = this.typeName.substring(this.typeName.indexOf(SEPARATOR) + 1);
                    found = pak.getEClassifier(eClassName);
                }
            } else {
                found = pak.getEClassifier(this.typeName);
            }
            if (found == null) continue;
            matches.add(found);
        }
        return matches;
    }

    public String toString() {
        return this.typeName;
    }

    public static TypeName fromString(String typeName) {
        TypeName result = ANY_TYPENAME;
        if (!StringUtil.isEmpty(typeName)) {
            String normalized = typeName.replace("::", SEPARATOR).trim();
            result = "ecore.EJavaObject".equals(normalized) || "EJavaObject".equals(normalized) ? ANY_TYPENAME : ("ecore.EObject".equals(normalized) || "EObject".equals(normalized) ? EOBJECT_TYPENAME : new TypeName(normalized));
        }
        return result;
    }

    public static TypeName fromEClassifier(EClassifier type) {
        TypeName result = null;
        result = type == EcorePackage.Literals.EJAVA_OBJECT ? ANY_TYPENAME : (type == EcorePackage.Literals.EOBJECT ? EOBJECT_TYPENAME : (type.getEPackage() != null && !StringUtil.isEmpty(type.getEPackage().getName()) ? new TypeName(String.valueOf(type.getEPackage().getName()) + SEPARATOR + type.getName()) : new TypeName(type.getName())));
        return result;
    }

    public static TypeName fromJavaClass(Class<?> type) {
        TypeName result = new TypeName(type);
        return result;
    }

    public Option<Class<?>> getJavaClass() {
        return Options.fromNullable(this.javaType);
    }

    public String getClassifierName() {
        int indexOfSeparator = this.typeName.indexOf(SEPARATOR);
        if (indexOfSeparator != -1) {
            return this.typeName.substring(indexOfSeparator + 1);
        }
        return this.typeName;
    }

    public Option<String> getPackagePrefix() {
        int indexOfSeparator = this.typeName.indexOf(SEPARATOR);
        if (indexOfSeparator != -1) {
            return Options.newSome((Object)this.typeName.substring(0, indexOfSeparator));
        }
        return Options.newNone();
    }
}

