/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.session.factory;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sirius.ui.business.api.session.factory.UISessionFactory;
import org.eclipse.sirius.ui.business.internal.session.factory.DefaultUISessionFactoryImpl;
import org.eclipse.sirius.ui.business.internal.session.factory.UISessionFactoryDescriptor;
import org.eclipse.sirius.ui.business.internal.session.factory.UISessionFactoryDescriptorRegistry;

public final class UISessionFactoryService {
    public static final UISessionFactoryService INSTANCE = new UISessionFactoryService();

    public UISessionFactory getUISessionFactory() {
        UISessionFactoryDescriptor uiSessionFactoryDescriptor;
        UISessionFactory result = null;
        List<UISessionFactoryDescriptor> uiSessionFactoryDescriptors = UISessionFactoryDescriptorRegistry.getRegisteredExtensions();
        if (!uiSessionFactoryDescriptors.isEmpty() && (uiSessionFactoryDescriptor = this.getFirstMostOverrider(uiSessionFactoryDescriptors)) != null) {
            result = uiSessionFactoryDescriptor.getUISessionFactory();
        }
        if (result == null) {
            result = new DefaultUISessionFactoryImpl();
        }
        return result;
    }

    private UISessionFactoryDescriptor getFirstMostOverrider(List<UISessionFactoryDescriptor> uiSessionFactoryDescriptors) {
        ArrayList<String> overriddenUISessionFactorIDs = new ArrayList<String>();
        UISessionFactoryDescriptor firstMostOverridingUISessionFactoryDescriptor2 = null;
        for (UISessionFactoryDescriptor firstMostOverridingUISessionFactoryDescriptor2 : uiSessionFactoryDescriptors) {
            String overrideValue = firstMostOverridingUISessionFactoryDescriptor2.getOverrideValue();
            if (overrideValue == null) continue;
            overriddenUISessionFactorIDs.add(overrideValue);
        }
        for (UISessionFactoryDescriptor firstMostOverridingUISessionFactoryDescriptor2 : uiSessionFactoryDescriptors) {
            if (overriddenUISessionFactorIDs.contains(firstMostOverridingUISessionFactoryDescriptor2.getId())) continue;
            return firstMostOverridingUISessionFactoryDescriptor2;
        }
        return firstMostOverridingUISessionFactoryDescriptor2;
    }
}

