/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import java.util.Collection;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.ModifiedFileSender;
import org.eclipse.team.internal.ccvs.core.client.PruneFolderVisitor;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;

public class Commit
extends Command {
    public static final Command.LocalOption FORCE = new Command.LocalOption("-f");

    protected Commit() {
    }

    @Override
    protected String getRequestId() {
        return "ci";
    }

    @Override
    protected ICVSResource[] sendLocalResourceState(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, ICVSResource[] resources, IProgressMonitor monitor) throws CVSException {
        this.checkResourcesManaged(session, resources);
        ModifiedFileSender visitor = new ModifiedFileSender(session, localOptions);
        visitor.visit(session, resources, monitor);
        ICVSResource[] changedFiles = visitor.getModifiedFiles();
        int i = 0;
        while (i < changedFiles.length) {
            String fileName = changedFiles[i].getRelativePath(session.getLocalRoot());
            if (fileName.startsWith("-")) {
                fileName = "./" + fileName;
            }
            session.sendArgument(fileName);
            ++i;
        }
        return changedFiles;
    }

    @Override
    protected IStatus commandFinished(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, ICVSResource[] resources, IProgressMonitor monitor, IStatus status) throws CVSException {
        if (status.getCode() == -10) {
            return status;
        }
        if (CVSProviderPlugin.getPlugin().getPruneEmptyDirectories()) {
            new PruneFolderVisitor().visit(session, resources);
        }
        if (status.isOK()) {
            int i = 0;
            while (i < resources.length) {
                ICVSFile cvsFile;
                ICVSResource resource = resources[i];
                if (!resource.isFolder() && (cvsFile = (ICVSFile)resources[i]).exists() && cvsFile.isModified(null)) {
                    status = this.mergeStatus(status, this.clearModifiedState(cvsFile));
                }
                ++i;
            }
        }
        return status;
    }

    protected IStatus clearModifiedState(ICVSFile cvsFile) throws CVSException {
        byte[] info = cvsFile.getSyncBytes();
        IResource resource = cvsFile.getIResource();
        String filePath = resource == null ? cvsFile.getRepositoryRelativePath() : resource.getFullPath().toString();
        if (info == null) {
            return new Status(2, "org.eclipse.team.cvs.core", 0, NLS.bind((String)CVSMessages.Commit_syncInfoMissing, (Object[])new String[]{filePath}), null);
        }
        cvsFile.checkedIn(null, true);
        return new Status(1, "org.eclipse.team.cvs.core", 0, NLS.bind((String)CVSMessages.Commit_timestampReset, (Object[])new String[]{filePath}), null);
    }

    @Override
    protected void sendArguments(Session session, String[] arguments) throws CVSException {
    }

    public final IStatus execute(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, ICVSResource[] arguments, Collection filesToCommitAsText, ICommandOutputListener listener, IProgressMonitor pm) throws CVSException {
        session.setTextTransferOverride(filesToCommitAsText);
        try {
            IStatus iStatus = super.execute(session, globalOptions, localOptions, arguments, listener, pm);
            return iStatus;
        }
        finally {
            session.setTextTransferOverride(null);
        }
    }

    @Override
    protected String getDisplayText() {
        return "commit";
    }
}

