/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.viewers;

import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTableEntryAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.viewers.ILamiViewer;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.viewers.LamiTableContentProvider;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.views.LamiReportViewTabPage;
import org.eclipse.tracecompass.internal.provisional.tmf.chart.core.signal.ChartSelectionUpdateSignal;
import org.eclipse.tracecompass.internal.tmf.ui.commands.ExportToTsvUtils;
import org.eclipse.tracecompass.tmf.chart.core.model.IDataChartProvider;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.ui.viewers.table.TmfSimpleTableViewer;

public final class LamiTableViewer
extends TmfSimpleTableViewer
implements ILamiViewer {
    private final LamiReportViewTabPage fPage;
    private Set<Object> fSelection;

    public LamiTableViewer(TableViewer tableViewer, LamiReportViewTabPage page) {
        super(tableViewer);
        tableViewer.getTable().moveAbove(null);
        this.fPage = page;
        this.fSelection = new HashSet<Object>();
        this.getTableViewer().setContentProvider((IContentProvider)new LamiTableContentProvider());
        this.getTableViewer().getTable().addSelectionListener((SelectionListener)new LamiTableSelectionListener());
        this.createColumns();
        this.fillData();
    }

    public static LamiTableViewer createLamiTable(Composite parent, LamiReportViewTabPage page) {
        TableViewer tableViewer = new TableViewer(parent, 0x10010002);
        return new LamiTableViewer(tableViewer, page);
    }

    private void createColumns() {
        final List aspects = this.fPage.getResultTable().getTableClass().getAspects();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (LamiTableEntryAspect aspect : aspects) {
                    LamiTableViewer.this.createColumn(aspect.getLabel(), new LamiTableColumnLabelProvider(aspect), aspect.getComparator());
                }
            }
        });
    }

    private void fillData() {
        TableViewer tableViewer = this.getTableViewer();
        Display.getDefault().asyncExec(() -> {
            if (tableViewer.getTable().isDisposed()) {
                return;
            }
            tableViewer.getTable().setTopIndex(0);
            tableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            tableViewer.setInput((Object)this.fPage.getResultTable().getEntries());
            LamiTableContentProvider latencyContentProvider = (LamiTableContentProvider)this.getTableViewer().getContentProvider();
            tableViewer.setItemCount(latencyContentProvider.getNbEntries());
            TableColumn[] cols = tableViewer.getTable().getColumns();
            int i = 0;
            while (i < cols.length) {
                LamiTableEntryAspect colAspect = (LamiTableEntryAspect)this.fPage.getResultTable().getTableClass().getAspects().get(i);
                int alignment = colAspect.isContinuous() ? 131072 : 16384;
                cols[i].setAlignment(alignment);
                ++i;
            }
            if (!this.fSelection.isEmpty()) {
                LamiTableContentProvider provider = (LamiTableContentProvider)this.getTableViewer().getContentProvider();
                int[] selectionsIndexes = this.fSelection.stream().map(obj -> (LamiTableEntry)obj).mapToInt(entry -> provider.getIndexOf((LamiTableEntry)NonNullUtils.checkNotNull((Object)entry))).toArray();
                Display.getDefault().asyncExec(() -> {
                    this.getTableViewer().getTable().setSelection(selectionsIndexes);
                    this.getTableViewer().getTable().redraw();
                });
            }
        });
        Display.getDefault().asyncExec(() -> {
            if (tableViewer.getTable().isDisposed()) {
                return;
            }
            TableColumn[] cols = tableViewer.getTable().getColumns();
            int i = 0;
            while (i < cols.length) {
                cols[i].pack();
                ++i;
            }
        });
    }

    public void exportToTsv(@Nullable OutputStream stream) {
        TableViewer tableViewer = this.getTableViewer();
        if (tableViewer == null) {
            return;
        }
        Table table = tableViewer.getTable();
        ExportToTsvUtils.exportTableToTsv((Table)table, (OutputStream)stream);
    }

    @TmfSignalHandler
    public void updateCustomSelection(ChartSelectionUpdateSignal signal) {
        if (signal.getSource() == this) {
            return;
        }
        if (this.fPage.getResultTable().hashCode() != signal.getDataProvider().hashCode()) {
            return;
        }
        this.fSelection = signal.getSelectedObject();
        LamiTableContentProvider tableContentProvider = (LamiTableContentProvider)this.getTableViewer().getContentProvider();
        int[] tableSelection = this.fSelection.stream().map(obj -> (LamiTableEntry)obj).mapToInt(entry -> tableContentProvider.getIndexOf((LamiTableEntry)NonNullUtils.checkNotNull((Object)entry))).toArray();
        Display.getDefault().asyncExec(() -> {
            this.getTableViewer().getTable().setSelection(tableSelection);
            this.getTableViewer().getTable().redraw();
        });
    }

    private static class LamiTableColumnLabelProvider
    extends ColumnLabelProvider {
        private final LamiTableEntryAspect fColumnAspect;

        public LamiTableColumnLabelProvider(LamiTableEntryAspect aspect) {
            this.fColumnAspect = aspect;
        }

        public String getText(@Nullable Object input) {
            if (!(input instanceof LamiTableEntry)) {
                return "";
            }
            return NonNullUtils.nullToEmptyString((Object)this.fColumnAspect.resolveString((LamiTableEntry)input));
        }
    }

    private class LamiTableSelectionListener
    extends SelectionAdapter {
        private LamiTableSelectionListener() {
        }

        public void widgetSelected(@Nullable SelectionEvent event) {
            IStructuredSelection selections = LamiTableViewer.this.getTableViewer().getStructuredSelection();
            HashSet<Object> selectionSet = new HashSet<Object>();
            Object[] objectArray = selections.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedEntry = objectArray[n2];
                selectionSet.add(NonNullUtils.checkNotNull((Object)selectedEntry));
                ++n2;
            }
            LamiTableViewer.this.fSelection = selectionSet;
            ChartSelectionUpdateSignal customSignal = new ChartSelectionUpdateSignal((Object)LamiTableViewer.this, (IDataChartProvider)LamiTableViewer.this.fPage.getResultTable(), selectionSet);
            TmfSignalManager.dispatchSignal((TmfSignal)customSignal);
        }
    }
}

