/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tid;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.Activator;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

class ActiveTidStateProvider
extends AbstractTmfStateProvider {
    private static final @NonNull String PROVIDER_ID = "activeTidAnalysis.provider";
    private static final int VERSION = 0;
    private final Map<Integer, Integer> fCpuNumToQuark = new TreeMap<Integer, Integer>();
    private final @NonNull String fSchedSwitch;
    private final @NonNull String fNextTid;
    private final @NonNull IKernelAnalysisEventLayout fLayout;

    public ActiveTidStateProvider(@NonNull ITmfTrace trace, @NonNull IKernelAnalysisEventLayout layout) {
        super(trace, PROVIDER_ID);
        this.fSchedSwitch = layout.eventSchedSwitch();
        this.fNextTid = layout.fieldNextTid();
        this.fLayout = layout;
    }

    public int getVersion() {
        return 0;
    }

    public @NonNull ITmfStateProvider getNewInstance() {
        return new ActiveTidStateProvider(this.getTrace(), this.fLayout);
    }

    protected void eventHandle(@NonNull ITmfEvent event) {
        if (!event.getName().equals(this.fSchedSwitch)) {
            return;
        }
        ITmfStateSystemBuilder ssb = this.getStateSystemBuilder();
        if (ssb == null) {
            return;
        }
        Integer cpu = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
        if (cpu == null) {
            return;
        }
        Integer cpuQuark = this.fCpuNumToQuark.get(cpu);
        if (cpuQuark == null) {
            String cpuAttributeName = NonNullUtils.nullToEmptyString((Object)cpu);
            cpuQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{cpuAttributeName});
            this.fCpuNumToQuark.put(cpu, cpuQuark);
        }
        try {
            int nextTid = ((Long)event.getContent().getField(new String[]{this.fNextTid}).getValue()).intValue();
            ssb.modifyAttribute(event.getTimestamp().toNanos(), (Object)nextTid, cpuQuark.intValue());
        }
        catch (StateValueTypeException e) {
            Activator.getDefault().logError(NonNullUtils.nullToEmptyString((Object)e.getMessage()), e);
        }
    }
}

