/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.filter.xml;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.tracecompass.common.core.xml.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfEventFieldAspect;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterAndNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterAspectNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterCompareNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterContainsNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterEqualsNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterMatchesNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterOrNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterTraceTypeNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterTreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TmfFilterXMLWriter {
    private Document document = null;

    public TmfFilterXMLWriter(ITmfFilterTreeNode root) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.document = documentBuilder.newDocument();
        Element rootElement = this.document.createElement(root.getNodeName());
        this.document.appendChild(rootElement);
        ITmfFilterTreeNode[] iTmfFilterTreeNodeArray = root.getChildren();
        int n = iTmfFilterTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfFilterTreeNode node = iTmfFilterTreeNodeArray[n2];
            TmfFilterXMLWriter.buildXMLTree(this.document, node, rootElement);
            ++n2;
        }
    }

    public static void buildXMLTree(Document document, ITmfFilterTreeNode treenode, Element parentElement) {
        TmfFilterTreeNode node;
        Element element = document.createElement(treenode.getNodeName());
        if (treenode instanceof TmfFilterNode) {
            node = (TmfFilterNode)treenode;
            element.setAttribute("name", ((TmfFilterNode)node).getFilterName());
        } else if (treenode instanceof TmfFilterTraceTypeNode) {
            node = (TmfFilterTraceTypeNode)treenode;
            element.setAttribute("type", ((TmfFilterTraceTypeNode)node).getTraceTypeId());
            element.setAttribute("name", ((TmfFilterTraceTypeNode)node).getName());
        } else if (treenode instanceof TmfFilterAndNode) {
            node = (TmfFilterAndNode)treenode;
            element.setAttribute("not", Boolean.toString(((TmfFilterAndNode)node).isNot()));
        } else if (treenode instanceof TmfFilterOrNode) {
            node = (TmfFilterOrNode)treenode;
            element.setAttribute("not", Boolean.toString(((TmfFilterOrNode)node).isNot()));
        } else if (treenode instanceof TmfFilterContainsNode) {
            node = (TmfFilterContainsNode)treenode;
            element.setAttribute("not", Boolean.toString(((TmfFilterContainsNode)node).isNot()));
            TmfFilterXMLWriter.setAspectAttributes(element, (TmfFilterAspectNode)node);
            element.setAttribute("value", ((TmfFilterContainsNode)node).getValue());
            element.setAttribute("ignorecase", Boolean.toString(((TmfFilterContainsNode)node).isIgnoreCase()));
        } else if (treenode instanceof TmfFilterEqualsNode) {
            node = (TmfFilterEqualsNode)treenode;
            element.setAttribute("not", Boolean.toString(((TmfFilterEqualsNode)node).isNot()));
            TmfFilterXMLWriter.setAspectAttributes(element, (TmfFilterAspectNode)node);
            element.setAttribute("value", ((TmfFilterEqualsNode)node).getValue());
            element.setAttribute("ignorecase", Boolean.toString(((TmfFilterEqualsNode)node).isIgnoreCase()));
        } else if (treenode instanceof TmfFilterMatchesNode) {
            node = (TmfFilterMatchesNode)treenode;
            element.setAttribute("not", Boolean.toString(((TmfFilterMatchesNode)node).isNot()));
            TmfFilterXMLWriter.setAspectAttributes(element, (TmfFilterAspectNode)node);
            element.setAttribute("regex", ((TmfFilterMatchesNode)node).getRegex());
        } else if (treenode instanceof TmfFilterCompareNode) {
            node = (TmfFilterCompareNode)treenode;
            element.setAttribute("not", Boolean.toString(((TmfFilterCompareNode)node).isNot()));
            TmfFilterXMLWriter.setAspectAttributes(element, (TmfFilterAspectNode)node);
            element.setAttribute("result", Integer.toString(((TmfFilterCompareNode)node).getResult()));
            element.setAttribute("type", ((TmfFilterCompareNode)node).getType().toString());
            element.setAttribute("value", ((TmfFilterCompareNode)node).getValue());
        }
        parentElement.appendChild(element);
        int i = 0;
        while (i < treenode.getChildrenCount()) {
            TmfFilterXMLWriter.buildXMLTree(document, treenode.getChild(i), element);
            ++i;
        }
    }

    private static void setAspectAttributes(Element element, TmfFilterAspectNode node) {
        if (node.getEventAspect() != null) {
            TmfEventFieldAspect aspect;
            element.setAttribute("eventaspect", node.getEventAspect().getName());
            element.setAttribute("tracetypeid", node.getTraceTypeId());
            if (node.getEventAspect() instanceof TmfEventFieldAspect && (aspect = (TmfEventFieldAspect)node.getEventAspect()).getFieldPath() != null) {
                element.setAttribute("field", aspect.getFieldPath());
            }
        }
    }

    public void saveTree(String uri) {
        try {
            Transformer transformer = XmlUtils.newSecureTransformer();
            DOMSource source = new DOMSource(this.document);
            StreamResult result = new StreamResult(new File(uri));
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            Activator.logError("Error to transformer the configuration ", e);
        }
        catch (TransformerException e) {
            Activator.logError("Got transformer exception ", e);
        }
    }
}

