/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.contentassist;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.common.types.xtext.ui.ITypesProposalProvider;
import org.eclipse.xtext.common.types.xtext.ui.TypeMatchFilters;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.QualifiedNameValueConverter;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.ui.editor.contentassist.AbstractJavaBasedContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalFactory;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.ui.editor.contentassist.RepeatedContentAssistProcessor;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBasicForLoopExpression;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.conversion.XbaseQualifiedNameValueConverter;
import org.eclipse.xtext.xbase.imports.RewritableImportSection;
import org.eclipse.xtext.xbase.scoping.SyntaxFilteredScopes;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.scoping.batch.StaticExtensionFeatureDescriptionWithImplicitFirstArgument;
import org.eclipse.xtext.xbase.scoping.batch.StaticFeatureDescription;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IExpressionScope;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReferenceFactory;
import org.eclipse.xtext.xbase.ui.contentassist.AbstractXbaseProposalProvider;
import org.eclipse.xtext.xbase.ui.contentassist.ImportingTypesProposalProvider;
import org.eclipse.xtext.xbase.ui.contentassist.MultiNameDescription;
import org.eclipse.xtext.xbase.ui.contentassist.ParameterContextInformation;
import org.eclipse.xtext.xbase.ui.contentassist.ParameterData;
import org.eclipse.xtext.xbase.ui.contentassist.StaticQualifierPrefixMatcher;
import org.eclipse.xtext.xbase.ui.contentassist.XbaseReferenceProposalCreator;
import org.eclipse.xtext.xbase.ui.imports.ReplaceConverter;
import org.eclipse.xtext.xtype.XtypePackage;

public class XbaseProposalProvider
extends AbstractXbaseProposalProvider
implements RepeatedContentAssistProcessor.ModeAware {
    private static final Logger log = Logger.getLogger(XbaseProposalProvider.class);
    public static final String DESCRIPTION_KEY = "xbase.description";
    @Inject
    private ITypesProposalProvider typeProposalProvider;
    @Inject
    private ValidFeatureDescription featureDescriptionPredicate;
    @Inject
    private XbaseQualifiedNameValueConverter qualifiedNameValueConverter;
    @Inject
    private StaticQualifierPrefixMatcher staticQualifierPrefixMatcher;
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    private SyntaxFilteredScopes syntaxFilteredScopes;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private RewritableImportSection.Factory importSectionFactory;
    @Inject
    private ReplaceConverter replaceConverter;

    public String getNextCategory() {
        return this.getXbaseCrossReferenceProposalCreator().getNextCategory();
    }

    public void nextMode() {
        this.getXbaseCrossReferenceProposalCreator().nextMode();
    }

    public void reset() {
        this.getXbaseCrossReferenceProposalCreator().reset();
    }

    public boolean isLastMode() {
        return this.getXbaseCrossReferenceProposalCreator().isLastMode();
    }

    public XbaseReferenceProposalCreator getXbaseCrossReferenceProposalCreator() {
        return (XbaseReferenceProposalCreator)super.getCrossReferenceProposalCreator();
    }

    @Override
    public void completeXImportDeclaration_ImportedType(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeJavaTypes(context, XtypePackage.Literals.XIMPORT_DECLARATION__IMPORTED_TYPE, true, (IValueConverter<String>)this.getQualifiedNameValueConverter(), this.createVisibilityFilter(context, 0), acceptor);
    }

    @Override
    public void completeJvmParameterizedTypeReference_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (this.getXbaseCrossReferenceProposalCreator().isShowTypeProposals() || this.getXbaseCrossReferenceProposalCreator().isShowSmartProposals()) {
            this.completeJavaTypes(context, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, acceptor);
        }
    }

    @Override
    public void completeXConstructorCall_Constructor(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeJavaTypes(context, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, true, (IValueConverter<String>)this.qualifiedNameValueConverter, TypeMatchFilters.and((ITypesProposalProvider.Filter[])new ITypesProposalProvider.Filter[]{TypeMatchFilters.canInstantiate(), this.createVisibilityFilter(context)}), acceptor);
    }

    @Override
    public void completeXRelationalExpression_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeJavaTypes(context, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, acceptor);
    }

    protected void completeJavaTypes(ContentAssistContext context, EReference reference, ICompletionProposalAcceptor acceptor) {
        this.completeJavaTypes(context, reference, (IValueConverter<String>)this.qualifiedNameValueConverter, this.createVisibilityFilter(context), acceptor);
    }

    protected void completeJavaTypes(ContentAssistContext context, EReference reference, ITypesProposalProvider.Filter filter, ICompletionProposalAcceptor acceptor) {
        this.completeJavaTypes(context, reference, (IValueConverter<String>)this.qualifiedNameValueConverter, filter, acceptor);
    }

    protected void completeJavaTypes(ContentAssistContext context, EReference reference, IValueConverter<String> valueConverter, ITypesProposalProvider.Filter filter, ICompletionProposalAcceptor acceptor) {
        this.completeJavaTypes(context, reference, false, valueConverter, filter, acceptor);
    }

    protected void completeJavaTypes(ContentAssistContext context, EReference reference, boolean forced, IValueConverter<String> valueConverter, ITypesProposalProvider.Filter filter, ICompletionProposalAcceptor acceptor) {
        String prefix = context.getPrefix();
        if (prefix.length() > 0) {
            if (Character.isJavaIdentifierStart(context.getPrefix().charAt(0))) {
                if (!(forced || !this.getXbaseCrossReferenceProposalCreator().isShowSmartProposals() || prefix.contains(".") || prefix.contains("::") || Character.isUpperCase(prefix.charAt(0)))) {
                    return;
                }
                this.typeProposalProvider.createTypeProposals((ICompletionProposalFactory)this, context, reference, filter, valueConverter, acceptor);
            }
        } else if (forced || !this.getXbaseCrossReferenceProposalCreator().isShowSmartProposals()) {
            String text;
            char lastChar;
            INode lastCompleteNode = context.getLastCompleteNode();
            if (lastCompleteNode instanceof ILeafNode && !((ILeafNode)lastCompleteNode).isHidden() && lastCompleteNode.getLength() > 0 && lastCompleteNode.getTotalEndOffset() == context.getOffset() && Character.isJavaIdentifierPart(lastChar = (text = lastCompleteNode.getText()).charAt(text.length() - 1))) {
                return;
            }
            this.typeProposalProvider.createTypeProposals((ICompletionProposalFactory)this, context, reference, filter, valueConverter, acceptor);
        }
    }

    @Override
    public void completeXTypeLiteral_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeJavaTypes(context, XbasePackage.Literals.XTYPE_LITERAL__TYPE, true, (IValueConverter<String>)this.qualifiedNameValueConverter, this.createVisibilityFilter(context), acceptor);
    }

    public void proposeDeclaringTypeForStaticInvocation(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (this.getXbaseCrossReferenceProposalCreator().isShowTypeProposals() || this.getXbaseCrossReferenceProposalCreator().isShowSmartProposals()) {
            ContentAssistContext modifiedContext = context.copy().setMatcher((PrefixMatcher)this.staticQualifierPrefixMatcher).toContext();
            this.completeJavaTypes(modifiedContext, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, (IValueConverter<String>)this.qualifiedNameValueConverter, this.createVisibilityFilter(context), acceptor);
        }
    }

    protected ITypesProposalProvider.Filter createVisibilityFilter(ContentAssistContext context) {
        return this.createVisibilityFilter(context, 0);
    }

    protected ITypesProposalProvider.Filter createVisibilityFilter(ContentAssistContext context, int searchFor) {
        return TypeMatchFilters.and((ITypesProposalProvider.Filter[])new ITypesProposalProvider.Filter[]{TypeMatchFilters.isNotInternal((int)searchFor), TypeMatchFilters.isAcceptableByPreference()});
    }

    public void completeKeyword(Keyword keyword, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        if (this.isKeywordWorthyToPropose(keyword, contentAssistContext)) {
            super.completeKeyword(keyword, contentAssistContext, acceptor);
        }
    }

    protected boolean isKeywordWorthyToPropose(Keyword keyword, ContentAssistContext context) {
        if (this.isKeywordWorthyToPropose(keyword)) {
            EObject previousModel;
            if (("as".equals(keyword.getValue()) || "instanceof".equals(keyword.getValue())) && (previousModel = context.getPreviousModel()) instanceof XExpression) {
                if (context.getPrefix().length() == 0 && NodeModelUtils.getNode((EObject)previousModel).getEndOffset() > context.getOffset()) {
                    return false;
                }
                LightweightTypeReference type = this.typeResolver.resolveTypes(previousModel).getActualType((XExpression)previousModel);
                if (type == null || type.isPrimitiveVoid()) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected boolean isKeywordWorthyToPropose(Keyword keyword) {
        return keyword.getValue().length() > 1 && Character.isLetter(keyword.getValue().charAt(0));
    }

    protected void lookupCrossReference(CrossReference crossReference, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        this.lookupCrossReference(crossReference, contentAssistContext, acceptor, this.getFeatureDescriptionPredicate(contentAssistContext));
    }

    @Override
    public void completeXFeatureCall_Feature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ICompositeNode node;
        int endOffset;
        if (model != null && this.typeResolver.resolveTypes(model).hasExpressionScope(model, IExpressionScope.Anchor.WITHIN)) {
            return;
        }
        if (model instanceof XMemberFeatureCall && this.isInMemberFeatureCall(model, endOffset = (node = NodeModelUtils.getNode((EObject)model)).getEndOffset(), context)) {
            return;
        }
        this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.AFTER, context, acceptor);
    }

    @Override
    public void completeXForLoopExpression_EachExpression(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.WITHIN, context, acceptor);
    }

    @Override
    public void completeXForLoopExpression_ForExpression(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.BEFORE, context, acceptor);
    }

    @Override
    public void completeXSwitchExpression_Default(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.WITHIN, context, acceptor);
    }

    @Override
    public void completeXCasePart_Then(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.AFTER, context, acceptor);
    }

    @Override
    public void completeXCasePart_Case(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.WITHIN, context, acceptor);
    }

    public XbaseReferenceProposalCreator getCrossReferenceProposalCreator() {
        return (XbaseReferenceProposalCreator)super.getCrossReferenceProposalCreator();
    }

    @Override
    public void completeXBlockExpression_Expressions(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeWithinBlock(model, context, acceptor);
    }

    protected void completeWithinBlock(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        int endOffset;
        EList children;
        ICompositeNode node = NodeModelUtils.getNode((EObject)model);
        if (node.getOffset() >= context.getOffset()) {
            this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.BEFORE, context, acceptor);
            return;
        }
        if (model instanceof XBlockExpression && !(children = ((XBlockExpression)model).getExpressions()).isEmpty()) {
            int i = children.size() - 1;
            while (i >= 0) {
                XExpression child = (XExpression)children.get(i);
                ICompositeNode childNode = NodeModelUtils.getNode((EObject)child);
                if (childNode.getEndOffset() <= context.getOffset()) {
                    this.createLocalVariableAndImplicitProposals((EObject)child, IExpressionScope.Anchor.AFTER, context, acceptor);
                    return;
                }
                --i;
            }
        }
        if ((endOffset = node.getEndOffset()) <= context.getOffset()) {
            if (model instanceof XFeatureCall && model.eContainer() instanceof XClosure || endOffset == context.getOffset() && context.getPrefix().length() == 0) {
                return;
            }
            if (this.isInMemberFeatureCall(model, endOffset, context)) {
                return;
            }
            this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.AFTER, context, acceptor);
            return;
        }
        if (this.isInMemberFeatureCall(model, endOffset, context)) {
            return;
        }
        if (model instanceof XClosure) {
            return;
        }
        this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.BEFORE, context, acceptor);
    }

    protected boolean isInMemberFeatureCall(EObject model, int endOffset, ContentAssistContext context) {
        INode featureNode;
        List featureNodes;
        return model instanceof XMemberFeatureCall && endOffset >= context.getOffset() && !(featureNodes = NodeModelUtils.findNodesForFeature((EObject)model, (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE)).isEmpty() && (featureNode = (INode)featureNodes.get(0)).getTotalOffset() < context.getOffset() && featureNode.getTotalEndOffset() >= context.getOffset();
    }

    @Override
    public void completeXExpressionInClosure_Expressions(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeWithinBlock(model, context, acceptor);
    }

    @Override
    public void completeXAssignment_Feature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String ruleName = this.getConcreteSyntaxRuleName(assignment);
        if (this.isOperatorRule(ruleName)) {
            this.completeBinaryOperationFeature(model, assignment, context, acceptor);
        }
    }

    protected boolean isOperatorRule(String ruleName) {
        return ruleName != null && ruleName.startsWith("Op");
    }

    @Override
    public void completeXOrExpression_Feature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeBinaryOperationFeature(model, assignment, context, acceptor);
    }

    @Override
    public void completeXAndExpression_Feature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeBinaryOperationFeature(model, assignment, context, acceptor);
    }

    @Override
    public void completeXEqualityExpression_Feature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeBinaryOperationFeature(model, assignment, context, acceptor);
    }

    @Override
    public void completeXRelationalExpression_Feature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeBinaryOperationFeature(model, assignment, context, acceptor);
    }

    @Override
    public void completeXOtherOperatorExpression_Feature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeBinaryOperationFeature(model, assignment, context, acceptor);
    }

    @Override
    public void completeXAdditiveExpression_Feature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeBinaryOperationFeature(model, assignment, context, acceptor);
    }

    @Override
    public void completeXMultiplicativeExpression_Feature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeBinaryOperationFeature(model, assignment, context, acceptor);
    }

    @Override
    public void completeXUnaryOperation_Feature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    @Override
    public void completeXPostfixOperation_Feature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeBinaryOperationFeature(model, assignment, context, acceptor);
    }

    protected void completeBinaryOperationFeature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof XBinaryOperation) {
            if (context.getPrefix().length() == 0) {
                INode currentNode = context.getCurrentNode();
                int offset = currentNode.getOffset();
                int endOffset = currentNode.getEndOffset();
                if (offset < context.getOffset() && endOffset >= context.getOffset() && currentNode.getGrammarElement() instanceof CrossReference) {
                    return;
                }
            }
            if (NodeModelUtils.findActualNodeFor((EObject)model).getEndOffset() <= context.getOffset()) {
                this.createReceiverProposals((XExpression)model, (CrossReference)assignment.getTerminal(), context, acceptor);
            } else {
                this.createReceiverProposals(((XBinaryOperation)model).getLeftOperand(), (CrossReference)assignment.getTerminal(), context, acceptor);
            }
        } else {
            EObject previousModel = context.getPreviousModel();
            if (previousModel instanceof XExpression) {
                if (context.getPrefix().length() == 0 && NodeModelUtils.getNode((EObject)previousModel).getEndOffset() > context.getOffset()) {
                    return;
                }
                this.createReceiverProposals((XExpression)previousModel, (CrossReference)assignment.getTerminal(), context, acceptor);
            }
        }
    }

    @Override
    public void completeXCatchClause_Expression(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.WITHIN, context, acceptor);
    }

    @Override
    public void complete_XExpression(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EObject container = ruleCall.eContainer();
        if (container instanceof Group && "XParenthesizedExpression".equals(GrammarUtil.containingRule((EObject)ruleCall).getName())) {
            this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.WITHIN, context, acceptor);
        }
    }

    @Override
    public void completeXBasicForLoopExpression_InitExpressions(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EList children;
        ICompositeNode node = NodeModelUtils.getNode((EObject)model);
        if (node.getOffset() >= context.getOffset()) {
            this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.BEFORE, context, acceptor);
            return;
        }
        if (model instanceof XBasicForLoopExpression && !(children = ((XBasicForLoopExpression)model).getInitExpressions()).isEmpty()) {
            int i = children.size() - 1;
            while (i >= 0) {
                XExpression child = (XExpression)children.get(i);
                ICompositeNode childNode = NodeModelUtils.getNode((EObject)child);
                if (childNode.getEndOffset() <= context.getOffset()) {
                    this.createLocalVariableAndImplicitProposals((EObject)child, IExpressionScope.Anchor.AFTER, context, acceptor);
                    return;
                }
                --i;
            }
        }
        this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.BEFORE, context, acceptor);
    }

    @Override
    public void completeXBasicForLoopExpression_UpdateExpressions(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.WITHIN, context, acceptor);
    }

    @Override
    public void completeXBasicForLoopExpression_Expression(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.WITHIN, context, acceptor);
    }

    @Override
    public void completeXBasicForLoopExpression_EachExpression(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.WITHIN, context, acceptor);
    }

    @Override
    public void completeXClosure_Expression(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.WITHIN, context, acceptor);
    }

    @Override
    public void completeXShortClosure_Expression(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.WITHIN, context, acceptor);
    }

    @Override
    public void completeXMemberFeatureCall_Feature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof XMemberFeatureCall) {
            final XExpression memberCallTarget = ((XMemberFeatureCall)model).getMemberCallTarget();
            IResolvedTypes resolvedTypes = this.typeResolver.resolveTypes((EObject)memberCallTarget);
            final LightweightTypeReference memberCallTargetType = resolvedTypes.getActualType(memberCallTarget);
            Iterable<JvmFeature> featuresToImport = this.getFavoriteStaticFeatures(model, new Predicate<JvmFeature>(){

                public boolean apply(JvmFeature input) {
                    LightweightTypeReference lightweightTypeReference;
                    JvmFormalParameter firstParam;
                    JvmTypeReference parameterType;
                    EList parameters;
                    if (input instanceof JvmOperation && input.isStatic() && (parameters = ((JvmOperation)input).getParameters()).size() > 0 && (parameterType = (firstParam = (JvmFormalParameter)parameters.get(0)).getParameterType()) != null && (lightweightTypeReference = memberCallTargetType.getOwner().toLightweightTypeReference(parameterType)) != null) {
                        return memberCallTargetType.isAssignableFrom(lightweightTypeReference);
                    }
                    return false;
                }
            });
            Iterable scopedFeatures = Iterables.transform(featuresToImport, (Function)new Function<JvmFeature, IEObjectDescription>(){

                public IEObjectDescription apply(JvmFeature feature) {
                    QualifiedName qualifiedName = QualifiedName.create((String)feature.getSimpleName());
                    return new StaticExtensionFeatureDescriptionWithImplicitFirstArgument(qualifiedName, feature, memberCallTarget, memberCallTargetType, 0, true);
                }
            });
            SimpleScope staticMemberScope = new SimpleScope(IScope.NULLSCOPE, scopedFeatures);
            this.proposeFavoritStaticFeatures(model, context, acceptor, (IScope)staticMemberScope);
            this.createReceiverProposals(((XMemberFeatureCall)model).getMemberCallTarget(), (CrossReference)assignment.getTerminal(), context, acceptor);
        } else if (model instanceof XAssignment) {
            this.createReceiverProposals(((XAssignment)model).getAssignable(), (CrossReference)assignment.getTerminal(), context, acceptor);
        }
    }

    @Override
    public void completeXVariableDeclaration_Right(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.BEFORE, context, acceptor);
    }

    protected void createLocalVariableAndImplicitProposals(EObject context, IExpressionScope.Anchor anchor, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        String prefix = contentAssistContext.getPrefix();
        if (prefix.length() > 0 && !Character.isJavaIdentifierStart(prefix.charAt(0)) && prefix.length() > 1 && prefix.charAt(0) == '^' && !Character.isJavaIdentifierStart(prefix.charAt(1))) {
            return;
        }
        Function<IEObjectDescription, ICompletionProposal> proposalFactory = this.getProposalFactory(this.getFeatureCallRuleName(), contentAssistContext);
        IResolvedTypes resolvedTypes = context != null ? this.typeResolver.resolveTypes(context) : this.typeResolver.resolveTypes((Resource)contentAssistContext.getResource());
        IExpressionScope expressionScope = resolvedTypes.getExpressionScope(context, anchor);
        IScope scope = expressionScope.getFeatureScope();
        this.getCrossReferenceProposalCreator().lookupCrossReference(scope, context, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, acceptor, this.getFeatureDescriptionPredicate(contentAssistContext), proposalFactory);
        this.proposeDeclaringTypeForStaticInvocation(context, null, contentAssistContext, acceptor);
        if (!(context instanceof XMemberFeatureCall)) {
            Iterable<JvmFeature> featuresToImport = this.getFavoriteStaticFeatures(context, new Predicate<JvmFeature>(){

                public boolean apply(JvmFeature input) {
                    return true;
                }
            });
            Iterable scopedFeatures = Iterables.transform(featuresToImport, (Function)new Function<JvmFeature, IEObjectDescription>(){

                public IEObjectDescription apply(JvmFeature feature) {
                    QualifiedName qualifiedName = QualifiedName.create((String)feature.getSimpleName());
                    return new StaticFeatureDescription(qualifiedName, feature, 0, true);
                }
            });
            SimpleScope staticMemberScope = new SimpleScope(IScope.NULLSCOPE, scopedFeatures);
            this.proposeFavoritStaticFeatures(context, contentAssistContext, acceptor, (IScope)staticMemberScope);
        }
    }

    protected Iterable<JvmFeature> getFavoriteStaticFeatures(EObject context, Predicate<JvmFeature> filter) {
        String[] favourites;
        String pref = PreferenceConstants.getPreference((String)"content_assist_favorite_static_members", null);
        ArrayList result = Lists.newArrayList();
        if (Strings.isEmpty((String)pref)) {
            return result;
        }
        String[] stringArray = favourites = pref.split(";");
        int n = favourites.length;
        int n2 = 0;
        while (n2 < n) {
            String fav = stringArray[n2];
            final boolean isWildcard = fav.lastIndexOf("*") > 0;
            int indexOfLastDot = fav.lastIndexOf(".");
            if (indexOfLastDot > 0) {
                String typeName = fav.substring(0, indexOfLastDot);
                JvmType type = this.typeReferences.findDeclaredType(typeName, (Notifier)context);
                final String membername = fav.substring(indexOfLastDot + 1, fav.length());
                if (type != null && type instanceof JvmDeclaredType) {
                    JvmDeclaredType genericType = (JvmDeclaredType)type;
                    Iterable allFeaturesToImport = Iterables.filter((Iterable)Iterables.filter((Iterable)genericType.getMembers(), JvmFeature.class), (Predicate)new Predicate<JvmFeature>(){

                        public boolean apply(JvmFeature input) {
                            boolean isValid;
                            boolean bl = isValid = !(input instanceof JvmConstructor) && input.isStatic();
                            if (isWildcard) {
                                return isValid;
                            }
                            return isValid && input.getSimpleName().equals(membername);
                        }
                    });
                    Iterable featuresToImport = Iterables.filter((Iterable)allFeaturesToImport, filter);
                    if (context != null) {
                        final RewritableImportSection importSection = this.importSectionFactory.parse((XtextResource)context.eResource());
                        featuresToImport = Iterables.filter((Iterable)featuresToImport, (Predicate)new Predicate<JvmFeature>(){

                            public boolean apply(JvmFeature input) {
                                return !importSection.hasStaticImport(input.getSimpleName(), false);
                            }
                        });
                    }
                    result.addAll(Lists.newArrayList((Iterable)featuresToImport));
                }
            }
            ++n2;
        }
        return result;
    }

    protected void proposeFavoritStaticFeatures(EObject context, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor, IScope scopedFeatures) {
        final Function<IEObjectDescription, ICompletionProposal> proposalFactory = this.getProposalFactory(this.getFeatureCallRuleName(), contentAssistContext);
        ImportingTypesProposalProvider.FQNImporter textApplier = new ImportingTypesProposalProvider.FQNImporter((Resource)contentAssistContext.getResource(), contentAssistContext.getViewer(), scopedFeatures, this.qualifiedNameConverter, (IValueConverter<String>)this.qualifiedNameValueConverter, this.importSectionFactory, this.replaceConverter);
        Function<IEObjectDescription, ICompletionProposal> importAddingProposalFactory = new Function<IEObjectDescription, ICompletionProposal>((ConfigurableCompletionProposal.IReplacementTextApplier)textApplier){
            private final /* synthetic */ ConfigurableCompletionProposal.IReplacementTextApplier val$textApplier;
            {
                this.val$textApplier = iReplacementTextApplier;
            }

            public ICompletionProposal apply(IEObjectDescription input) {
                ICompletionProposal proposal = (ICompletionProposal)proposalFactory.apply((Object)input);
                if (proposal instanceof ConfigurableCompletionProposal) {
                    ConfigurableCompletionProposal castedProposal = (ConfigurableCompletionProposal)proposal;
                    ((ConfigurableCompletionProposal)proposal).setTextApplier(this.val$textApplier);
                    return castedProposal;
                }
                return proposal;
            }
        };
        this.getCrossReferenceProposalCreator().lookupCrossReference(scopedFeatures, context, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, acceptor, this.getFeatureDescriptionPredicate(contentAssistContext), importAddingProposalFactory);
    }

    protected String getFeatureCallRuleName() {
        return "IdOrSuper";
    }

    protected String getQualifiedNameRuleName() {
        return "QualifiedName";
    }

    protected void createLocalVariableAndImplicitProposals(EObject context, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        this.createLocalVariableAndImplicitProposals(context, IExpressionScope.Anchor.BEFORE, contentAssistContext, acceptor);
    }

    protected void createReceiverProposals(XExpression receiver, CrossReference crossReference, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        EObject currentModel;
        String ruleName = this.getConcreteSyntaxRuleName(crossReference);
        Function<IEObjectDescription, ICompletionProposal> proposalFactory = this.getProposalFactory(ruleName, contentAssistContext);
        IResolvedTypes resolvedTypes = this.typeResolver.resolveTypes((EObject)receiver);
        LightweightTypeReference receiverType = resolvedTypes.getActualType(receiver);
        if (receiverType == null || receiverType.isPrimitiveVoid()) {
            return;
        }
        IExpressionScope expressionScope = resolvedTypes.getExpressionScope((EObject)receiver, IExpressionScope.Anchor.RECEIVER);
        IScope scope = contentAssistContext.getCurrentModel() != receiver ? ((currentModel = contentAssistContext.getCurrentModel()) instanceof XMemberFeatureCall && ((XMemberFeatureCall)currentModel).getMemberCallTarget() == receiver ? this.filterByConcreteSyntax(expressionScope.getFeatureScope((XAbstractFeatureCall)currentModel), (AbstractElement)crossReference) : this.filterByConcreteSyntax(expressionScope.getFeatureScope(), (AbstractElement)crossReference)) : this.filterByConcreteSyntax(expressionScope.getFeatureScope(), (AbstractElement)crossReference);
        this.getCrossReferenceProposalCreator().lookupCrossReference(scope, (EObject)receiver, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, acceptor, this.getFeatureDescriptionPredicate(contentAssistContext), proposalFactory);
    }

    protected IScope filterByConcreteSyntax(IScope parent, AbstractElement syntax) {
        return this.syntaxFilteredScopes.create(parent, syntax);
    }

    protected String getConcreteSyntaxRuleName(Assignment assignment) {
        AbstractElement terminal = assignment.getTerminal();
        if (terminal instanceof CrossReference) {
            return this.getConcreteSyntaxRuleName((CrossReference)terminal);
        }
        String ruleName = null;
        if (terminal instanceof RuleCall) {
            ruleName = this.getConcreteSyntaxRuleName((RuleCall)terminal);
        }
        return ruleName;
    }

    protected String getConcreteSyntaxRuleName(RuleCall ruleCall) {
        String ruleName = ruleCall.getRule().getName();
        return ruleName;
    }

    protected String getConcreteSyntaxRuleName(CrossReference crossReference) {
        String ruleName = null;
        if (crossReference.getTerminal() instanceof RuleCall) {
            ruleName = this.getConcreteSyntaxRuleName((RuleCall)crossReference.getTerminal());
        }
        return ruleName;
    }

    protected boolean doNotProposeFeatureOfBinaryOperation(ContentAssistContext contentAssistContext, XBinaryOperation binaryOperation) {
        INode node;
        List nodesForFeature = NodeModelUtils.findNodesForFeature((EObject)binaryOperation, (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE);
        if (!nodesForFeature.isEmpty() && (node = (INode)nodesForFeature.get(0)).getOffset() < contentAssistContext.getOffset() - contentAssistContext.getPrefix().length()) {
            XExpression rightOperand = binaryOperation.getRightOperand();
            if (rightOperand == null) {
                return true;
            }
            ICompositeNode rightOperandNode = NodeModelUtils.findActualNodeFor((EObject)rightOperand);
            if (rightOperandNode != null) {
                if (rightOperandNode.getOffset() >= contentAssistContext.getOffset()) {
                    return true;
                }
                if (this.isParentOf((INode)rightOperandNode, contentAssistContext.getLastCompleteNode())) {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean isParentOf(INode node, INode child) {
        if (node != null) ** GOTO lbl4
        return false;
lbl-1000:
        // 1 sources

        {
            child = child.getParent();
lbl4:
            // 2 sources

            ** while (child != null && node.equals((Object)child))
        }
lbl5:
        // 1 sources

        return node.equals(child);
    }

    protected Function<IEObjectDescription, ICompletionProposal> getProposalFactory(String ruleName, ContentAssistContext contentAssistContext) {
        return new XbaseProposalCreator(contentAssistContext, ruleName, this.getQualifiedNameConverter());
    }

    protected ProposalBracketInfo getProposalBracketInfo(IEObjectDescription proposedDescription, ContentAssistContext contentAssistContext) {
        ProposalBracketInfo info = new ProposalBracketInfo();
        if (proposedDescription instanceof IIdentifiableElementDescription) {
            IIdentifiableElementDescription jvmFeatureDescription = (IIdentifiableElementDescription)proposedDescription;
            JvmIdentifiableElement jvmFeature = jvmFeatureDescription.getElementOrProxy();
            if (jvmFeature instanceof JvmExecutable) {
                EList parameters = ((JvmExecutable)jvmFeature).getParameters();
                if (jvmFeatureDescription.getNumberOfParameters() == 1) {
                    if (jvmFeature.getSimpleName().startsWith("set") && !proposedDescription.getName().getFirstSegment().startsWith("set")) {
                        info.brackets = " = value";
                        info.selectionOffset = -"value".length();
                        info.selectionLength = "value".length();
                        return info;
                    }
                    JvmTypeReference parameterType = ((JvmFormalParameter)parameters.get(parameters.size() - 1)).getParameterType();
                    LightweightTypeReference light = this.getTypeConverter(contentAssistContext.getResource()).toLightweightReference(parameterType);
                    if (light.isFunctionType()) {
                        int numParameters = light.getAsFunctionTypeReference().getParameterTypes().size();
                        if (numParameters == 1) {
                            info.brackets = "[]";
                            info.caretOffset = -1;
                            return info;
                        }
                        if (numParameters == 0) {
                            info.brackets = "[|]";
                            info.caretOffset = -1;
                            return info;
                        }
                        StringBuilder b = new StringBuilder();
                        int i = 0;
                        while (i < numParameters) {
                            if (i != 0) {
                                b.append(", ");
                            }
                            b.append("p" + (i + 1));
                            ++i;
                        }
                        info.brackets = "[" + b.toString() + "|]";
                        info.caretOffset = -1;
                        info.selectionOffset = -b.length() - 2;
                        info.selectionLength = b.length();
                        return info;
                    }
                }
            }
            if (this.isExplicitOperationCall(jvmFeatureDescription)) {
                info.brackets = "()";
                info.selectionOffset = -1;
            }
        }
        return info;
    }

    protected Predicate<IEObjectDescription> getFeatureDescriptionPredicate(ContentAssistContext contentAssistContext) {
        return this.featureDescriptionPredicate;
    }

    protected QualifiedNameValueConverter getQualifiedNameValueConverter() {
        return this.qualifiedNameValueConverter;
    }

    protected ITypesProposalProvider getTypesProposalProvider() {
        return this.typeProposalProvider;
    }

    protected boolean isIdRule(String ruleName) {
        return "IdOrSuper".equals(ruleName) || "ValidID".equals(ruleName) || "FeatureCallID".equals(ruleName);
    }

    public boolean isExplicitOperationCall(IIdentifiableElementDescription desc) {
        return desc.getNumberOfParameters() > 0;
    }

    protected static class ProposalBracketInfo {
        String brackets = "";
        int selectionOffset = 0;
        int selectionLength = 0;
        int caretOffset = 0;

        protected ProposalBracketInfo() {
        }
    }

    public static class ValidFeatureDescription
    implements Predicate<IEObjectDescription> {
        @Inject
        private OperatorMapping operatorMapping;

        public boolean apply(IEObjectDescription input) {
            if (input instanceof IIdentifiableElementDescription) {
                IIdentifiableElementDescription desc = (IIdentifiableElementDescription)input;
                if (!desc.isVisible() || !desc.isValidStaticState()) {
                    return false;
                }
                if (input.getName().getFirstSegment().startsWith("operator_")) {
                    return this.operatorMapping.getOperator(input.getName()) == null;
                }
                return true;
            }
            return true;
        }
    }

    protected class XbaseProposalCreator
    extends AbstractJavaBasedContentProposalProvider.DefaultProposalCreator {
        private ContentAssistContext contentAssistContext;
        private String ruleName;
        private Map<QualifiedName, ParameterData> simpleNameToParameterList;

        public XbaseProposalCreator(ContentAssistContext contentAssistContext, String ruleName, IQualifiedNameConverter qualifiedNameConverter) {
            super((AbstractJavaBasedContentProposalProvider)XbaseProposalProvider.this, contentAssistContext, ruleName, qualifiedNameConverter);
            this.simpleNameToParameterList = Maps.newHashMap();
            this.contentAssistContext = contentAssistContext;
            this.ruleName = ruleName;
        }

        public ICompletionProposal apply(final IEObjectDescription candidate) {
            IEObjectDescription myCandidate = candidate;
            ContentAssistContext myContentAssistContext = this.contentAssistContext;
            if (myCandidate instanceof MultiNameDescription) {
                final MultiNameDescription multiNamed = (MultiNameDescription)candidate;
                myCandidate = multiNamed.getDelegate();
                myContentAssistContext = myContentAssistContext.copy().setMatcher(new PrefixMatcher(){

                    public boolean isCandidateMatchingPrefix(String name, String prefix) {
                        PrefixMatcher delegateMatcher = XbaseProposalCreator.this.contentAssistContext.getMatcher();
                        if (delegateMatcher.isCandidateMatchingPrefix(name, prefix)) {
                            return true;
                        }
                        IQualifiedNameConverter converter = XbaseProposalProvider.this.getQualifiedNameConverter();
                        String unconvertedName = converter.toString(candidate.getName());
                        if (!unconvertedName.equals(name) && delegateMatcher.isCandidateMatchingPrefix(unconvertedName, prefix)) {
                            return true;
                        }
                        for (QualifiedName otherName : multiNamed.getOtherNames()) {
                            String convertedAlternative;
                            String alternative = converter.toString(otherName);
                            if (delegateMatcher.isCandidateMatchingPrefix(alternative, prefix)) {
                                return true;
                            }
                            String string = convertedAlternative = XbaseProposalCreator.this.valueConverter != null ? XbaseProposalCreator.this.valueConverter.toString((Object)alternative) : XbaseProposalProvider.this.getValueConverter().toString((Object)alternative, XbaseProposalCreator.this.ruleName);
                            if (convertedAlternative.equals(alternative) || !delegateMatcher.isCandidateMatchingPrefix(convertedAlternative, prefix)) continue;
                            return true;
                        }
                        return false;
                    }
                }).toContext();
            }
            if (myCandidate instanceof IIdentifiableElementDescription && XbaseProposalProvider.this.isIdRule(this.ruleName)) {
                ICompletionProposal result = null;
                String proposal = XbaseProposalProvider.this.getQualifiedNameConverter().toString(myCandidate.getName());
                if (this.valueConverter != null) {
                    try {
                        proposal = XbaseProposalProvider.this.getValueConverter().toString((Object)proposal, this.ruleName);
                    }
                    catch (ValueConverterException e) {
                        log.debug((Object)e.getMessage(), (Throwable)e);
                        return null;
                    }
                }
                if (this.ruleName != null) {
                    try {
                        proposal = XbaseProposalProvider.this.getValueConverter().toString((Object)proposal, this.ruleName);
                    }
                    catch (ValueConverterException e) {
                        log.debug((Object)e.getMessage(), (Throwable)e);
                        return null;
                    }
                }
                ProposalBracketInfo bracketInfo = XbaseProposalProvider.this.getProposalBracketInfo(myCandidate, this.contentAssistContext);
                proposal = String.valueOf(proposal) + bracketInfo.brackets;
                int insignificantParameters = 0;
                if (myCandidate instanceof IIdentifiableElementDescription) {
                    IIdentifiableElementDescription casted = (IIdentifiableElementDescription)myCandidate;
                    insignificantParameters = casted.getNumberOfIrrelevantParameters();
                }
                LightweightTypeReferenceFactory converter = XbaseProposalProvider.this.getTypeConverter(this.contentAssistContext.getResource());
                EObject objectOrProxy = myCandidate.getEObjectOrProxy();
                StyledString displayString = objectOrProxy instanceof JvmFeature ? (bracketInfo.brackets.startsWith(" =") ? XbaseProposalProvider.this.getStyledDisplayString((JvmFeature)objectOrProxy, false, insignificantParameters, XbaseProposalProvider.this.getQualifiedNameConverter().toString(myCandidate.getQualifiedName()), String.valueOf(XbaseProposalProvider.this.getQualifiedNameConverter().toString(myCandidate.getName())) + bracketInfo.brackets, converter) : XbaseProposalProvider.this.getStyledDisplayString((JvmFeature)objectOrProxy, !Strings.isEmpty((String)bracketInfo.brackets), insignificantParameters, XbaseProposalProvider.this.getQualifiedNameConverter().toString(myCandidate.getQualifiedName()), XbaseProposalProvider.this.getQualifiedNameConverter().toString(myCandidate.getName()), converter)) : XbaseProposalProvider.this.getStyledDisplayString(objectOrProxy, XbaseProposalProvider.this.getQualifiedNameConverter().toString(myCandidate.getQualifiedName()), XbaseProposalProvider.this.getQualifiedNameConverter().toString(myCandidate.getName()));
                result = XbaseProposalProvider.this.createCompletionProposal(proposal, displayString, null, myContentAssistContext);
                if (result instanceof ConfigurableCompletionProposal) {
                    ConfigurableCompletionProposal casted = (ConfigurableCompletionProposal)result;
                    casted.setAdditionalData(XbaseProposalProvider.DESCRIPTION_KEY, (Object)myCandidate);
                    casted.setAdditionalProposalInfo((Object)objectOrProxy);
                    casted.setHover(XbaseProposalProvider.this.getHover());
                    int offset = casted.getReplacementOffset() + proposal.length();
                    casted.setCursorPosition(casted.getCursorPosition() + bracketInfo.caretOffset);
                    if (bracketInfo.selectionOffset != 0) {
                        casted.setSelectionStart(offset += bracketInfo.selectionOffset);
                        casted.setSelectionLength(bracketInfo.selectionLength);
                        casted.setAutoInsertable(false);
                        casted.setSimpleLinkedMode(myContentAssistContext.getViewer(), new char[]{'\t', '\n', '\r'});
                    }
                    if (objectOrProxy instanceof JvmExecutable) {
                        final JvmExecutable executable = (JvmExecutable)objectOrProxy;
                        StyledString parameterList = new StyledString();
                        XbaseProposalProvider.this.appendParameters(parameterList, executable, insignificantParameters, converter);
                        if (parameterList.length() > 0) {
                            ParameterData parameterData = this.simpleNameToParameterList.get(myCandidate.getName());
                            if (parameterData == null) {
                                parameterData = new ParameterData();
                                this.simpleNameToParameterList.put(myCandidate.getName(), parameterData);
                            }
                            parameterData.addOverloaded(parameterList.toString(), executable.isVarArgs());
                            ParameterContextInformation contextInformation = new ParameterContextInformation(parameterData, displayString.toString(), offset, offset);
                            casted.setContextInformation((IContextInformation)contextInformation);
                        }
                        if (executable.getSimpleName().startsWith("is") && executable.getSimpleName().length() > 2 && executable.getParameters().size() - insignificantParameters == 0) {
                            ((ConfigurableCompletionProposal)result).setTextApplier(new ConfigurableCompletionProposal.IReplacementTextApplier(){

                                public void apply(IDocument document, ConfigurableCompletionProposal proposal) throws BadLocationException {
                                    String is;
                                    String replacementString = proposal.getReplacementString();
                                    if (proposal.getReplacementLength() >= 2 && "is".equals(is = document.get(proposal.getReplacementOffset(), 2))) {
                                        replacementString = XbaseProposalProvider.this.getValueConverter().toString((Object)executable.getSimpleName(), XbaseProposalCreator.this.ruleName);
                                    }
                                    proposal.setCursorPosition(replacementString.length());
                                    document.replace(proposal.getReplacementOffset(), proposal.getReplacementLength(), replacementString);
                                }
                            });
                        }
                    }
                }
                XbaseProposalProvider.this.getPriorityHelper().adjustCrossReferencePriority(result, myContentAssistContext.getPrefix());
                return result;
            }
            return super.apply(candidate);
        }
    }
}

