/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.section;

import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatChangeListener;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.Section;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.FormatStringDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class FormatStringSection
extends Section {
    private int style;
    private final boolean showLocale;
    protected FormatStringDescriptor format;
    IDescriptorProvider provider;

    public FormatStringSection(Composite parent, int style, boolean isFormStyle) {
        this(parent, style, isFormStyle, true);
    }

    public FormatStringSection(Composite parent, int style, boolean isFormStyle, boolean showLocale) {
        super(" ", parent, isFormStyle);
        this.style = style;
        this.showLocale = showLocale;
    }

    @Override
    public void createSection() {
        this.getFormatControl(this.parent);
        this.getGridPlaceholder(this.parent);
    }

    public FormatStringDescriptor getFormatControl() {
        return this.format;
    }

    protected FormatStringDescriptor getFormatControl(Composite parent) {
        if (this.format == null) {
            this.format = new FormatStringDescriptor(this.style, this.isFormStyle, this.showLocale);
            this.format.setDescriptorProvider(this.provider);
            this.format.createControl(parent);
            this.format.getControl().setLayoutData((Object)new GridData(1808));
            this.format.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    FormatStringSection.this.format = null;
                }
            });
        } else {
            this.checkParent(this.format.getControl(), parent);
        }
        return this.format;
    }

    @Override
    public void layout() {
        GridData gd = (GridData)this.format.getControl().getLayoutData();
        gd.horizontalSpan = this.getLayoutNum() > 0 ? this.getLayoutNum() - this.placeholder : ((GridLayout)this.parent.getLayout()).numColumns - this.placeholder;
    }

    public void addFormatChangeListener(IFormatChangeListener listener) {
        this.format.addFormatChangeListener(listener);
    }

    @Override
    public void load() {
        if (this.format != null && !this.format.getControl().isDisposed()) {
            this.format.load();
        }
    }

    public IDescriptorProvider getProvider() {
        return this.provider;
    }

    public void setProvider(IDescriptorProvider provider) {
        this.provider = provider;
        if (this.format != null) {
            this.format.setDescriptorProvider(provider);
        }
    }

    @Override
    public void setInput(Object input) {
        assert (input != null);
        this.format.setInput(input);
    }

    @Override
    public void setHidden(boolean isHidden) {
        if (this.format != null) {
            WidgetUtil.setExcludeGridData((Control)this.format.getControl(), (boolean)isHidden);
        }
    }

    @Override
    public void setVisible(boolean isVisable) {
        if (this.format != null) {
            this.format.getControl().setVisible(isVisable);
        }
    }

    @Override
    public void reset() {
        if (this.format != null && !this.format.getControl().isDisposed()) {
            this.format.reset();
        }
    }
}

