/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.outline.providers;

import java.util.ArrayList;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.RenameInputDialog;
import org.eclipse.birt.report.designer.internal.ui.views.actions.ExtendElementAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.ui.views.INodeProvider;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;

public class ThemesNodeProvider
extends DefaultNodeProvider {
    protected static final String NEW_THEME_ACTION_ID = "org.eclipse.birt.report.designer.internal.ui.action.NewThemeAction";

    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        if (object instanceof SlotHandle && ((SlotHandle)object).getElementHandle() instanceof LibraryHandle) {
            ExtendElementAction newThemeAction = new ExtendElementAction((INodeProvider)this, NEW_THEME_ACTION_ID, object, Messages.getString((String)"ThemesNodeProvider.action.New"), "Theme");
            menu.add((IAction)newThemeAction);
        }
        super.createContextMenu(sourceViewer, object, menu);
    }

    public String getNodeDisplayName(Object object) {
        return THEMES;
    }

    public String getIconName(Object model) {
        return "Themes";
    }

    protected DesignElementHandle createElement(String type) throws Exception {
        DesignElementFactory factory = DesignElementFactory.getInstance();
        if ("Theme".equals(type)) {
            Theme theme = new Theme(ReportPlugin.getDefault().getCustomName("Theme"));
            Module module = SessionHandleAdapter.getInstance().getReportDesignHandle().getModule();
            NameExecutor executor = new NameExecutor(module, (DesignElement)theme);
            executor.makeUniqueName();
            executor.dropElement();
            RenameInputDialog inputDialog = new RenameInputDialog(Display.getCurrent().getActiveShell(), Messages.getString((String)"NewThemeDialog.DialogTitle"), Messages.getString((String)"NewThemeDialog.DialogMessage"), theme.getName(), ChoiceSetFactory.getThemes(), "org.eclipse.birt.cshelp.NewTheme_ID");
            inputDialog.create();
            if (inputDialog.open() == 0) {
                return factory.newTheme(inputDialog.getResult().toString().trim());
            }
            return null;
        }
        return super.createElement(type);
    }

    public Object[] getChildren(Object model) {
        ArrayList list = new ArrayList();
        list.addAll(((SlotHandle)model).getElementHandle().getModuleHandle().getVisibleThemes(0));
        return list.toArray();
    }
}

