/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.ooxml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.report.engine.ooxml.ContentType;
import org.eclipse.birt.report.engine.ooxml.IPart;
import org.eclipse.birt.report.engine.ooxml.IPartContainer;
import org.eclipse.birt.report.engine.ooxml.OOXmlType;
import org.eclipse.birt.report.engine.ooxml.Package;
import org.eclipse.birt.report.engine.ooxml.Part;
import org.eclipse.birt.report.engine.ooxml.PartAlreadyExistsException;
import org.eclipse.birt.report.engine.ooxml.PartReference;
import org.eclipse.birt.report.engine.ooxml.util.OOXmlUtil;
import org.eclipse.birt.report.engine.ooxml.writer.OOXmlWriter;

public abstract class PartContainer
implements IPartContainer {
    private Map<String, IPart> parts;
    private Map<Hyperlink, Integer> hyperlinks;
    private int relationshipCount = 0;
    protected String uri;
    protected boolean cacheWriterUsed = false;

    public PartContainer(String uri) {
        this.uri = uri;
    }

    @Override
    public IPart getPart(String uri) {
        if (this.parts == null) {
            return null;
        }
        return this.parts.get(uri);
    }

    @Override
    public IPart getPart(String uri, String type, String relationshipType) {
        OOXmlType xmlType = new OOXmlType(type);
        IPart part = this.getPart(uri, xmlType, relationshipType);
        xmlType.setPart(part);
        return part;
    }

    @Override
    public IPart getPart(String uri, ContentType type, String relationshipType) {
        uri = OOXmlUtil.getRelativeUri(this.getAbsoluteUri(), uri);
        IPart part = this.getPart(uri);
        if (part != null) {
            if (!type.equals(part.getContentType())) {
                throw new PartAlreadyExistsException(part);
            }
            return part;
        }
        part = new Part(this, uri, type, relationshipType, this.nextRelationshipId());
        this.addPart(part);
        return part;
    }

    public String getHyperlinkId(String url) {
        return this.getHyperlinkId(url, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink");
    }

    public String getBookmarkId(String bmk) {
        return this.getHyperlinkId(bmk, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/slide");
    }

    public String getExternalImageId(String url) {
        return this.getHyperlinkId(url, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image");
    }

    private String getHyperlinkId(String url, String type) {
        Hyperlink hyperlink = new Hyperlink(url, type);
        Integer hyperlinkId = null;
        if (this.hyperlinks == null) {
            this.hyperlinks = new HashMap<Hyperlink, Integer>(8);
        } else {
            hyperlinkId = this.hyperlinks.get(hyperlink);
            if (hyperlinkId != null) {
                return OOXmlUtil.getRelationShipId(hyperlinkId);
            }
        }
        hyperlinkId = this.nextRelationshipId();
        this.hyperlinks.put(hyperlink, hyperlinkId);
        return OOXmlUtil.getRelationShipId(hyperlinkId);
    }

    public Collection<IPart> getParts() {
        if (this.parts == null) {
            return Collections.EMPTY_SET;
        }
        return this.parts.values();
    }

    public OOXmlWriter getCacheWriter() throws IOException {
        this.cacheWriterUsed = true;
        return this.getPackage().getTempWriter(this.getAbsoluteUri());
    }

    public OOXmlWriter getWriter() throws IOException {
        return this.getPackage().getEntryWriter(this.getAbsoluteUri());
    }

    public OutputStream getOutputStream() throws IOException {
        return this.getWriter().getOutputStream();
    }

    void addPart(IPart part) {
        if (this.parts == null) {
            this.parts = new HashMap<String, IPart>(8);
        }
        this.parts.put(part.getRelativeUri(), part);
    }

    @Override
    public IPart createPartReference(IPart part) {
        PartReference partReference = new PartReference(this, part, this.nextRelationshipId());
        this.addPart(partReference);
        return partReference;
    }

    protected void outputRelationships() throws IOException {
        if (this.notEmpty(this.parts) || this.notEmpty(this.hyperlinks)) {
            OOXmlWriter writer = this.getPackage().getEntryWriter(this.getRelationshipUri());
            writer.startWriter();
            writer.openTag("Relationships");
            writer.attribute("xmlns", "http://schemas.openxmlformats.org/package/2006/relationships");
            if (this.notEmpty(this.parts)) {
                Collection<IPart> children = this.parts.values();
                for (IPart iPart : children) {
                    if (iPart.getRelationshipType() == null) continue;
                    this.writeRelationshipEntry(writer, iPart.getRelativeUri(), iPart.getRelationshipId(), iPart.getRelationshipType());
                }
            }
            if (this.notEmpty(this.hyperlinks)) {
                Set<Map.Entry<Hyperlink, Integer>> hyperlinkSet = this.hyperlinks.entrySet();
                for (Map.Entry entry : hyperlinkSet) {
                    Hyperlink hyperlink = (Hyperlink)entry.getKey();
                    String url = hyperlink.url;
                    String relationshipId = OOXmlUtil.getRelationShipId((Integer)entry.getValue());
                    String type = hyperlink.type;
                    if (type.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/slide")) {
                        this.writeRelationshipEntry(writer, url, relationshipId, type);
                        continue;
                    }
                    this.writeRelationshipEntry(writer, url, relationshipId, type, "External");
                }
            }
            writer.closeTag("Relationships");
            writer.endWriter();
            writer.close();
        }
    }

    public boolean notEmpty(Map<?, ?> map) {
        return map != null && map.size() > 0;
    }

    private void writeRelationshipEntry(OOXmlWriter writer, String url, String relationshipId, String type) {
        this.writeRelationshipEntry(writer, url, relationshipId, type, null);
    }

    private void writeRelationshipEntry(OOXmlWriter writer, String url, String relationshipId, String type, String mode) {
        writer.openTag("Relationship");
        writer.attribute("Id", relationshipId);
        writer.attribute("Type", type);
        writer.attribute("Target", url);
        if (mode != null) {
            writer.attribute("TargetMode", mode);
        }
        writer.closeTag("Relationship");
    }

    protected String getAbsolutUriOfChild(String uri) {
        return OOXmlUtil.getAbsoluteUri(this.getAbsoluteUri(), uri);
    }

    protected abstract String getAbsoluteUri();

    protected abstract Package getPackage();

    protected abstract String getRelationshipUri();

    private int nextRelationshipId() {
        ++this.relationshipCount;
        return this.relationshipCount;
    }

    public void release() {
        if (this.parts != null) {
            this.parts.clear();
            this.parts = null;
        }
        if (this.hyperlinks != null) {
            this.hyperlinks.clear();
            this.hyperlinks = null;
        }
    }

    public void updateBmk(String wrngurl, String realurl) {
        if (realurl != null) {
            Hyperlink link = new Hyperlink(wrngurl, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/slide");
            Integer relationshipid = this.hyperlinks.get(link);
            this.hyperlinks.remove(link);
            link = new Hyperlink(realurl, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/slide");
            this.hyperlinks.put(link, relationshipid);
        }
    }

    public static class Hyperlink {
        String url;
        String type;

        public Hyperlink(String url, String type) {
            this.url = url;
            this.type = type;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Hyperlink)) {
                return false;
            }
            Hyperlink link = (Hyperlink)obj;
            return this.url == null ? link.url == null : this.url.equals(link.url);
        }

        public int hashCode() {
            if (this.url == null) {
                return 0;
            }
            return this.url.hashCode();
        }
    }
}

