/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.RowArea;

public abstract class RepeatableArea
extends BlockContainerArea {
    protected List repeatList = null;
    protected int repeatHeight = 0;
    protected boolean inHeaderBand = false;

    public RepeatableArea(ContainerArea parent, LayoutContext context, IContent content) {
        super(parent, context, content);
        if (this.needRepeat()) {
            this.repeatList = new ArrayList();
        }
    }

    public void setInHeaderBand(boolean inHeaderBand) {
        this.inHeaderBand = inHeaderBand;
    }

    protected boolean isFirstChildInHeaderBand() {
        AbstractArea first;
        return this.children.size() > 0 && this.isInRepeatHeader(first = (AbstractArea)this.children.get(0));
    }

    @Override
    protected void addRepeatedItem() throws BirtException {
        if (this.repeatList != null && this.repeatList.size() > 0 && !this.inHeaderBand && !this.isFirstChildInHeaderBand()) {
            if (this.getRepeatedHeight() < this.getMaxAvaHeight()) {
                int i = 0;
                while (i < this.repeatList.size()) {
                    ContainerArea row = (ContainerArea)this.repeatList.get(i);
                    ContainerArea cloneRow = row.deepClone();
                    if (cloneRow instanceof RowArea) {
                        ((RowArea)cloneRow).needResolveBorder = true;
                    }
                    cloneRow.finished = true;
                    this.children.add(i, cloneRow);
                    cloneRow.setParent(this);
                    this.update(cloneRow);
                    cloneRow.setAllocatedY(this.currentBP);
                    ++i;
                }
            } else {
                this.repeatList = null;
            }
        }
    }

    @Override
    public int getMaxAvaHeight() {
        return super.getMaxAvaHeight() - this.getRepeatedHeight();
    }

    protected int getRepeatedHeight() {
        if (this.inHeaderBand) {
            return 0;
        }
        if (this.repeatHeight != 0) {
            return this.repeatHeight;
        }
        if (this.repeatList != null) {
            int i = 0;
            while (i < this.repeatList.size()) {
                AbstractArea area = (AbstractArea)this.repeatList.get(i);
                this.repeatHeight += area.getAllocatedHeight();
                ++i;
            }
            return this.repeatHeight;
        }
        return 0;
    }

    @Override
    public ContainerArea.SplitResult split(int height, boolean force) throws BirtException {
        if (!force && this.repeatList != null && this.repeatList.size() > 0) {
            Iterator i = this.children.iterator();
            boolean firstHeaderRow = true;
            while (i.hasNext()) {
                ContainerArea area = (ContainerArea)i.next();
                if (!this.isInRepeatHeader(area)) continue;
                if (firstHeaderRow) {
                    area.setPageBreakInside(IStyle.AVOID_VALUE);
                    firstHeaderRow = false;
                    continue;
                }
                area.setPageBreakInside(IStyle.AVOID_VALUE);
                area.setPageBreakBefore(IStyle.AVOID_VALUE);
            }
        }
        return super.split(height, force);
    }

    @Override
    protected boolean isValidResult(List result) {
        assert (result != null);
        if (this.repeatList != null && !this.repeatList.isEmpty()) {
            if (result.size() > this.repeatList.size()) {
                return true;
            }
            int index = result.indexOf(this.repeatList.get(this.repeatList.size() - 1));
            return index != -1 && result.size() - 1 > index;
        }
        return super.isValidResult(result);
    }

    protected abstract boolean needRepeat();

    public RepeatableArea(RepeatableArea area) {
        super(area);
    }

    @Override
    public void add(AbstractArea area) {
        super.add(area);
        if (this.repeatList != null && this.isInRepeatHeader(area)) {
            this.repeatList.add(area);
        }
    }

    private boolean isInRepeatHeader(AbstractArea area) {
        int type;
        IElement parent;
        IContent content = ((ContainerArea)area).getContent();
        if (content != null && (parent = content.getParent()) != null && parent instanceof IBandContent && ((type = ((IBandContent)parent).getBandType()) == 1 || type == 3)) {
            if (content instanceof IRowContent) {
                RowDesign rowDesign = (RowDesign)content.getGenerateBy();
                if (rowDesign == null || rowDesign.getRepeatable()) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }
}

