/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.ui.internal.remote;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoBoard;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoManager;
import org.eclipse.cdt.arduino.core.internal.remote.ArduinoRemoteConnection;
import org.eclipse.cdt.arduino.ui.internal.Activator;
import org.eclipse.cdt.arduino.ui.internal.Messages;
import org.eclipse.cdt.serial.SerialPort;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class ArduinoTargetPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private Combo portSelector;
    private Combo boardSelector;
    private ArduinoBoard[] boards;

    protected Control createContents(Composite parent) {
        Object object;
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        IRemoteConnection remoteConnection = (IRemoteConnection)this.getElement().getAdapter(IRemoteConnection.class);
        ArduinoRemoteConnection arduinoRemote = (ArduinoRemoteConnection)remoteConnection.getService(ArduinoRemoteConnection.class);
        Label portLabel = new Label(comp, 0);
        portLabel.setText(Messages.ArduinoTargetPropertyPage_0);
        this.portSelector = new Combo(comp, 0);
        this.portSelector.setLayoutData((Object)new GridData(768));
        String currentPort = arduinoRemote.getPortName();
        try {
            int i = 0;
            int portIdx = -1;
            String[] ports = SerialPort.list();
            object = ports;
            int n = ports.length;
            int n2 = 0;
            while (n2 < n) {
                String port = object[n2];
                this.portSelector.add(port);
                if (port.equals(currentPort)) {
                    portIdx = i;
                }
                ++i;
                ++n2;
            }
            if (portIdx >= 0) {
                this.portSelector.select(portIdx);
            }
            if (ports.length == 0) {
                this.portSelector.setText(Messages.ArduinoTargetPropertyPage_1);
            }
        }
        catch (IOException e) {
            Activator.log(e);
        }
        Label boardLabel = new Label(comp, 0);
        boardLabel.setText(Messages.ArduinoTargetPropertyPage_2);
        this.boardSelector = new Combo(comp, 8);
        this.boardSelector.setLayoutData((Object)new GridData(768));
        try {
            ArduinoBoard currentBoard = arduinoRemote.getBoard();
            Collection boardList = Activator.getService(ArduinoManager.class).getInstalledBoards();
            this.boards = new ArduinoBoard[boardList.size()];
            int i = 0;
            int boardSel = 0;
            object = boardList.iterator();
            while (object.hasNext()) {
                ArduinoBoard board;
                this.boards[i] = board = (ArduinoBoard)object.next();
                this.boardSelector.add(board.getName());
                if (board.equals((Object)currentBoard)) {
                    boardSel = i;
                }
                ++i;
            }
            this.boardSelector.select(boardSel);
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
        }
        return comp;
    }

    public boolean performOk() {
        IRemoteConnection remoteConnection = (IRemoteConnection)this.getElement().getAdapter(IRemoteConnection.class);
        IRemoteConnectionWorkingCopy workingCopy = remoteConnection.getWorkingCopy();
        ArduinoBoard board = this.boards[this.boardSelector.getSelectionIndex()];
        ArduinoRemoteConnection.setBoardId((IRemoteConnectionWorkingCopy)workingCopy, (ArduinoBoard)board);
        int idx = this.portSelector.getSelectionIndex();
        if (idx >= 0) {
            ArduinoRemoteConnection.setPortName((IRemoteConnectionWorkingCopy)workingCopy, (String)this.portSelector.getItem(idx));
        }
        try {
            workingCopy.save();
        }
        catch (RemoteConnectionException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
        return true;
    }
}

