/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.lrparser.xlc.ui.preferences;

import org.eclipse.cdt.core.lrparser.xlc.preferences.XlcLanguagePreferences;
import org.eclipse.cdt.core.lrparser.xlc.preferences.XlcPref;
import org.eclipse.cdt.internal.core.lrparser.xlc.ui.preferences.PrefCheckbox;
import org.eclipse.cdt.internal.core.lrparser.xlc.ui.preferences.PreferenceMessages;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class XlcLanguageOptionsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private IAdaptable element;
    private PrefCheckbox[] checkboxes;

    private void initializeCheckboxes(Composite group) {
        XlcPref[] prefs = XlcPref.values();
        int n = prefs.length;
        this.checkboxes = new PrefCheckbox[n];
        IProject project = this.getProject();
        int i = 0;
        while (i < n) {
            String message = PreferenceMessages.getMessage(prefs[i].toString());
            this.checkboxes[i] = new PrefCheckbox(group, prefs[i], message);
            String preference = XlcLanguagePreferences.get(prefs[i], project);
            this.checkboxes[i].setSelection(Boolean.valueOf(preference));
            ++i;
        }
    }

    protected Control createContents(Composite parent) {
        Composite page = ControlFactory.createComposite((Composite)parent, (int)1);
        if (this.isPropertyPage()) {
            Link link = new Link(page, 0);
            link.setText(PreferenceMessages.XlcLanguageOptionsPreferencePage_link);
            link.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    PreferencesUtil.createPreferenceDialogOn((Shell)XlcLanguageOptionsPreferencePage.this.getShell(), (String)event.text, null, null).open();
                }
            });
        }
        Group group = ControlFactory.createGroup((Composite)page, (String)PreferenceMessages.XlcLanguageOptionsPreferencePage_group, (int)1);
        this.initializeCheckboxes((Composite)group);
        return page;
    }

    protected void performDefaults() {
        PrefCheckbox[] prefCheckboxArray = this.checkboxes;
        int n = this.checkboxes.length;
        int n2 = 0;
        while (n2 < n) {
            PrefCheckbox button = prefCheckboxArray[n2];
            button.setDefault();
            ++n2;
        }
        super.performDefaults();
    }

    public boolean performOk() {
        IProject project = this.getProject();
        PrefCheckbox[] prefCheckboxArray = this.checkboxes;
        int n = this.checkboxes.length;
        int n2 = 0;
        while (n2 < n) {
            PrefCheckbox button = prefCheckboxArray[n2];
            XlcLanguageOptionsPreferencePage.setPreference(button.getKey(), button.getSelection(), project);
            ++n2;
        }
        return true;
    }

    private static void setPreference(XlcPref key, boolean val, IProject project) {
        String s = String.valueOf(val);
        if (project != null) {
            XlcLanguagePreferences.setProjectPreference(key, s, project);
        } else {
            XlcLanguagePreferences.setWorkspacePreference(key, s);
        }
    }

    private IProject getProject() {
        return this.isPropertyPage() ? (IProject)this.element.getAdapter(IProject.class) : null;
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }

    public boolean isPropertyPage() {
        return this.element != null;
    }

    public void init(IWorkbench workbench) {
    }
}

