/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.debug.application;

import org.eclipse.cdt.debug.application.Messages;
import org.eclipse.cdt.debug.application.NewExecutableDialog;
import org.eclipse.cdt.debug.application.NewExecutableInfo;
import org.eclipse.cdt.internal.debug.application.DebugExecutable;
import org.eclipse.cdt.internal.debug.application.JobContainer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DebugNewExecutableHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        NewExecutableDialog dialog = new NewExecutableDialog(new Shell());
        if (dialog.open() == 0) {
            NewExecutableInfo info = dialog.getExecutableInfo();
            String executable = info.getHostPath();
            String arguments = info.getArguments();
            String buildLog = info.getBuildLog();
            try {
                final ILaunchConfiguration config = DebugExecutable.importAndCreateLaunchConfig((IProgressMonitor)new NullProgressMonitor(), executable, buildLog, arguments, false);
                if (config != null) {
                    final JobContainer LaunchJobs = new JobContainer();
                    Job.getJobManager().addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void scheduled(IJobChangeEvent event) {
                            Job job = event.getJob();
                            if (job.getName().contains(config.getName())) {
                                LaunchJobs.setLaunchJob(job);
                            }
                        }

                        public void done(IJobChangeEvent event) {
                        }
                    });
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            DebugUITools.launch((ILaunchConfiguration)config, (String)"debug");
                        }
                    });
                    if (LaunchJobs.getLaunchJob() != null) {
                        try {
                            LaunchJobs.getLaunchJob().join();
                        }
                        catch (InterruptedException e) {
                            Status status = new Status(4, "GDBStandalone", 0, Messages.LaunchInterruptedError, (Throwable)e);
                            ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

