/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.profile;

import org.eclipse.datatools.connectivity.ConnectEvent;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.sqltools.core.profile.ConnectProfile;
import org.eclipse.datatools.sqltools.core.profile.ISQLToolsProfileListener;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLToolsConnectListener;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.utils.EditorUtil;

public class SQLEditorProfileListener
implements ISQLToolsProfileListener,
ISQLToolsConnectListener {
    public void profileAdded(IConnectionProfile profile) {
    }

    public void profileChanged(IConnectionProfile profile, String oldName, String oldDesc, Boolean oldAutoConnect, boolean onlyNameChanged, ConnectProfile oldProfile) {
        if (onlyNameChanged) {
            EditorUtil.renameEditorsProfileName(oldName, profile.getName());
        } else {
            EditorUtil.setEditorsProfileStatus(profile.getName(), 4);
            EditorUtil.closeAllEditors(profile.getName());
        }
    }

    public void profileDeleted(IConnectionProfile profile) {
        EditorUtil.setEditorsProfileStatus(profile.getName(), 1);
        EditorUtil.closeAllEditors(profile.getName());
    }

    public void closeConnection(ConnectEvent event) {
        IConnectionProfile profile = event.getConnectionProfile();
        EditorUtil.setEditorsProfileStatus(profile.getName(), 2);
        EditorUtil.closeAllEditors(profile.getName());
    }

    public boolean okToClose(ConnectEvent event) {
        String profileName = event.getConnectionProfile().getName();
        return EditorUtil.okToCloseEditors(profileName);
    }

    public void aboutToClose(ConnectEvent event) {
    }

    public void profileConnected(ConnectEvent event) {
        final IConnectionProfile profile = event.getConnectionProfile();
        SQLEditorPlugin.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                EditorUtil.setEditorsProfileStatus(profile.getName(), 5);
            }
        });
    }
}

