/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.sh.internal.ui.completion;

import org.eclipse.dltk.codeassist.ScriptCompletionEngine;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.sh.internal.ui.text.ShellCodeScanner;

public class ShellCompletionEngine
extends ScriptCompletionEngine {
    private int actualCompletionPosition;

    public void complete(IModuleSource module, int position, int pos) {
        block5: {
            int lastNewline;
            String temp;
            this.actualCompletionPosition = position;
            this.offset = pos;
            int lastSpace = (temp = module.getSourceContents().substring(0, position)).lastIndexOf(32);
            String complPrefix = temp.substring(lastSpace > (lastNewline = temp.lastIndexOf(10)) ? lastSpace : lastNewline).trim();
            this.requestor.beginReporting();
            String[] stringArray = ShellCodeScanner.KEYWORDS;
            int n = ShellCodeScanner.KEYWORDS.length;
            int n2 = 0;
            while (n2 < n) {
                String keyword = stringArray[n2];
                if (keyword.startsWith(complPrefix)) {
                    this.createProposal(keyword, null);
                }
                ++n2;
            }
            for (String command : ShellCodeScanner.getCommands()) {
                if (!command.startsWith(complPrefix)) continue;
                this.createProposal(command, null);
            }
            try {
                module.getModelElement().accept(element -> {
                    if (element.getElementType() > 5) {
                        this.createProposal(element.getElementName(), element);
                    }
                    return true;
                });
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) break block5;
                e.printStackTrace();
            }
        }
        this.requestor.endReporting();
    }

    private void createProposal(String name, IModelElement element) {
        CompletionProposal proposal = this.createProposal(2, this.actualCompletionPosition);
        proposal.setName(name);
        proposal.setCompletion(name);
        proposal.setReplaceRange(this.actualCompletionPosition - this.offset, this.actualCompletionPosition - this.offset);
        proposal.setRelevance(20);
        proposal.setModelElement(element);
        this.requestor.accept(proposal);
    }
}

