/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.sh.internal.ui.text;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

public class DollarRule
implements IRule {
    private final StringBuffer buffer = new StringBuffer();
    private final IToken defaultToken;
    private final IWordDetector detector;
    private final IToken successToken;

    public DollarRule(IWordDetector detector, IToken defaultToken, IToken token) {
        this.detector = detector;
        this.successToken = token;
        this.defaultToken = defaultToken;
    }

    private static boolean isSpecial(char c) {
        return c == '*' || c == '@' || c == '#' || c == '?' || c == '-' || c == '$' || c == '!' || c == '_' || Character.isDigit(c);
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        if (this.detector.isWordStart((char)c)) {
            this.buffer.setLength(0);
            do {
                this.buffer.append((char)c);
                c = scanner.read();
                if (this.buffer.length() != 1 || !DollarRule.isSpecial((char)c)) continue;
                return this.successToken;
            } while (c != -1 && this.detector.isWordPart((char)c));
            scanner.unread();
            if (this.buffer.length() > 1) {
                return this.successToken;
            }
            if (this.defaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            return this.defaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    protected void unreadBuffer(ICharacterScanner scanner) {
        int i = this.buffer.length() - 1;
        while (i >= 0) {
            scanner.unread();
            --i;
        }
    }
}

