/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.completion;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;

public class ContentAssistInvocationContext {
    private final ITextViewer fViewer;
    private final IDocument fDocument;
    private final int fOffset;
    private CharSequence fPrefix;

    public ContentAssistInvocationContext(ITextViewer viewer) {
        this(viewer, viewer.getSelectedRange().x);
    }

    public ContentAssistInvocationContext(ITextViewer viewer, int offset) {
        Assert.isNotNull((Object)viewer);
        this.fViewer = viewer;
        this.fDocument = null;
        this.fOffset = offset;
    }

    protected ContentAssistInvocationContext() {
        this.fDocument = null;
        this.fViewer = null;
        this.fOffset = -1;
    }

    public ContentAssistInvocationContext(IDocument document, int offset) {
        Assert.isNotNull((Object)document);
        Assert.isTrue((offset >= 0 ? 1 : 0) != 0);
        this.fViewer = null;
        this.fDocument = document;
        this.fOffset = offset;
    }

    public final int getInvocationOffset() {
        return this.fOffset;
    }

    public final ITextViewer getViewer() {
        return this.fViewer;
    }

    public IDocument getDocument() {
        if (this.fDocument == null) {
            if (this.fViewer == null) {
                return null;
            }
            return this.fViewer.getDocument();
        }
        return this.fDocument;
    }

    public CharSequence computeIdentifierPrefix() throws BadLocationException {
        if (this.fPrefix == null) {
            int end;
            IDocument document = this.getDocument();
            if (document == null) {
                return null;
            }
            int start = end = this.getInvocationOffset();
            while (--start >= 0) {
                if (!Character.isJavaIdentifierPart(document.getChar(start))) break;
            }
            this.fPrefix = document.get(++start, end - start);
        }
        return this.fPrefix;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ContentAssistInvocationContext other = (ContentAssistInvocationContext)obj;
        return (this.fViewer == null && other.fViewer == null || this.fViewer.equals(other.fViewer)) && this.fOffset == other.fOffset && (this.fDocument == null && other.fDocument == null || this.fDocument.equals(other.fDocument));
    }

    public int hashCode() {
        return 0x2CBEB1A0 | (this.fViewer == null ? 0 : this.fViewer.hashCode() << 3) | this.fOffset;
    }
}

