/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.repository.tree.StashedCommitNode;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public abstract class RepositoryTreeNode<T>
extends PlatformObject
implements Comparable<RepositoryTreeNode> {
    private Repository myRepository;
    private T myObject;
    private final RepositoryTreeNodeType myType;
    private final RepositoryTreeNode myParent;

    public RepositoryTreeNode(RepositoryTreeNode parent, RepositoryTreeNodeType type, Repository repository, T treeObject) {
        this.myParent = parent;
        this.myRepository = repository;
        this.myType = type;
        this.myObject = treeObject;
    }

    public RepositoryTreeNode getParent() {
        return this.myParent;
    }

    public RepositoryTreeNodeType getType() {
        return this.myType;
    }

    public Repository getRepository() {
        return this.myRepository;
    }

    public IPath getPath() {
        Repository repository = this.getRepository();
        if (repository == null) {
            return null;
        }
        return new Path(this.getRepository().getWorkTree().getAbsolutePath());
    }

    public void clear() {
        this.myRepository = null;
        this.myObject = null;
    }

    public T getObject() {
        return this.myObject;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        switch (this.myType) {
            case REPO: 
            case BRANCHES: 
            case LOCAL: 
            case REMOTETRACKING: 
            case ADDITIONALREFS: 
            case REMOTES: 
            case SUBMODULES: 
            case STASH: 
            case WORKINGDIR: {
                result = 31 * result + (this.myObject == null ? 0 : ((Repository)this.myObject).getDirectory().hashCode());
                break;
            }
            case REF: 
            case ADDITIONALREF: 
            case TAG: {
                result = 31 * result + (this.myObject == null ? 0 : ((Ref)this.myObject).getName().hashCode());
                break;
            }
            case FOLDER: 
            case FILE: {
                result = 31 * result + (this.myObject == null ? 0 : ((File)this.myObject).getPath().hashCode());
                break;
            }
            case BRANCHHIERARCHY: 
            case TAGS: 
            case REMOTE: 
            case FETCH: 
            case PUSH: 
            case STASHED_COMMIT: 
            case ERROR: {
                result = 31 * result + (this.myObject == null ? 0 : this.myObject.hashCode());
            }
        }
        result = 31 * result + (this.myParent == null ? 0 : this.myParent.hashCode());
        result = 31 * result + (this.myRepository == null ? 0 : this.myRepository.getDirectory().hashCode());
        result = 31 * result + this.myType.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryTreeNode other = (RepositoryTreeNode)obj;
        if (this.myType == null ? other.myType != null : !this.myType.equals((Object)other.myType)) {
            return false;
        }
        if (this.myParent == null ? other.myParent != null : !this.myParent.equals(other.myParent)) {
            return false;
        }
        if (this.myRepository == null) {
            if (other.myRepository != null) {
                return false;
            }
        } else {
            if (other.myRepository == null) {
                return false;
            }
            if (!this.myRepository.getDirectory().equals(other.myRepository.getDirectory())) {
                return false;
            }
        }
        if (this.myObject == null) {
            if (other.myObject != null) {
                return false;
            }
        } else {
            if (other.myObject == null) {
                return false;
            }
            if (!this.checkObjectsEqual(other.myObject)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int compareTo(RepositoryTreeNode otherNode) {
        int typeDiff = this.myType.ordinal() - otherNode.getType().ordinal();
        if (typeDiff != 0) {
            return typeDiff;
        }
        switch (this.myType) {
            case BRANCHES: 
            case LOCAL: 
            case BRANCHHIERARCHY: 
            case REMOTETRACKING: {
                return CommonUtils.STRING_ASCENDING_COMPARATOR.compare(this.myObject.toString(), otherNode.getObject().toString());
            }
            case TAGS: 
            case ADDITIONALREFS: 
            case REMOTES: 
            case SUBMODULES: 
            case STASH: 
            case WORKINGDIR: 
            case ERROR: {
                return 0;
            }
            case REMOTE: 
            case FETCH: 
            case PUSH: {
                return CommonUtils.STRING_ASCENDING_COMPARATOR.compare((String)this.myObject, (String)otherNode.getObject());
            }
            case FOLDER: 
            case FILE: {
                return CommonUtils.STRING_ASCENDING_COMPARATOR.compare(((File)this.myObject).getName(), ((File)otherNode.getObject()).getName());
            }
            case STASHED_COMMIT: {
                return ((StashedCommitNode)this).getIndex() - ((StashedCommitNode)otherNode).getIndex();
            }
            case REF: 
            case ADDITIONALREF: 
            case TAG: {
                return CommonUtils.REF_ASCENDING_COMPARATOR.compare((Ref)this.myObject, (Ref)otherNode.getObject());
            }
            case REPO: {
                int nameCompare = CommonUtils.STRING_ASCENDING_COMPARATOR.compare(this.getDirectoryContainingRepo((Repository)this.myObject).getName(), this.getDirectoryContainingRepo((Repository)otherNode.getObject()).getName());
                if (nameCompare != 0) {
                    return nameCompare;
                }
                return CommonUtils.STRING_ASCENDING_COMPARATOR.compare(this.getDirectoryContainingRepo((Repository)this.myObject).getParentFile().getPath(), this.getDirectoryContainingRepo((Repository)otherNode.getObject()).getParentFile().getPath());
            }
        }
        return 0;
    }

    private File getDirectoryContainingRepo(Repository repo) {
        if (!repo.isBare()) {
            return repo.getDirectory().getParentFile();
        }
        return repo.getDirectory();
    }

    private boolean checkObjectsEqual(Object otherObject) {
        switch (this.myType) {
            case REPO: 
            case BRANCHES: 
            case LOCAL: 
            case REMOTETRACKING: 
            case ADDITIONALREFS: 
            case REMOTES: 
            case SUBMODULES: 
            case STASH: 
            case WORKINGDIR: {
                return ((Repository)this.myObject).getDirectory().equals(((Repository)otherObject).getDirectory());
            }
            case REF: 
            case ADDITIONALREF: 
            case TAG: {
                return ((Ref)this.myObject).getName().equals(((Ref)otherObject).getName());
            }
            case FOLDER: 
            case FILE: {
                return ((File)this.myObject).getPath().equals(((File)otherObject).getPath());
            }
            case BRANCHHIERARCHY: 
            case TAGS: 
            case REMOTE: 
            case FETCH: 
            case PUSH: 
            case STASHED_COMMIT: 
            case ERROR: {
                return this.myObject.equals(otherObject);
            }
        }
        return false;
    }

    public <X> X getAdapter(Class<X> adapter) {
        if (Repository.class == adapter && this.myRepository != null) {
            return adapter.cast(this.myRepository);
        }
        if (this.myObject != null && adapter.isInstance(this.myObject)) {
            return adapter.cast(this.myObject);
        }
        return (X)super.getAdapter(adapter);
    }

    public String toString() {
        return "RepositoryNode[" + (Object)((Object)this.myType) + ", " + this.myObject.toString() + "]";
    }
}

