/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.common.CDOReplicationContext;
import org.eclipse.net4j.util.WrappedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicateRepositoryIndication
extends CDOServerReadIndication {
    private int lastReplicatedBranchID;
    private long lastReplicatedCommitTime;
    private String[] lockAreaIDs;

    public ReplicateRepositoryIndication(CDOServerProtocol protocol) {
        super(protocol, (short)42);
    }

    @Override
    protected void indicating(CDODataInput in) throws IOException {
        this.lastReplicatedBranchID = in.readXInt();
        this.lastReplicatedCommitTime = in.readXLong();
        this.lockAreaIDs = new String[in.readXInt()];
        int i = 0;
        while (i < this.lockAreaIDs.length) {
            this.lockAreaIDs[i] = in.readString();
            ++i;
        }
    }

    private Set<String> createLockAreaIDSet() {
        HashSet<String> idSet = new HashSet<String>(this.lockAreaIDs.length);
        String[] stringArray = this.lockAreaIDs;
        int n = this.lockAreaIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            idSet.add(id);
            ++n2;
        }
        return idSet;
    }

    @Override
    protected void responding(final CDODataOutput out) throws IOException {
        final Set<String> lockAreaIDSet = this.createLockAreaIDSet();
        this.getRepository().replicate(new CDOReplicationContext(){

            public int getLastReplicatedBranchID() {
                return ReplicateRepositoryIndication.this.lastReplicatedBranchID;
            }

            public long getLastReplicatedCommitTime() {
                return ReplicateRepositoryIndication.this.lastReplicatedCommitTime;
            }

            public String[] getLockAreaIDs() {
                return ReplicateRepositoryIndication.this.lockAreaIDs;
            }

            public void handleBranch(CDOBranch branch) {
                try {
                    out.writeByte(1);
                    out.writeCDOBranch(branch);
                }
                catch (IOException ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
            }

            public void handleCommitInfo(CDOCommitInfo commitInfo) {
                try {
                    out.writeByte(2);
                    out.writeCDOCommitInfo(commitInfo);
                }
                catch (IOException ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
            }

            public boolean handleLockArea(IDurableLockingManager.LockArea lockArea) {
                try {
                    out.writeByte(3);
                    out.writeBoolean(true);
                    out.writeCDOLockArea(lockArea);
                    lockAreaIDSet.remove(lockArea.getDurableLockingID());
                    return true;
                }
                catch (IOException ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
            }
        });
        for (String deletedLockAreaID : lockAreaIDSet) {
            out.writeByte(3);
            out.writeBoolean(false);
            out.writeString(deletedLockAreaID);
        }
        out.writeByte(0);
    }
}

