/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.compare.internal.MergeViewerContentProvider;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.graphics.Image;

public class MirrorManager {
    private final EMFCompareConfiguration configuration;
    private IContentProvider managedContentProvider;
    private IContentProvider mirroredManagedContentProvider;

    public MirrorManager(EMFCompareConfiguration configuration) {
        this.configuration = configuration;
    }

    public IContentProvider getContentProvider(IContentProvider contentProvider) {
        Assert.isTrue((boolean)(contentProvider instanceof IMergeViewerContentProvider));
        if (this.managedContentProvider == null) {
            this.managedContentProvider = contentProvider;
        }
        if (this.configuration.isMirrored()) {
            if (this.mirroredManagedContentProvider == null) {
                this.mirroredManagedContentProvider = new MirroredContentProvider(this.configuration, (IMergeViewerContentProvider)this.managedContentProvider);
            }
            return this.mirroredManagedContentProvider;
        }
        return this.managedContentProvider;
    }

    public boolean handlePropertyChangeEvent(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.compare.Swapped")) {
            this.configuration.setProperty("MIRRORED", event.getNewValue());
            return true;
        }
        return false;
    }

    private static class MirroredContentProvider
    extends MergeViewerContentProvider {
        private final IMergeViewerContentProvider delegate;

        public MirroredContentProvider(EMFCompareConfiguration configuration, IMergeViewerContentProvider delegate) {
            super((CompareConfiguration)configuration);
            this.delegate = delegate;
        }

        public boolean showAncestor(Object input) {
            return this.delegate.showAncestor(input);
        }

        public void saveRightContent(Object input, byte[] bytes) {
            this.delegate.saveLeftContent(input, bytes);
        }

        public void saveLeftContent(Object input, byte[] bytes) {
            this.delegate.saveRightContent(input, bytes);
        }

        public boolean isRightEditable(Object input) {
            return this.delegate.isLeftEditable(input);
        }

        public boolean isLeftEditable(Object input) {
            return this.delegate.isRightEditable(input);
        }

        public String getRightLabel(Object input) {
            return this.delegate.getLeftLabel(input);
        }

        public Image getRightImage(Object input) {
            return this.delegate.getLeftImage(input);
        }

        public Object getRightContent(Object input) {
            return this.delegate.getLeftContent(input);
        }

        public String getLeftLabel(Object input) {
            return this.delegate.getRightLabel(input);
        }

        public Image getLeftImage(Object input) {
            return this.delegate.getRightImage(input);
        }

        public Object getLeftContent(Object input) {
            return this.delegate.getRightContent(input);
        }

        public String getAncestorLabel(Object input) {
            return this.delegate.getAncestorLabel(input);
        }

        public Image getAncestorImage(Object input) {
            return this.delegate.getAncestorImage(input);
        }

        public Object getAncestorContent(Object input) {
            return this.delegate.getAncestorContent(input);
        }

        public void setLeftError(String errorMessage) {
            super.setRightError(errorMessage);
        }

        public void setRightError(String errorMessage) {
            super.setLeftError(errorMessage);
        }

        public void dispose() {
            super.dispose();
            this.delegate.dispose();
        }
    }
}

