/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.scope;

import java.util.ArrayList;
import org.eclipse.help.IIndexEntry;
import org.eclipse.help.IIndexEntry2;
import org.eclipse.help.IIndexSee;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.IUAElement;
import org.eclipse.help.base.AbstractHelpScope;
import org.eclipse.help.internal.UAElement;
import org.eclipse.help.internal.index.Index;
import org.eclipse.help.internal.index.IndexEntry;
import org.eclipse.help.internal.index.IndexSee;

public class ScopeUtils {
    public static boolean showInTree(IToc toc, AbstractHelpScope scope) {
        if (scope.isHierarchicalScope() && !scope.inScope(toc)) {
            return false;
        }
        return ScopeUtils.hasInScopeDescendent(toc, scope);
    }

    public static boolean showInTree(ITopic topic, AbstractHelpScope scope) {
        if (scope.inScope(topic)) {
            return topic.getHref() != null || ScopeUtils.hasInScopeDescendent(topic, scope);
        }
        return !scope.isHierarchicalScope() && ScopeUtils.hasInScopeDescendent(topic, scope);
    }

    public static boolean showInTree(IIndexEntry entry, AbstractHelpScope scope) {
        if (scope.isHierarchicalScope() && !scope.inScope(entry)) {
            return false;
        }
        return ScopeUtils.hasInScopeDescendent(entry, scope);
    }

    public static boolean hasInScopeDescendent(ITopic topic, AbstractHelpScope scope) {
        ITopic[] subtopics = topic.getSubtopics();
        int i = 0;
        while (i < subtopics.length) {
            if (ScopeUtils.showInTree(subtopics[i], scope)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasInScopeDescendent(IToc toc, AbstractHelpScope scope) {
        ITopic[] topics = toc.getTopics();
        int i = 0;
        while (i < topics.length) {
            if (ScopeUtils.showInTree(topics[i], scope)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasInScopeDescendent(IIndexEntry entry, AbstractHelpScope scope) {
        ITopic[] topics = entry.getTopics();
        int t = 0;
        while (t < topics.length) {
            if (ScopeUtils.showInTree(topics[t], scope)) {
                return true;
            }
            ++t;
        }
        IIndexEntry[] entries = entry.getSubentries();
        int e = 0;
        while (e < entries.length) {
            if (ScopeUtils.showInTree(entries[e], scope)) {
                return true;
            }
            ++e;
        }
        if (entry instanceof IIndexEntry2) {
            IIndexSee[] sees = ((IIndexEntry2)entry).getSees();
            int s = 0;
            while (s < sees.length) {
                if (ScopeUtils.showInTree(sees[s], scope)) {
                    return true;
                }
                ++s;
            }
        }
        return false;
    }

    public static boolean hasInScopeTarget(IIndexSee see, AbstractHelpScope scope) {
        if (see instanceof IndexSee) {
            IndexSee indexSee = (IndexSee)see;
            UAElement ancestor = indexSee.getParentElement();
            while (!(ancestor instanceof Index)) {
                if (ancestor == null) {
                    return true;
                }
                ancestor = ancestor.getParentElement();
            }
            IndexEntry target = ((Index)ancestor).getSeeTarget(indexSee);
            if (target == null) {
                return false;
            }
            return ScopeUtils.showInTree((IIndexEntry)target, scope);
        }
        return false;
    }

    public static boolean showInTree(IIndexSee see, AbstractHelpScope scope) {
        if (scope.isHierarchicalScope() && !scope.inScope(see)) {
            return false;
        }
        if (see instanceof IndexSee) {
            IndexSee indexSee = (IndexSee)see;
            UAElement ancestor = indexSee.getParentElement();
            while (!(ancestor instanceof Index)) {
                if (ancestor == null) {
                    return true;
                }
                ancestor = ancestor.getParentElement();
            }
            IndexEntry target = ((Index)ancestor).getSeeTarget(indexSee);
            if (target == null) {
                return false;
            }
            return ScopeUtils.showInTree((IIndexEntry)target, scope);
        }
        return false;
    }

    public static IIndexEntry[] inScopeEntries(IIndexEntry[] entries, AbstractHelpScope scope) {
        int i = 0;
        while (i < entries.length) {
            if (!scope.inScope(entries[i])) {
                ArrayList<IIndexEntry> list = new ArrayList<IIndexEntry>(entries.length);
                int j = 0;
                while (j < entries.length) {
                    if (j < i || scope.inScope(entries[j])) {
                        list.add(entries[j]);
                    }
                    ++j;
                }
                return list.toArray(new IIndexEntry[list.size()]);
            }
            ++i;
        }
        return entries;
    }

    public static ITopic[] inScopeTopics(ITopic[] topics, AbstractHelpScope scope) {
        int i = 0;
        while (i < topics.length) {
            if (!scope.inScope(topics[i])) {
                ArrayList<ITopic> list = new ArrayList<ITopic>(topics.length);
                int j = 0;
                while (j < topics.length) {
                    if (j < i || scope.inScope(topics[j])) {
                        list.add(topics[j]);
                    }
                    ++j;
                }
                return list.toArray(new ITopic[list.size()]);
            }
            ++i;
        }
        return topics;
    }

    public static boolean hasInScopeChildren(IUAElement element, AbstractHelpScope scope) {
        if (element instanceof IToc) {
            return ScopeUtils.hasInScopeDescendent((IToc)element, scope);
        }
        if (element instanceof ITopic) {
            return ScopeUtils.hasInScopeDescendent((ITopic)element, scope);
        }
        if (element instanceof IIndexEntry) {
            return ScopeUtils.hasInScopeDescendent((IIndexEntry)element, scope);
        }
        if (element instanceof IIndexSee) {
            return ScopeUtils.hasInScopeTarget((IIndexSee)element, scope);
        }
        return false;
    }
}

