/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FanRouter;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.LayerConstants;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToGuides;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart.ILayerPanePreference;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart.PageflowContainerEditPart;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.Pageflow;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.synchronization.PFBatchAdapter;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.util.PageflowAnnotationUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.PlatformUI;

public class PageflowEditPart
extends PageflowContainerEditPart
implements LayerConstants,
ILayerPanePreference {
    private static final int CONNECTION_SEPERATION = 20;
    private int connectionStyle = -1;

    protected PageflowEditPart(Pageflow pageflow) {
        super(pageflow);
    }

    protected IFigure createFigure() {
        FreeformLayer layer = new FreeformLayer();
        layer.setLayoutManager((LayoutManager)new FreeformLayout());
        return layer;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("NodeEditPolicy", null);
        this.installEditPolicy("GraphicalNodeEditPolicy", null);
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("Snap Feedback", (EditPolicy)new SnapFeedbackPolicy());
    }

    public Object getAdapter(Class key) {
        if (key == SnapToHelper.class) {
            boolean bSnapToGrid;
            boolean bSnapToGeometry;
            IPreferenceStore store = EditorPlugin.getDefault().getPreferenceStore();
            ArrayList<Object> snapStrategies = new ArrayList<Object>();
            Boolean bRulerVisible = (Boolean)this.getViewer().getProperty("ruler$visibility");
            if (bRulerVisible != null && bRulerVisible.booleanValue()) {
                snapStrategies.add(new SnapToGuides((GraphicalEditPart)this));
            }
            if (bSnapToGeometry = store.getBoolean("SnapToGeometry")) {
                snapStrategies.add(new SnapToGeometry((GraphicalEditPart)this));
            }
            if (bSnapToGrid = store.getBoolean("SnapToGrid")) {
                snapStrategies.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (snapStrategies.size() == 0) {
                return null;
            }
            if (snapStrategies.size() == 1) {
                return snapStrategies.get(0);
            }
            SnapToHelper[] ss = new SnapToHelper[snapStrategies.size()];
            int i = 0;
            while (i < snapStrategies.size()) {
                ss[i] = (SnapToHelper)snapStrategies.get(i);
                ++i;
            }
            return new CompoundSnapToHelper(ss);
        }
        return super.getAdapter(key);
    }

    public Pageflow getPageflow() {
        return (Pageflow)this.getPageflowElement();
    }

    protected List getModelChildren() {
        LinkedList allChildren = new LinkedList();
        Iterator it = this.getPageflow().getNodes().iterator();
        while (it.hasNext()) {
            allChildren.add(it.next());
        }
        return allChildren;
    }

    public Adapter createEMFAdapter() {
        return new PFBatchAdapter(){

            public void doNotifyChanged(Notification notification) {
                int type = notification.getEventType();
                switch (type) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        if (Thread.currentThread() == PlatformUI.getWorkbench().getDisplay().getThread()) {
                            PageflowEditPart.this.refreshChildren();
                            break;
                        }
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                PageflowEditPart.this.refreshChildren();
                            }
                        });
                        break;
                    }
                    case 1: {
                        if (Thread.currentThread() == PlatformUI.getWorkbench().getDisplay().getThread()) {
                            PageflowEditPart.this.refreshChildren();
                            PageflowEditPart.this.refreshVisuals();
                            break;
                        }
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                PageflowEditPart.this.refreshChildren();
                                PageflowEditPart.this.refreshVisuals();
                            }
                        });
                        break;
                    }
                    case 12: {
                        this.restore((Pageflow)PageflowEditPart.this.getModel());
                        if (Thread.currentThread() == PlatformUI.getWorkbench().getDisplay().getThread()) {
                            PageflowEditPart.this.refreshChildren();
                            PageflowEditPart.this.refreshVisuals();
                            break;
                        }
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                PageflowEditPart.this.refreshChildren();
                                PageflowEditPart.this.refreshVisuals();
                            }
                        });
                        break;
                    }
                    case 11: {
                        this.postPone((Pageflow)PageflowEditPart.this.getModel());
                    }
                }
            }

            protected void restore(Pageflow pageflow) {
                TreeIterator nodes = pageflow.eAllContents();
                while (nodes.hasNext()) {
                    this.setPostpone((EObject)nodes.next(), false);
                }
                this.setPostpone(pageflow, false);
            }

            void setPostpone(EObject node, boolean enable) {
                EList adapters = node.eAdapters();
                int i = 0;
                while (i < adapters.size()) {
                    if (adapters.get(i) instanceof PFBatchAdapter) {
                        ((PFBatchAdapter)((Object)adapters.get(i))).setNeedPostpone(enable);
                    }
                    ++i;
                }
            }

            protected void postPone(Pageflow pageflow) {
                TreeIterator nodes = pageflow.eAllContents();
                while (nodes.hasNext()) {
                    this.setPostpone((EObject)nodes.next(), true);
                }
                this.setPostpone(pageflow, true);
            }
        };
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        int i = 0;
        while (i < this.getChildren().size()) {
            ((AbstractEditPart)this.getChildren().get(i)).refresh();
            ++i;
        }
        ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        if (cLayer.getConnectionRouter() == null) {
            this.setConnectionRouterStyle(this.getConnectionRouterStyle());
        }
    }

    protected void refreshChildren() {
        super.refreshChildren();
        PageflowAnnotationUtil.validatePageflow((GraphicalEditPart)this);
    }

    public void setFont(Font f) {
        this.getFigure().setFont(f);
    }

    public void setConnectionRouterStyle(int style) {
        this.connectionStyle = style;
        ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        if (style == 1) {
            FanRouter router = new FanRouter();
            router.setSeparation(20);
            router.setNextRouter((ConnectionRouter)new ManhattanConnectionRouter());
            cLayer.setConnectionRouter((ConnectionRouter)router);
        } else if (style == 0) {
            FanRouter router = new FanRouter();
            router.setSeparation(20);
            router.setNextRouter((ConnectionRouter)new BendpointConnectionRouter());
            cLayer.setConnectionRouter((ConnectionRouter)router);
        }
    }

    public int getConnectionRouterStyle() {
        if (this.connectionStyle == -1) {
            IPreferenceStore store = EditorPlugin.getDefault().getPreferenceStore();
            String connectionStyle_ = store.getString("LineRouting");
            this.connectionStyle = "Manhattan".equals(connectionStyle_) ? 1 : 0;
        }
        return this.connectionStyle;
    }

    public void setForegroundColor(Color c) {
        this.getFigure().setForegroundColor(c);
    }

    public void setBackgroundColor(Color c) {
        this.getLayer("Primary Layer").setBackgroundColor(c);
    }

    public void setGridVisible(boolean bVisible) {
        GridLayer gl = (GridLayer)this.getLayer("Grid Layer");
        gl.setVisible(bVisible);
    }

    public void setGridSpacing(Dimension d) {
        GridLayer gl = (GridLayer)this.getLayer("Grid Layer");
        gl.setSpacing(d);
    }

    public void setGridForegroundColor(Color c) {
        GridLayer gl = (GridLayer)this.getLayer("Grid Layer");
        gl.setForegroundColor(c);
    }

    protected void performDirectEdit() {
    }

    protected void performOpen() {
    }

    public void addAnnotation(Annotation annotation) {
    }

    public void removeAnnotation() {
    }
}

