/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.dnd.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jwt.we.editors.dnd.IDropListenerFactory;
import org.eclipse.jwt.we.misc.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropListenerExtensionPoint {
    public static final String DRAG_N_DROP_EXTENSION_POINT = "org.eclipse.jwt.we.dnd";
    public static final String DROP_LISTENER_FACTORY = "DropListenerFactory";
    private static Logger logger = Logger.getLogger(DropListenerExtensionPoint.class);

    public static List<IDropListenerFactory> getDropListenersFactories() {
        ArrayList<IDropListenerFactory> res = new ArrayList<IDropListenerFactory>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(DRAG_N_DROP_EXTENSION_POINT);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            try {
                res.add((IDropListenerFactory)extension.createExecutableExtension(DROP_LISTENER_FACTORY));
            }
            catch (CoreException ex) {
                logger.severe("Could not load DropFactory for extension " + extension.getName(), ex);
            }
            ++n2;
        }
        return res;
    }
}

