/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.core.internal.grammar;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ldt.core.buildpath.LuaExecutionEnvironment;
import org.eclipse.ldt.core.grammar.IGrammar;
import org.eclipse.ldt.core.grammar.ILuaSourceValidator;
import org.eclipse.ldt.core.internal.Activator;
import org.eclipse.ldt.core.internal.LuaLanguageToolkit;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public final class LuaGrammarManager {
    private static final String EXTENSION_POINT_ID = "org.eclipse.ldt.luaGrammar";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_VALIDATOR = "validator";
    private static final String ATTRIBUTE_KEYWORDS = "keywords";
    private static final String KEYWORDS_SEPARATOR = ",";

    private LuaGrammarManager() {
    }

    private static IConfigurationElement getGrammarContribution(String name) throws CoreException {
        if (name == null) {
            return null;
        }
        IConfigurationElement[] contributions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int i = 0;
        while (i < contributions.length) {
            String nameAttribute = contributions[i].getAttribute(ATTRIBUTE_NAME);
            if (name.equals(nameAttribute)) {
                return contributions[i];
            }
            ++i;
        }
        return null;
    }

    private static IGrammar getGrammarFromContribution(final String name) throws CoreException {
        IConfigurationElement grammarContribution = LuaGrammarManager.getGrammarContribution(name);
        if (grammarContribution != null) {
            final ILuaSourceValidator validator = (ILuaSourceValidator)grammarContribution.createExecutableExtension(ATTRIBUTE_VALIDATOR);
            String keywordsAttribute = grammarContribution.getAttribute(ATTRIBUTE_KEYWORDS);
            final ArrayList<String> keywords = new ArrayList<String>();
            if (keywordsAttribute != null) {
                String[] stringArray = keywordsAttribute.split(KEYWORDS_SEPARATOR);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String word = stringArray[n2];
                    String cleanWord = word.trim();
                    if (!cleanWord.isEmpty()) {
                        keywords.add(cleanWord);
                    }
                    ++n2;
                }
            }
            return new IGrammar(){

                @Override
                public ILuaSourceValidator getValidator() {
                    return validator;
                }

                @Override
                public String getName() {
                    return name;
                }

                @Override
                public List<String> getKeywords() {
                    return keywords;
                }
            };
        }
        return null;
    }

    public static IGrammar getAvailableGrammar(String name) throws CoreException {
        return LuaGrammarManager.getGrammarFromContribution(name);
    }

    public static List<String> getAvailableGrammars() {
        ArrayList<String> grammars = new ArrayList<String>();
        IConfigurationElement[] contributions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int i = 0;
        while (i < contributions.length) {
            String nameAttribute = contributions[i].getAttribute(ATTRIBUTE_NAME);
            if (nameAttribute != null && !nameAttribute.isEmpty()) {
                grammars.add(nameAttribute);
            }
            ++i;
        }
        return grammars;
    }

    private static IGrammar getGrammarWithLua51GrammarFallback(String name) {
        String message;
        try {
            IGrammar defaultGrammar = LuaGrammarManager.getAvailableGrammar(name);
            if (defaultGrammar != null) {
                return defaultGrammar;
            }
        }
        catch (CoreException e) {
            message = String.format("The default grammar %s is not available.", name);
            Activator.logWarning(message, e);
        }
        try {
            return LuaGrammarManager.getAvailableGrammar("lua-5.1");
        }
        catch (CoreException e) {
            message = "The lua 5.1 grammar must be available. Check if you have the org.eclise.ldt.support.lua51 installed!";
            Activator.logError(message, e);
            throw new RuntimeException(message, e);
        }
    }

    public static IGrammar getDefaultGrammar() {
        ScopedPreferenceStore preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, LuaLanguageToolkit.getDefault().getPreferenceQualifier());
        String defaultGrammarID = preferenceStore.getString("Grammar__default_id");
        return LuaGrammarManager.getGrammarWithLua51GrammarFallback(defaultGrammarID);
    }

    public static IGrammar getDefaultGrammarFor(IProject project) {
        IScopeContext[] context = project != null ? new IScopeContext[]{new ProjectScope(project), InstanceScope.INSTANCE} : new IScopeContext[]{InstanceScope.INSTANCE};
        String grammarName = Platform.getPreferencesService().getString(LuaLanguageToolkit.getDefault().getPreferenceQualifier(), "Grammar__default_id", "lua-5.1", context);
        return LuaGrammarManager.getGrammarWithLua51GrammarFallback(grammarName);
    }

    public static IGrammar getDefaultGrammarFor(LuaExecutionEnvironment ee) {
        if (ee == null || ee.getLuaGrammar() == null) {
            return LuaGrammarManager.getDefaultGrammar();
        }
        try {
            IGrammar availableGrammar = LuaGrammarManager.getAvailableGrammar(ee.getLuaGrammar());
            if (availableGrammar != null) {
                return availableGrammar;
            }
        }
        catch (CoreException e) {
            String message = String.format("The default grammar %s for the execution environment %s is not available.", ee.getLuaGrammar(), ee.getEEIdentifier());
            Activator.logWarning(message, e);
        }
        return LuaGrammarManager.getDefaultGrammar();
    }
}

