/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.parser.internal.Messages;
import org.eclipse.mat.parser.internal.StackFrameImpl;
import org.eclipse.mat.parser.internal.ThreadStackImpl;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IThreadStack;
import org.eclipse.mat.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ThreadStackHelper {
    private static final Logger logger = Logger.getLogger(ThreadStackHelper.class.getName());

    ThreadStackHelper() {
    }

    static HashMapIntObject<IThreadStack> loadThreadsData(ISnapshot snapshot) throws SnapshotException {
        String fileName = String.valueOf(snapshot.getSnapshotInfo().getPrefix()) + "threads";
        File f = new File(fileName);
        if (!f.exists()) {
            return null;
        }
        HashMapIntObject threadId2stack = new HashMapIntObject();
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
                String line = in.readLine();
                while (line != null) {
                    if ((line = line.trim()).startsWith("Thread")) {
                        long threadAddress = ThreadStackHelper.readThreadAddres(line);
                        ArrayList<String> lines = new ArrayList<String>();
                        HashMapIntObject line2locals = new HashMapIntObject();
                        line = in.readLine();
                        while (line != null && !line.equals("")) {
                            lines.add(line.trim());
                            line = in.readLine();
                        }
                        line = in.readLine();
                        if (line != null && line.trim().startsWith("locals")) {
                            while ((line = in.readLine()) != null && !line.equals("")) {
                                int objectId;
                                int lineNr = ThreadStackHelper.readLineNumber(line);
                                if (lineNr < 0) continue;
                                try {
                                    objectId = ThreadStackHelper.readLocalId(line, snapshot);
                                }
                                catch (SnapshotException e) {
                                    logger.log(Level.WARNING, MessageUtil.format((String)Messages.ThreadStackHelper_InvalidThreadLocal, (Object[])new Object[]{line.trim(), "0x" + Long.toHexString(threadAddress), e.getLocalizedMessage()}));
                                    continue;
                                }
                                ArrayInt arr = (ArrayInt)line2locals.get(lineNr);
                                if (arr == null) {
                                    arr = new ArrayInt();
                                    line2locals.put(lineNr, (Object)arr);
                                }
                                arr.add(objectId);
                            }
                        }
                        if (threadAddress != -1L) {
                            try {
                                int threadId = snapshot.mapAddressToId(threadAddress);
                                ThreadStackImpl stack = new ThreadStackImpl(threadId, ThreadStackHelper.buildFrames(lines, (HashMapIntObject<ArrayInt>)line2locals));
                                threadId2stack.put(threadId, (Object)stack);
                            }
                            catch (SnapshotException se) {
                                logger.log(Level.WARNING, MessageUtil.format((String)Messages.ThreadStackHelper_InvalidThread, (Object[])new Object[]{"0x" + Long.toHexString(threadAddress), se.getLocalizedMessage()}));
                            }
                        }
                    }
                    if (line != null) {
                        line = in.readLine();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                throw new SnapshotException((Throwable)e);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return threadId2stack;
    }

    private static long readThreadAddres(String line) {
        int start = line.indexOf("0x");
        if (start < 0) {
            return -1L;
        }
        return new BigInteger(line.substring(start + 2), 16).longValue();
    }

    private static int readLocalId(String line, ISnapshot snapshot) throws SnapshotException {
        int start = line.indexOf("0x");
        int end = line.indexOf(44, start);
        long address = new BigInteger(line.substring(start + 2, end), 16).longValue();
        return snapshot.mapAddressToId(address);
    }

    private static int readLineNumber(String line) {
        int start = line.indexOf("line=");
        return Integer.valueOf(line.substring(start + 5));
    }

    private static StackFrameImpl[] buildFrames(List<String> lines, HashMapIntObject<ArrayInt> line2locals) {
        int sz = lines.size();
        StackFrameImpl[] frames = new StackFrameImpl[sz];
        int i = 0;
        while (i < sz) {
            int[] localsIds = null;
            ArrayInt locals = (ArrayInt)line2locals.get(i);
            if (locals != null && locals.size() > 0) {
                localsIds = locals.toArray();
            }
            frames[i] = new StackFrameImpl(lines.get(i), localsIds);
            ++i;
        }
        return frames;
    }
}

